/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.demands;

import java.math.BigInteger;
import java.nio.file.Paths;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.converter.demands.DemandsWriter;
import org.goplanit.converter.idmapping.DemandsIdMapper;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.demands.Demands;
import org.goplanit.io.converter.PlanitWriterImpl;
import org.goplanit.io.converter.demands.PlanitDemandsWriterSettings;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.userclass.UserClass;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.xml.generated.Durationunit;
import org.goplanit.xml.generated.XMLElementDemandConfiguration;
import org.goplanit.xml.generated.XMLElementDuration;
import org.goplanit.xml.generated.XMLElementMacroscopicDemand;
import org.goplanit.xml.generated.XMLElementOdDemands;
import org.goplanit.xml.generated.XMLElementOdRowMatrix;
import org.goplanit.xml.generated.XMLElementTimePeriods;
import org.goplanit.xml.generated.XMLElementTravellerTypes;
import org.goplanit.xml.generated.XMLElementUserClasses;
import org.goplanit.zoning.Zoning;

public class PlanitDemandsWriter
extends PlanitWriterImpl<Demands>
implements DemandsWriter {
    private static final Logger LOGGER = Logger.getLogger(PlanitDemandsWriter.class.getCanonicalName());
    private final PlanitDemandsWriterSettings settings;
    private Zoning referenceZoning;
    private final XMLElementMacroscopicDemand xmlRawDemands;
    private final Map<Mode, Set<UserClass>> userClassesPerMode;

    private void populateXmlTimePeriods(Demands demands, XMLElementDemandConfiguration xmlDemandConfiguration) {
        if (demands.timePeriods == null || demands.timePeriods.isEmpty()) {
            LOGGER.severe("No time periods available on demands, this shouldn't happen");
            return;
        }
        XMLElementTimePeriods xmlTimePeriods = new XMLElementTimePeriods();
        xmlDemandConfiguration.setTimeperiods(xmlTimePeriods);
        demands.timePeriods.streamSortedBy(this.getPrimaryIdMapper().getTimePeriodIdMapper()).forEach(timePeriod -> {
            XMLElementTimePeriods.Timeperiod xmlTimePeriod = new XMLElementTimePeriods.Timeperiod();
            xmlTimePeriods.getTimeperiod().add(xmlTimePeriod);
            xmlTimePeriod.setId((String)this.getPrimaryIdMapper().getTimePeriodIdMapper().apply(timePeriod));
            if (timePeriod.hasExternalId()) {
                xmlTimePeriod.setExternalid(timePeriod.getExternalId());
            }
            if (timePeriod.hasDescription()) {
                xmlTimePeriod.setName(timePeriod.getDescription());
            }
            if (timePeriod.getStartTimeSeconds() > 0L) {
                try {
                    xmlTimePeriod.setStarttime(LocalTime.ofSecondOfDay(timePeriod.getStartTimeSeconds()));
                }
                catch (Exception e) {
                    LOGGER.severe(e.getMessage());
                    throw new PlanItRunTimeException("Error when generating start time of time period " + timePeriod.getXmlId() + " when persisting demand configuration", (Throwable)e);
                }
            }
            if (timePeriod.getDurationSeconds() <= 0L) {
                throw new PlanItRunTimeException("Error duration of time period %s  is not positive, this is not allowed", new Object[]{timePeriod.getXmlId()});
            }
            XMLElementDuration xmlDuration = new XMLElementDuration();
            xmlDuration.setUnit(Durationunit.S);
            xmlDuration.setValue(BigInteger.valueOf(timePeriod.getDurationSeconds()));
            xmlTimePeriod.setDuration(xmlDuration);
        });
    }

    private void populateXmlUserClasses(Demands demands, XMLElementDemandConfiguration xmlDemandConfiguration) {
        if (demands.userClasses == null || demands.userClasses.isEmpty()) {
            LOGGER.severe("No user classes available on demands, this shouldn't happen");
            return;
        }
        XMLElementUserClasses xmlUserClasses = new XMLElementUserClasses();
        xmlDemandConfiguration.setUserclasses(xmlUserClasses);
        demands.userClasses.streamSortedBy(this.getPrimaryIdMapper().getUserClassIdMapper()).forEach(userClass -> {
            XMLElementUserClasses.Userclass xmlUserClass = new XMLElementUserClasses.Userclass();
            xmlUserClasses.getUserclass().add(xmlUserClass);
            xmlUserClass.setId((String)this.getPrimaryIdMapper().getUserClassIdMapper().apply(userClass));
            if (userClass.hasExternalId()) {
                xmlUserClass.setExternalid(userClass.getExternalId());
            }
            if (userClass.getMode() == null) {
                LOGGER.warning(String.format("User class %s has no referenced mode", userClass.getXmlId()));
            } else {
                xmlUserClass.setModeref(this.getXmlModeReference(userClass.getMode(), this.getComponentIdMappers().getNetworkIdMappers().getModeIdMapper()));
                if (!this.userClassesPerMode.containsKey(userClass.getMode())) {
                    HashSet userClassesForMode = new HashSet();
                    this.userClassesPerMode.put(userClass.getMode(), userClassesForMode);
                }
                this.userClassesPerMode.get(userClass.getMode()).add((UserClass)userClass);
            }
            if (userClass.getMode() == null) {
                LOGGER.warning(String.format("User class %s has no referenced traveller type", userClass.getXmlId()));
            } else {
                xmlUserClass.setTravellertyperef((String)this.getPrimaryIdMapper().getTravellerTypeIdMapper().apply(userClass.getTravelerType()));
            }
            if (userClass.hasName()) {
                xmlUserClass.setName(userClass.getName());
            }
        });
    }

    private void populateXmlTravellerTypes(Demands demands, XMLElementDemandConfiguration xmlDemandConfiguration) {
        if (demands.travelerTypes == null || demands.travelerTypes.isEmpty()) {
            LOGGER.severe("No traveller types available on demands, this shouldn't happen");
            return;
        }
        XMLElementTravellerTypes xmlTravellerTypes = new XMLElementTravellerTypes();
        xmlDemandConfiguration.setTravellertypes(xmlTravellerTypes);
        demands.travelerTypes.streamSortedBy(this.getPrimaryIdMapper().getTravellerTypeIdMapper()).forEach(travellerType -> {
            XMLElementTravellerTypes.Travellertype xmlTravellerType = new XMLElementTravellerTypes.Travellertype();
            xmlTravellerTypes.getTravellertype().add(xmlTravellerType);
            xmlTravellerType.setId((String)this.getPrimaryIdMapper().getTravellerTypeIdMapper().apply(travellerType));
            if (travellerType.hasExternalId()) {
                xmlTravellerType.setExternalid(travellerType.getExternalId());
            }
            if (travellerType.hasName()) {
                xmlTravellerType.setName(travellerType.getName());
            }
        });
    }

    private double populateXmlOdRowMatrix(OdDemands odDemandsEntry, TimePeriod timePeriod, UserClass userClass, XMLElementOdRowMatrix xmlOdDemandsEntry) {
        String timePeriodRef = (String)this.getPrimaryIdMapper().getTimePeriodIdMapper().apply(timePeriod);
        xmlOdDemandsEntry.setTimeperiodref(timePeriodRef);
        String userClassRef = (String)this.getPrimaryIdMapper().getUserClassIdMapper().apply(userClass);
        xmlOdDemandsEntry.setUserclassref(userClassRef);
        xmlOdDemandsEntry.setDs(this.settings.getDestinationSeparator());
        List xmlOdRowsList = xmlOdDemandsEntry.getOdrow();
        DoubleAdder totalTripDemandVehH = new DoubleAdder();
        Function zoneIdMapper = this.getComponentIdMappers().getZoningIdMappers().getZoneIdMapper();
        this.referenceZoning.getOdZones().streamSortedBy(zoneIdMapper).forEach(originZone -> {
            XMLElementOdRowMatrix.Odrow xmlOdRow = new XMLElementOdRowMatrix.Odrow();
            xmlOdRow.setRef((String)zoneIdMapper.apply(originZone));
            StringBuilder sb = new StringBuilder();
            this.referenceZoning.getOdZones().streamSortedBy(zoneIdMapper).forEach(destinationZone -> {
                double valueVehH = (Double)odDemandsEntry.getValue((Zone)originZone, (Zone)destinationZone) / userClass.getMode().getPcu();
                totalTripDemandVehH.add(valueVehH);
                sb.append(this.settings.getDecimalFormat().format(valueVehH));
                sb.append(this.settings.getDestinationSeparator());
            });
            xmlOdRow.setValue(sb.toString());
            xmlOdRowsList.add(xmlOdRow);
        });
        return totalTripDemandVehH.doubleValue();
    }

    private void populateXmlOdDemands(Demands demands) {
        XMLElementOdDemands xmlOdDemands = new XMLElementOdDemands();
        this.xmlRawDemands.setOddemands(xmlOdDemands);
        demands.timePeriods.streamSortedBy(this.getPrimaryIdMapper().getTimePeriodIdMapper()).forEach(timePeriod -> {
            Set modes = demands.getRegisteredModesForTimePeriod(timePeriod);
            modes.stream().sorted(Comparator.comparing(this.getComponentIdMappers().getNetworkIdMappers().getModeIdMapper())).forEach(mode -> {
                OdDemands odDemandsEntry = demands.get(mode, timePeriod);
                if (odDemandsEntry != null) {
                    XMLElementOdRowMatrix xmlOdDemandEntryMatrix = new XMLElementOdRowMatrix();
                    xmlOdDemands.getOdcellbycellmatrixOrOdrowmatrixOrOdrawmatrix().add(xmlOdDemandEntryMatrix);
                    if (this.userClassesPerMode.containsKey(mode) && this.userClassesPerMode.get(mode).size() > 1) {
                        throw new PlanItRunTimeException("PLANit demands writer does not yet support multiple user-classes per mode");
                    }
                    UserClass userClass = this.userClassesPerMode.get(mode).iterator().next();
                    double odDemandVehH = this.populateXmlOdRowMatrix(odDemandsEntry, (TimePeriod)timePeriod, userClass, xmlOdDemandEntryMatrix);
                    LOGGER.info(String.format("OD demands matrix: total trips %.2f (veh/h)  %.2f pcu factor , timePeriod: %s, user-class %s", odDemandVehH, userClass.getMode().getPcu(), timePeriod.toString(), userClass.toString()));
                }
            });
        });
    }

    private void populateXmlDemandConfiguration(Demands demands) {
        XMLElementDemandConfiguration demandConfiguration = new XMLElementDemandConfiguration();
        this.xmlRawDemands.setDemandconfiguration(demandConfiguration);
        this.populateXmlTravellerTypes(demands, demandConfiguration);
        this.populateXmlUserClasses(demands, demandConfiguration);
        this.populateXmlTimePeriods(demands, demandConfiguration);
    }

    private void populateXmlId(Demands demands) {
        if (!demands.hasXmlId()) {
            LOGGER.warning(String.format("Demands has no XML id defined, adopting internally generated id %d instead", demands.getId()));
            demands.setXmlId(String.valueOf(demands.getId()));
        }
        this.xmlRawDemands.setId(demands.getXmlId());
    }

    protected PlanitDemandsWriter(PlanitDemandsWriterSettings settings, XMLElementMacroscopicDemand xmlRawDemands) {
        this(settings, null, xmlRawDemands);
    }

    protected PlanitDemandsWriter(PlanitDemandsWriterSettings settings, Zoning referenceZoning, XMLElementMacroscopicDemand xmlRawDemands) {
        super(IdMapperType.XML);
        this.settings = settings;
        this.referenceZoning = referenceZoning;
        this.xmlRawDemands = xmlRawDemands;
        this.userClassesPerMode = new HashMap<Mode, Set<UserClass>>();
    }

    public DemandsIdMapper getPrimaryIdMapper() {
        return this.getComponentIdMappers().getDemandsIdMapperIdMapper();
    }

    public void write(Demands demands) throws PlanItException {
        PlanItException.throwIfNull((Object)demands, (String)"Demands is null cannot write to PLANit native format");
        if (!this.getSettings().validate()) {
            LOGGER.severe("Unable to continue PLANit writing of demands, settings invalid");
            return;
        }
        this.getComponentIdMappers().populateMissingIdMappers(this.getIdMapperType());
        LOGGER.info(String.format("Persisting PLANit demands to: %s", Paths.get(this.getSettings().getOutputDirectory(), this.getSettings().getFileName()).toString()));
        this.getSettings().logSettings();
        this.populateXmlId(demands);
        this.populateXmlDemandConfiguration(demands);
        this.populateXmlOdDemands(demands);
        super.persist(this.xmlRawDemands, XMLElementMacroscopicDemand.class, "macroscopiczoninginput.xsd");
    }

    public void reset() {
        this.xmlRawDemands.setDemandconfiguration(null);
        this.xmlRawDemands.setId(null);
        this.xmlRawDemands.setOddemands(null);
    }

    public PlanitDemandsWriterSettings getSettings() {
        return this.settings;
    }

    public void setReferenceZoning(Zoning referenceZoning) {
        this.referenceZoning = referenceZoning;
    }

    public Zoning getReferenceZoning() {
        return this.referenceZoning;
    }
}

