/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.demands;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.goplanit.converter.BaseReaderImpl;
import org.goplanit.converter.demands.DemandsReader;
import org.goplanit.demands.Demands;
import org.goplanit.demands.DemandsModifierUtils;
import org.goplanit.io.converter.demands.PlanitDemandsReaderSettings;
import org.goplanit.io.converter.zoning.PlanitZoningReader;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.od.demand.OdDemandMatrix;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.userclass.TravellerType;
import org.goplanit.userclass.UserClass;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.wrapper.MapWrapper;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.Zones;
import org.goplanit.xml.generated.Durationunit;
import org.goplanit.xml.generated.XMLElementDemandConfiguration;
import org.goplanit.xml.generated.XMLElementMacroscopicDemand;
import org.goplanit.xml.generated.XMLElementOdCellByCellMatrix;
import org.goplanit.xml.generated.XMLElementOdMatrix;
import org.goplanit.xml.generated.XMLElementOdRawMatrix;
import org.goplanit.xml.generated.XMLElementOdRowMatrix;
import org.goplanit.xml.generated.XMLElementTimePeriods;
import org.goplanit.xml.generated.XMLElementTravellerTypes;
import org.goplanit.xml.generated.XMLElementUserClasses;
import org.goplanit.zoning.Zoning;

public class PlanitDemandsReader
extends BaseReaderImpl<Demands>
implements DemandsReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitDemandsReader.class.getCanonicalName());
    private static final List<String> RESERVED_CHARACTERS = Arrays.asList("+", "*", "^");
    private final PlanitXmlJaxbParser<XMLElementMacroscopicDemand> xmlParser;
    protected final PlanitDemandsReaderSettings settings;
    protected Demands demands;
    protected LayeredNetwork<?, ?> referenceNetwork;
    protected Zoning referenceZoning;
    protected final PlanitZoningReader zoningReader;
    public static final String DEMAND_XSD_FILE = "https://trafficplanit.github.io/PLANitManual/xsd/macroscopicdemandinput.xsd";

    private void syncXmlIdsToIds() {
        LOGGER.info("Syncing PLANit demands XML ids to internally generated ids, overwriting original XML ids");
        DemandsModifierUtils.syncManagedIdEntitiesContainerXmlIdsToIds((Demands)this.demands);
    }

    private void initialiseParentXmlIdTrackers(LayeredNetwork<?, ?> network, Zoning zoning) {
        this.initialiseSourceIdMap(Mode.class, ExternalIdAble::getXmlId, (Iterable)network.getModes());
        this.initialiseSourceIdMap(Zone.class, ExternalIdAble::getXmlId);
        this.getSourceIdContainer(Zone.class).addAll((Iterable)zoning.getOdZones());
        this.getSourceIdContainer(Zone.class).addAll((Iterable)zoning.getTransferZones());
    }

    private void initialiseXmlIdTrackers() {
        this.initialiseSourceIdMap(UserClass.class, ExternalIdAbleImpl::getXmlId);
        this.initialiseSourceIdMap(TravellerType.class, ExternalIdAbleImpl::getXmlId);
        this.initialiseSourceIdMap(TimePeriod.class, ExternalIdAble::getXmlId);
    }

    private static XMLElementTravellerTypes.Travellertype generateDefaultXMLTravellerType() {
        XMLElementTravellerTypes.Travellertype xmlTravellerType = new XMLElementTravellerTypes.Travellertype();
        xmlTravellerType.setId("1");
        xmlTravellerType.setName("Default");
        return xmlTravellerType;
    }

    private static XMLElementUserClasses.Userclass generateDefaultUserClass() {
        XMLElementUserClasses.Userclass xmlUserclass = new XMLElementUserClasses.Userclass();
        xmlUserclass.setName("Default");
        xmlUserclass.setId("1");
        xmlUserclass.setModeref("1");
        xmlUserclass.setTravellertyperef("1");
        return xmlUserclass;
    }

    private static String escapeSeparator(String separator) {
        if (RESERVED_CHARACTERS.contains(separator)) {
            return "\\" + separator;
        }
        return separator;
    }

    private static void populateDemandMatrixRawForEqualSeparators(XMLElementOdRawMatrix.Values values, String separator, double pcu, OdDemandMatrix odDemandMatrix, Zones<?> zones) throws PlanItException {
        String[] allValuesAsString = values.getValue().split(separator);
        int size = allValuesAsString.length;
        int noRows = (int)Math.round(Math.sqrt(size));
        if (noRows * noRows != size) {
            throw new PlanItException("Element <odrawmatrix> contains a string of " + size + " values, which is not an exact square");
        }
        int noCols = noRows;
        for (int i = 0; i < noRows; ++i) {
            int rowOffset = i * noRows;
            Zone originZone = (Zone)zones.get((long)i);
            for (int col = 0; col < noCols; ++col) {
                Zone destinationZone = (Zone)zones.get((long)col);
                double rawDemand = Double.parseDouble(allValuesAsString[rowOffset + col]);
                double demand = rawDemand * pcu;
                odDemandMatrix.setValue(originZone, destinationZone, (Number)demand);
            }
        }
    }

    private static void populateDemandMatrixRawDifferentSeparators(XMLElementOdRawMatrix.Values values, String originSeparator, String destinationSeparator, double pcu, OdDemandMatrix odDemandMatrix, Zones<OdZone> zones) {
        String[] originRows = values.getValue().split(originSeparator);
        int noRows = originRows.length;
        for (int i = 0; i < noRows; ++i) {
            Zone originZone = (Zone)zones.get((long)i);
            String[] destinationValuesByOrigin = originRows[i].split(destinationSeparator);
            int noCols = destinationValuesByOrigin.length;
            if (noRows != noCols) {
                throw new PlanItRunTimeException("Element <odrawmatrix> does not parse to a square matrix: Row " + (i + 1) + " has " + noCols + " values.");
            }
            for (int col = 0; col < noCols; ++col) {
                Zone destinationZone = (Zone)zones.get((long)col);
                double rawDemand = Double.parseDouble(destinationValuesByOrigin[col]);
                double demand = rawDemand * pcu;
                odDemandMatrix.setValue(originZone, destinationZone, (Number)demand);
            }
        }
    }

    private void validateSettings() {
        PlanItRunTimeException.throwIfNull(this.getReferenceNetwork(), (String)"Reference network is null for PLANit demands reader");
        PlanItRunTimeException.throwIfNull((Object)this.getReferenceZoning(), (String)"Reference zoning is null for PLANit demands reader");
    }

    private void generateAndStoreTravelerTypes(XMLElementDemandConfiguration demandconfiguration) {
        XMLElementTravellerTypes xmlTravellertypes;
        XMLElementTravellerTypes xMLElementTravellerTypes = xmlTravellertypes = demandconfiguration.getTravellertypes() == null ? new XMLElementTravellerTypes() : demandconfiguration.getTravellertypes();
        if (xmlTravellertypes.getTravellertype().isEmpty()) {
            xmlTravellertypes.getTravellertype().add(PlanitDemandsReader.generateDefaultXMLTravellerType());
        }
        for (XMLElementTravellerTypes.Travellertype xmlTravellertype : xmlTravellertypes.getTravellertype()) {
            TravellerType travelerType = this.demands.travelerTypes.getFactory().registerNew(xmlTravellertype.getName());
            if (xmlTravellertype.getId() != null && !xmlTravellertype.getId().isBlank()) {
                travelerType.setXmlId(xmlTravellertype.getId());
            }
            if (xmlTravellertype.getExternalid() != null && !xmlTravellertype.getExternalid().isBlank()) {
                travelerType.setExternalId(xmlTravellertype.getExternalid());
            }
            this.registerBySourceId(TravellerType.class, travelerType);
        }
    }

    private int generateAndStoreUserClasses(XMLElementDemandConfiguration demandconfiguration) throws PlanItException {
        XMLElementUserClasses xmlUserclasses;
        XMLElementUserClasses xMLElementUserClasses = xmlUserclasses = demandconfiguration.getUserclasses() == null ? new XMLElementUserClasses() : demandconfiguration.getUserclasses();
        if (xmlUserclasses.getUserclass().isEmpty()) {
            PlanItException.throwIf((this.getReferenceNetwork().getModes().size() > 1 ? 1 : 0) != 0, (String)"user classes must be explicitly defined when more than one mode is defined", (Object[])new Object[0]);
            PlanItException.throwIf((this.demands.travelerTypes.size() > 1 ? 1 : 0) != 0, (String)"user classes must be explicitly defined when more than one traveller type is defined", (Object[])new Object[0]);
            XMLElementUserClasses.Userclass xmlUserClass = PlanitDemandsReader.generateDefaultUserClass();
            xmlUserClass.setTravellertyperef(((TravellerType)this.demands.travelerTypes.getFirst()).getXmlId());
            xmlUserclasses.getUserclass().add(xmlUserClass);
        }
        for (XMLElementUserClasses.Userclass xmlUserclass : xmlUserclasses.getUserclass()) {
            String xmlModeIdRef;
            Mode userClassMode;
            if (xmlUserclass.getTravellertyperef() == null) {
                PlanItException.throwIf((this.demands.travelerTypes.size() > 1 ? 1 : 0) != 0, (String)String.format("User class %s has no traveller type specified, but more than one traveller type possible", xmlUserclass.getId()), (Object[])new Object[0]);
            } else {
                PlanItException.throwIf((this.getBySourceId(TravellerType.class, xmlUserclass.getTravellertyperef()) == null ? 1 : 0) != 0, (String)("travellertyperef value of " + xmlUserclass.getTravellertyperef() + " referenced by user class " + xmlUserclass.getName() + " but not defined"), (Object[])new Object[0]);
            }
            PlanItException.throwIf((xmlUserclass.getModeref() == null ? 1 : 0) != 0, (String)"User class %s has no mode specified, but more than one mode possible", (Object[])new Object[]{xmlUserclass.getId()});
            MapWrapper modesByXmlId = this.getSourceIdContainer(Mode.class);
            if (xmlUserclass.getModeref() == null) {
                PlanItException.throwIf((this.getReferenceNetwork().getModes().size() > 1 ? 1 : 0) != 0, (String)("User class " + xmlUserclass.getId() + " has no mode specified, but more than one mode possible"), (Object[])new Object[0]);
                xmlUserclass.setModeref((String)modesByXmlId.getKeyByValue((Object)((Mode)modesByXmlId.getFirst())));
            }
            PlanItException.throwIf(((userClassMode = (Mode)this.getBySourceId(Mode.class, xmlModeIdRef = xmlUserclass.getModeref())) == null ? 1 : 0) != 0, (String)"User class %s refers to mode %s which has not been defined", (Object[])new Object[]{xmlUserclass.getId(), xmlModeIdRef});
            String travellerTypeXmlIdRef = xmlUserclass.getTravellertyperef() == null ? "1" : xmlUserclass.getTravellertyperef();
            xmlUserclass.setTravellertyperef(travellerTypeXmlIdRef);
            TravellerType travellerType = (TravellerType)this.getBySourceId(TravellerType.class, travellerTypeXmlIdRef);
            UserClass userClass = this.demands.userClasses.getFactory().registerNew(xmlUserclass.getName(), userClassMode, travellerType);
            if (xmlUserclass.getId() != null && !xmlUserclass.getId().isBlank()) {
                userClass.setXmlId(xmlUserclass.getId());
            }
            if (xmlUserclass.getExternalid() != null && !xmlUserclass.getExternalid().isBlank()) {
                userClass.setExternalId(xmlUserclass.getExternalid());
            }
            this.registerBySourceId(UserClass.class, userClass);
        }
        return xmlUserclasses.getUserclass().size();
    }

    private void generateTimePeriodMap(XMLElementDemandConfiguration demandconfiguration) throws PlanItException {
        XMLElementTimePeriods xmlTimeperiods = demandconfiguration.getTimeperiods();
        LocalTime defaultStartTime = LocalTime.MIN;
        for (XMLElementTimePeriods.Timeperiod xmlTimePeriod : xmlTimeperiods.getTimeperiod()) {
            int startTimeSeconds = xmlTimePeriod.getStarttime() == null ? defaultStartTime.toSecondOfDay() : xmlTimePeriod.getStarttime().toSecondOfDay();
            int duration = xmlTimePeriod.getDuration().getValue().intValue();
            Durationunit durationUnit = xmlTimePeriod.getDuration().getUnit();
            if (xmlTimePeriod.getName() == null) {
                xmlTimePeriod.setName("");
            }
            switch (durationUnit) {
                case H: {
                    duration *= 3600;
                    break;
                }
                case M: {
                    duration *= 60;
                    break;
                }
            }
            TimePeriod timePeriod = this.demands.timePeriods.getFactory().registerNew(xmlTimePeriod.getName(), (long)startTimeSeconds, (long)duration);
            if (xmlTimePeriod.getId() != null && !xmlTimePeriod.getId().isBlank()) {
                timePeriod.setXmlId(xmlTimePeriod.getId());
            }
            if (xmlTimePeriod.getExternalid() != null && !xmlTimePeriod.getExternalid().isBlank()) {
                timePeriod.setExternalId(xmlTimePeriod.getExternalid());
            }
            this.registerBySourceId(TimePeriod.class, timePeriod);
        }
    }

    private void populateDemandMatrix(XMLElementOdMatrix xmlOdMatrix, double pcu, OdDemandMatrix odDemandMatrix, Zones<OdZone> zones) throws PlanItException {
        MapWrapper xmlIdZoneMap = this.getSourceIdContainer(Zone.class);
        if (xmlOdMatrix instanceof XMLElementOdCellByCellMatrix) {
            List o = ((XMLElementOdCellByCellMatrix)xmlOdMatrix).getO();
            for (XMLElementOdCellByCellMatrix.O xmlOriginZone : o) {
                Zone originZone = (Zone)xmlIdZoneMap.get((Object)xmlOriginZone.getRef());
                for (XMLElementOdCellByCellMatrix.O.D xmlDestinationZone : xmlOriginZone.getD()) {
                    Zone destinationZone = (Zone)xmlIdZoneMap.get((Object)xmlDestinationZone.getRef());
                    double demand = (double)xmlDestinationZone.getValue() * pcu;
                    odDemandMatrix.setValue(originZone, destinationZone, (Number)demand);
                }
            }
        } else if (xmlOdMatrix instanceof XMLElementOdRowMatrix) {
            XMLElementOdRowMatrix xmlOdRowMatrix = (XMLElementOdRowMatrix)xmlOdMatrix;
            String separator = xmlOdRowMatrix.getDs() == null ? "," : xmlOdRowMatrix.getDs();
            separator = PlanitDemandsReader.escapeSeparator(separator);
            List xmlOdRow = xmlOdRowMatrix.getOdrow();
            ArrayList<Zone> destinationZoneOrderList = new ArrayList<Zone>(xmlOdRow.size());
            for (XMLElementOdRowMatrix.Odrow xmlDestinationZone : xmlOdRow) {
                Zone destinationZone = (Zone)xmlIdZoneMap.get((Object)xmlDestinationZone.getRef());
                destinationZoneOrderList.add(destinationZone);
            }
            for (XMLElementOdRowMatrix.Odrow xmlOriginZone : xmlOdRow) {
                Zone originZone = (Zone)xmlIdZoneMap.get((Object)xmlOriginZone.getRef());
                String[] rowValuesAsString = xmlOriginZone.getValue().split(separator);
                for (int i = 0; i < rowValuesAsString.length; ++i) {
                    Zone destinationZone = (Zone)destinationZoneOrderList.get(i);
                    double demand = Double.parseDouble(rowValuesAsString[i]) * pcu;
                    odDemandMatrix.setValue(originZone, destinationZone, (Number)demand);
                }
            }
        } else if (xmlOdMatrix instanceof XMLElementOdRawMatrix) {
            throw new PlanItRunTimeException("Unable to use ODRaw persistence , see https://github.com/TrafficPLANit/PLANitIO/issues/31");
        }
    }

    protected void setDemands(Demands demands) {
        this.demands = demands;
    }

    protected void populateDemandConfiguration() throws PlanItException {
        XMLElementDemandConfiguration demandconfiguration = this.xmlParser.getXmlRootElement().getDemandconfiguration();
        this.generateAndStoreTravelerTypes(demandconfiguration);
        this.generateAndStoreUserClasses(demandconfiguration);
        this.generateTimePeriodMap(demandconfiguration);
    }

    protected void populateDemandContents() throws PlanItException {
        List oddemands = this.xmlParser.getXmlRootElement().getOddemands().getOdcellbycellmatrixOrOdrowmatrixOrOdrawmatrix();
        for (XMLElementOdMatrix xmlOdMatrix : oddemands) {
            UserClass userClass = null;
            if (xmlOdMatrix.getUserclassref() == null) {
                PlanItException.throwIf((this.demands.userClasses.size() > 1 ? 1 : 0) != 0, (String)"user class must be explicitly set on od matrix when more than one user class exists", (Object[])new Object[0]);
                userClass = (UserClass)this.demands.userClasses.getFirst();
            } else {
                String userClassXmlIdRef = xmlOdMatrix.getUserclassref();
                userClass = (UserClass)this.getBySourceId(UserClass.class, userClassXmlIdRef);
            }
            PlanItException.throwIf((userClass == null ? 1 : 0) != 0, (String)"referenced user class on od matrix not available", (Object[])new Object[0]);
            Mode mode = userClass.getMode();
            String timePeriodXmlIdRef = xmlOdMatrix.getTimeperiodref();
            PlanItException.throwIf((timePeriodXmlIdRef == null ? 1 : 0) != 0, (String)"time period must always be referenced on od matrix", (Object[])new Object[0]);
            TimePeriod timePeriod = (TimePeriod)this.getBySourceId(TimePeriod.class, timePeriodXmlIdRef);
            PlanItException.throwIf((timePeriod == null ? 1 : 0) != 0, (String)"referenced time period on od matrix not available", (Object[])new Object[0]);
            OdZones odZones = this.getReferenceZoning().getOdZones();
            OdDemandMatrix odDemandMatrix = new OdDemandMatrix(odZones);
            this.populateDemandMatrix(xmlOdMatrix, mode.getPcu(), odDemandMatrix, (Zones<OdZone>)odZones);
            OdDemands duplicate = this.demands.registerOdDemandPcuHour(timePeriod, mode, (OdDemands)odDemandMatrix);
            if (duplicate == null) continue;
            throw new PlanItException(String.format("Multiple OD demand matrix encountered for mode-time period combination %s:%s this is not allowed", mode.getXmlId(), timePeriod.getXmlId()));
        }
    }

    public PlanitDemandsReader(XMLElementMacroscopicDemand xmlMacroscopicDemands, LayeredNetwork<?, ?> network, Zoning zoning, Demands demandsToPopulate) {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementMacroscopicDemand>(xmlMacroscopicDemands);
        this.settings = new PlanitDemandsReaderSettings();
        this.setDemands(demandsToPopulate);
        this.zoningReader = null;
        this.referenceNetwork = network;
        this.referenceZoning = zoning;
    }

    public PlanitDemandsReader(PlanitDemandsReaderSettings demandsSettings, LayeredNetwork<?, ?> network, Zoning zoning, Demands demandsToPopulate) {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicDemand>>(XMLElementMacroscopicDemand.class);
        this.settings = demandsSettings;
        this.setDemands(demandsToPopulate);
        this.zoningReader = null;
        this.referenceNetwork = network;
        this.referenceZoning = zoning;
    }

    public PlanitDemandsReader(PlanitDemandsReaderSettings demandsSettings, PlanitZoningReader zoningReader) {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicDemand>>(XMLElementMacroscopicDemand.class);
        this.settings = demandsSettings;
        this.setDemands(null);
        this.zoningReader = zoningReader;
        this.referenceNetwork = null;
        this.referenceZoning = null;
    }

    public Demands read() {
        try {
            if (this.zoningReader != null) {
                PlanItRunTimeException.throwIf((this.referenceNetwork != null ? 1 : 0) != 0, (String)"Expected reference network to be null when using zoning reader on PLANit demands reader", (Object[])new Object[0]);
                PlanItRunTimeException.throwIf((this.referenceZoning != null ? 1 : 0) != 0, (String)"Expected reference zoning to be null when using zoning reader on PLANit demands reader", (Object[])new Object[0]);
                LOGGER.info("Parsing zoning using zoning reader to prepare Demands reader run");
                this.referenceZoning = this.zoningReader.read();
                this.referenceNetwork = this.zoningReader.getReferenceNetwork();
                this.setDemands(new Demands(this.getReferenceNetwork().getNetworkGroupingTokenId()));
            }
            this.validateSettings();
            this.initialiseParentXmlIdTrackers(this.getReferenceNetwork(), this.getReferenceZoning());
            this.initialiseXmlIdTrackers();
            this.xmlParser.initialiseAndParseXmlRootElement(this.settings.getInputDirectory(), this.settings.getXmlFileExtension());
            String demandsXmlId = this.xmlParser.getXmlRootElement().getId();
            if (StringUtils.isNullOrBlank((String)demandsXmlId)) {
                LOGGER.warning(String.format("Demands has no XML id defined, adopting internally generated id %d instead", this.demands.getId()));
                demandsXmlId = String.valueOf(this.demands.getId());
            }
            this.demands.setXmlId(demandsXmlId);
            this.populateDemandConfiguration();
            this.populateDemandContents();
            if (this.getSettings().isSyncXmlIdsToIds()) {
                this.syncXmlIdsToIds();
            }
            this.demands.logInfo(LoggingUtils.demandsPrefix((long)this.demands.getId()));
            this.xmlParser.clearXmlContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Error when populating demands in PLANitIO", (Throwable)e);
        }
        return this.demands;
    }

    public PlanitDemandsReaderSettings getSettings() {
        return this.settings;
    }

    public void reset() {
    }

    public Zoning getReferenceZoning() {
        return this.referenceZoning;
    }

    public LayeredNetwork<?, ?> getReferenceNetwork() {
        return this.referenceNetwork;
    }

    public void setReferenceNetwork(MacroscopicNetwork referenceNetwork) {
        this.referenceNetwork = referenceNetwork;
    }

    public void setReferenceZoning(Zoning referenceZoning) {
        this.referenceZoning = referenceZoning;
    }
}

