/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.converter.CrsWriterImpl;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.io.xml.util.PlanitSchema;
import org.goplanit.io.xml.util.PlanitXmlWriterSettings;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.xml.utils.JAXBUtils;

public abstract class PlanitWriterImpl<T>
extends CrsWriterImpl<T> {
    private static final Logger LOGGER = Logger.getLogger(PlanitWriterImpl.class.getCanonicalName());

    protected PlanitXmlWriterSettings getSettingsAsXmlWriterSettings() {
        if (!(this.getSettings() instanceof PlanitXmlWriterSettings)) {
            throw new PlanItRunTimeException("Planit writer settings expected to be of type PlanitXmlWriterSettings, this is not the case");
        }
        return (PlanitXmlWriterSettings)this.getSettings();
    }

    protected String getXmlModeReference(Mode mode, Function<Mode, String> modeIdMapper) {
        String modeReference = null;
        modeReference = mode.isPredefinedModeType() ? mode.getXmlId() : modeIdMapper.apply(mode);
        if (modeReference == null) {
            LOGGER.severe(String.format("mode reference cound not be obtained for mode %s", mode));
        }
        return modeReference;
    }

    protected void persist(Object xmlRootElement, Class<?> rootElementClazz, String planitSchemaName) {
        PlanitXmlWriterSettings xmlWriterSettings = this.getSettingsAsXmlWriterSettings();
        PlanItRunTimeException.throwIf((xmlWriterSettings.getOutputDirectory() == null || xmlWriterSettings.getOutputDirectory().isBlank() ? 1 : 0) != 0, (String)"no output directory provided, unable to persist in native Planit XML format", (Object[])new Object[0]);
        PlanItRunTimeException.throwIf((xmlWriterSettings.getFileName() == null || xmlWriterSettings.getFileName().isBlank() ? 1 : 0) != 0, (String)"no output file name provided, unable to persist in native Planit XML format", (Object[])new Object[0]);
        Path outputDir = Paths.get(xmlWriterSettings.getOutputDirectory(), new String[0]);
        Path outputPath = Paths.get(xmlWriterSettings.getOutputDirectory(), xmlWriterSettings.getFileName());
        try {
            if (!Files.exists(outputDir, new LinkOption[0])) {
                new File(outputDir.toAbsolutePath().normalize().toString()).mkdirs();
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException(String.format("Unable to create output directory for %s", Paths.get(xmlWriterSettings.getOutputDirectory(), new String[0]).toAbsolutePath()));
        }
        try {
            JAXBUtils.generateXmlFileFromObject((Object)xmlRootElement, rootElementClazz, (Path)outputPath, (String)PlanitSchema.createPlanitSchemaUri(planitSchemaName));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Unable to persist PLANit network in native format");
        }
    }

    protected PlanitWriterImpl(IdMapperType idMapperType) {
        super(idMapperType);
    }
}

