/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EnumSet;
import java.util.logging.Logger;
import org.goplanit.gtfs.entity.GtfsObjectFactory;
import org.goplanit.gtfs.enums.GtfsFileType;
import org.goplanit.gtfs.enums.GtfsKeyType;
import org.goplanit.gtfs.enums.GtfsObjectType;
import org.goplanit.gtfs.scheme.GtfsFileScheme;
import org.goplanit.gtfs.util.GtfsFileConditions;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.misc.UriUtils;
import org.goplanit.utils.misc.UrlUtils;
import org.goplanit.utils.time.ExtendedLocalTime;
import org.goplanit.utils.zip.PlanitZipInputStream;
import org.goplanit.utils.zip.ZipUtils;

public class GtfsUtils {
    private static final Logger LOGGER = Logger.getLogger(GtfsUtils.class.getCanonicalName());

    private static void processGtfsFileNotFound(String fileLocation, GtfsFileConditions filePresenceCondition) {
        if (!filePresenceCondition.isOptional()) {
            if (filePresenceCondition.isConditionallyRequired()) {
                GtfsFileType otherFile = filePresenceCondition.getOtherFileDependency();
                if (filePresenceCondition.isRequiredWhenOtherFileAbsent()) {
                    LOGGER.info(String.format("Conditionally required file %s absent, ok as long as %s is present", fileLocation, otherFile.value()));
                } else {
                    LOGGER.info(String.format("Conditionally required file %s absent, ok as long as %s is absent", fileLocation, otherFile.value()));
                }
            } else {
                LOGGER.warning(String.format("Required file %s absent", fileLocation));
            }
        }
    }

    public static boolean isValidGtfsLocation(URL gtfsLocation) {
        return UrlUtils.isLocalDirectory((URL)gtfsLocation) || UrlUtils.isLocalZipFile((URL)gtfsLocation);
    }

    public static InputStream createInputStream(URL gtfsLocation, GtfsFileScheme fileScheme, GtfsFileConditions filePresenceCondition, boolean logInfo) {
        if (gtfsLocation == null || fileScheme == null || !GtfsUtils.isValidGtfsLocation(gtfsLocation)) {
            return null;
        }
        try {
            if (UriUtils.isInJar((URI)gtfsLocation.toURI())) {
                if (logInfo) {
                    LOGGER.info(String.format("IN JAR %s (not yet supported)", gtfsLocation));
                }
                return null;
            }
            if (UrlUtils.isLocalDirectory((URL)gtfsLocation)) {
                URL gtfsFileUrl = UrlUtils.appendRelativePathToURL((URL)gtfsLocation, (String)fileScheme.getFileType().value());
                if (logInfo) {
                    LOGGER.info(String.format("Creating input stream for local directory: %s, as URL: %s", gtfsLocation, gtfsFileUrl.toString()));
                }
                return GtfsUtils.createFileInputStream(new File(gtfsFileUrl.toURI()), filePresenceCondition);
            }
            if (UrlUtils.isLocalZipFile((URL)gtfsLocation)) {
                if (logInfo) {
                    LOGGER.info(String.format("Creating input stream for local zip file: %s, for internal file: %s", gtfsLocation, fileScheme.getFileType().value()));
                }
                return GtfsUtils.createZipEntryInputStream(gtfsLocation, fileScheme.getFileType().value(), filePresenceCondition, logInfo);
            }
        }
        catch (URISyntaxException e) {
            LOGGER.warning(String.format("Invalid URL/file scheme provided (%s - %s) to create GTFS input stream for", gtfsLocation.toString(), fileScheme.getFileType().value()));
        }
        return null;
    }

    public static InputStream createInputStream(URL gtfsLocation, GtfsFileScheme fileScheme, GtfsFileConditions filePresenceCondition) {
        return GtfsUtils.createInputStream(gtfsLocation, fileScheme, filePresenceCondition, false);
    }

    public static InputStream createZipEntryInputStream(URL gtfsLocation, String zipInternalFileName, GtfsFileConditions filePresenceCondition, boolean logInfo) throws URISyntaxException {
        PlanitZipInputStream zis = null;
        try {
            zis = ZipUtils.createZipEntryInputStream((URL)gtfsLocation, (String)zipInternalFileName, (boolean)logInfo);
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.warning(String.format("Zip file %s not found", gtfsLocation.toString()));
            return null;
        }
        catch (IOException ioe) {
            LOGGER.warning(String.format("IO exception upon creating zip file input stream for %s (message: %s)", gtfsLocation.toString(), ioe.getMessage()));
            return null;
        }
        if (zis == null) {
            GtfsUtils.processGtfsFileNotFound(gtfsLocation.toString(), filePresenceCondition);
        }
        return zis;
    }

    public static FileInputStream createFileInputStream(File gtfsFileLocation, GtfsFileConditions filePresenceCondition) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(gtfsFileLocation);
        }
        catch (FileNotFoundException e) {
            GtfsUtils.processGtfsFileNotFound(gtfsFileLocation.toString(), filePresenceCondition);
        }
        return fis;
    }

    public static EnumSet<GtfsKeyType> getSupportedKeys(GtfsObjectType objectType) {
        return GtfsObjectFactory.create(objectType).getSupportedKeys();
    }

    public static ExtendedLocalTime parseGtfsTime(String gtfsTime) {
        if (StringUtils.isNullOrBlank((String)gtfsTime)) {
            LOGGER.severe(String.format("GTFS time null or blank, ignored", new Object[0]));
        }
        return ExtendedLocalTime.of((String)gtfsTime);
    }
}

