/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerData;
import org.goplanit.gtfs.entity.GtfsStop;
import org.goplanit.gtfs.util.GtfsLinkSegmentHelper;
import org.goplanit.utils.geo.GeoContainerUtils;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.opengis.referencing.operation.MathTransform;

public class GtfsTransferZoneHelper {
    private static final Logger LOGGER = Logger.getLogger(GtfsTransferZoneHelper.class.getCanonicalName());

    public static TransferZone createAndRegisterNewTransferZone(GtfsStop gtfsStop, Point projectedGtfsStopLocation, TransferZoneType type, GtfsZoningHandlerData data) {
        TransferZone transferZone = data.getZoning().getTransferZones().getFactory().registerNew(type, true);
        transferZone.setGeometry((Geometry)projectedGtfsStopLocation);
        transferZone.setExternalId(gtfsStop.getStopId());
        transferZone.setName(gtfsStop.getStopName());
        transferZone.addTransferZonePlatformName(gtfsStop.getPlatformCode());
        data.getProfiler().incrementCreatedTransferZones();
        return transferZone;
    }

    public static String getLastTransferZoneExternalId(TransferZone transferZone) {
        String[] splitExternalId = transferZone.getSplitExternalId(CharacterUtils.COMMA.charValue());
        return splitExternalId == null ? "" : splitExternalId[splitExternalId.length - 1];
    }

    public static boolean isGtfsStopOnCorrectSideOfTransferZoneAccessLinkSegments(GtfsStop gtfsStop, Mode gtfsMode, TransferZone transferZone, GtfsZoningHandlerData data, boolean allConnectoidsMustMatch) {
        boolean leftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive((String)data.getSettings().getCountryName());
        Set<Object> connectoids = data.getTransferZoneConnectoids(transferZone);
        if (connectoids == null || connectoids.isEmpty()) {
            LOGGER.warning(String.format("Cannot determine of GTFS stop (%s) is on correct side of transfer zone (%s) access links since transfer zone has no connectoids associated with it, this shouldn't happen", gtfsStop.getStopId(), transferZone.getXmlId()));
            return false;
        }
        if ((connectoids = connectoids.stream().filter(c -> c.isModeAllowed((Zone)transferZone, gtfsMode)).collect(Collectors.toUnmodifiableSet())) == null || connectoids.isEmpty()) {
            return false;
        }
        boolean success = false;
        for (DirectedConnectoid directedConnectoid : connectoids) {
            LinkSegment accessSegment = directedConnectoid.getAccessLinkSegment();
            Geometry localProjection = PlanitJtsUtils.transformGeometry((Geometry)gtfsStop.getLocationAsPoint(), (MathTransform)data.getCrsTransform());
            boolean bl = success = success || localProjection != null && GtfsLinkSegmentHelper.isGeometryOnCorrectSideOfLinkSegment(localProjection, accessSegment, leftHandDrive, data.getGeoTools());
            if (!allConnectoidsMustMatch || success) continue;
            break;
        }
        return success;
    }

    public static Pair<TransferZone, Double> findTransferZoneStopLocationClosestTo(Coordinate gtfsStopLocation, Collection<TransferZone> nearbyTransferZones, GtfsZoningHandlerData data) {
        TransferZone closest = nearbyTransferZones.iterator().next();
        if (nearbyTransferZones.size() == 1) {
            return Pair.of((Object)closest, (Object)PlanitEntityGeoUtils.getDistanceToZone((Coordinate)gtfsStopLocation, (Zone)closest, (PlanitJtsCrsUtils)data.getGeoTools()));
        }
        double minDistance = Double.POSITIVE_INFINITY;
        boolean allowCentroidGeometry = true;
        for (TransferZone transferZone : nearbyTransferZones) {
            Set<DirectedConnectoid> directedConnectoids = data.getTransferZoneConnectoids(transferZone);
            if (directedConnectoids == null || directedConnectoids.isEmpty()) {
                Coordinate planitTransferZoneStopLocation = transferZone.getGeometry(true).getCentroid().getCoordinate();
                double distance = data.getGeoTools().getDistanceInMetres(gtfsStopLocation, planitTransferZoneStopLocation);
                if (!(minDistance > distance)) continue;
                closest = transferZone;
                minDistance = distance;
                continue;
            }
            for (DirectedConnectoid dirConnectoid : directedConnectoids) {
                Coordinate planitTransferZoneStopLocation = dirConnectoid.getAccessNode().getPosition().getCoordinate();
                double distance = data.getGeoTools().getDistanceInMetres(gtfsStopLocation, planitTransferZoneStopLocation);
                if (!(minDistance > distance)) continue;
                closest = transferZone;
                minDistance = distance;
            }
        }
        return Pair.of((Object)closest, (Object)minDistance);
    }

    public static Collection<TransferZone> findNearbyTransferZones(Point location, double pointSearchRadiusMeters, GtfsZoningHandlerData data) {
        Envelope searchEnvelope = data.getGeoTools().createBoundingBox(location.getX(), location.getY(), pointSearchRadiusMeters);
        searchEnvelope = PlanitJtsUtils.transformEnvelope((Envelope)searchEnvelope, (MathTransform)data.getCrsTransform());
        return GeoContainerUtils.queryZoneQuadtree((Quadtree)data.getGeoIndexedPreExistingTransferZones(), (Envelope)searchEnvelope);
    }
}

