/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.service.routed.modifier.event.handler.SyncDeparturesXmlIdToIdHandler;
import org.goplanit.service.routed.modifier.event.handler.SyncRoutedServicesXmlIdToIdHandler;
import org.goplanit.service.routed.modifier.event.handler.SyncRoutedTripsXmlIdToIdHandler;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.modifier.RoutedServicesModifierListener;

public class GtfsRoutedServicesModifierUtils {
    private static void forEachLayerRegisterListenersAndApply(Consumer<RoutedServicesLayer> consumer, List<RoutedServicesModifierListener> listeners, RoutedServices routedServices) {
        for (RoutedServicesLayer layer : routedServices.getLayers()) {
            if (listeners != null) {
                listeners.forEach(l -> layer.getLayerModifier().addListener(l));
            }
            consumer.accept(layer);
            if (listeners == null) continue;
            listeners.forEach(l -> layer.getLayerModifier().removeListener(l));
        }
    }

    public static void groupIdenticallyScheduledPlanitTrips(RoutedServices routedServices) {
        Consumer<RoutedServicesLayer> consolidationLambda = layer -> {
            for (Mode mode : layer.getSupportedModesWithServices()) {
                layer.getLayerModifier().consolidateIdenticallyScheduledTrips(mode);
            }
        };
        GtfsRoutedServicesModifierUtils.forEachLayerRegisterListenersAndApply(consolidationLambda, null, routedServices);
        Consumer<RoutedServicesLayer> recreateIdsLambda = layer -> layer.getLayerModifier().recreateRoutedTripsIds();
        GtfsRoutedServicesModifierUtils.forEachLayerRegisterListenersAndApply(recreateIdsLambda, List.of(new SyncRoutedTripsXmlIdToIdHandler()), routedServices);
    }

    public static void removeScheduledTripsWithoutLegs(RoutedServices routedServices) {
        Consumer<RoutedServicesLayer> removeTripsWithoutLegsOnLayerLambda = layer -> {
            Collection supportedModes = layer.getSupportedModes();
            supportedModes.forEach(mode -> layer.getLayerModifier().removeScheduledTripsWithoutLegs(true, new Mode[]{mode}));
        };
        GtfsRoutedServicesModifierUtils.forEachLayerRegisterListenersAndApply(removeTripsWithoutLegsOnLayerLambda, List.of(new SyncRoutedTripsXmlIdToIdHandler(), new SyncDeparturesXmlIdToIdHandler()), routedServices);
    }

    public static void removeServiceRoutesWithoutTrips(RoutedServices routedServices) {
        Consumer<RoutedServicesLayer> removeServiceRoutesWithoutTripsOnLayerLambda = layer -> {
            Collection supportedModes = layer.getSupportedModes();
            supportedModes.forEach(mode -> layer.getLayerModifier().removeRoutedServicesWithoutTrips(true, new Mode[]{mode}));
        };
        GtfsRoutedServicesModifierUtils.forEachLayerRegisterListenersAndApply(removeServiceRoutesWithoutTripsOnLayerLambda, List.of(new SyncRoutedServicesXmlIdToIdHandler()), routedServices);
    }

    public static void removeEmptyRoutedServices(RoutedServices routedServices) {
        GtfsRoutedServicesModifierUtils.forEachLayerRegisterListenersAndApply(l -> l.getLayerModifier().removeEmptyRoutedServicesByMode(true), List.of(new SyncRoutedServicesXmlIdToIdHandler()), routedServices);
    }

    public static void removeDuplicateTripDepartures(RoutedServices routedServices) {
        GtfsRoutedServicesModifierUtils.forEachLayerRegisterListenersAndApply(l -> l.getLayerModifier().removeDuplicateTripDepartures(true), List.of(new SyncDeparturesXmlIdToIdHandler()), routedServices);
    }
}

