/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerData;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;

public class GtfsLinkSegmentHelper {
    public static boolean isGeometryOnCorrectSideOfLinkSegment(Geometry geometry, LinkSegment linkSegment, boolean shouldBeOnLeft, PlanitJtsCrsUtils geoTools) {
        LineSegment finalLineSegment = PlanitEntityGeoUtils.extractClosestLineSegmentToGeometryFromLinkSegment((Geometry)geometry, (LinkSegment)linkSegment, (PlanitJtsCrsUtils)geoTools);
        return shouldBeOnLeft == geoTools.isGeometryLeftOf(geometry, finalLineSegment.p0, finalLineSegment.p1);
    }

    public static double getAzimuthFromLinkSegmentToCoordinate(LinkSegment linkSegment, Coordinate coordinate, GtfsZoningHandlerData data) {
        PlanItRunTimeException.throwIfNull((Object)linkSegment, (String)"LinkSegment is null");
        PlanItRunTimeException.throwIfNull((Object)coordinate, (String)"Coordinate is null");
        LineString linkSegmentGeometry = linkSegment.getParent().getGeometry();
        LinearLocation closestLinkIntersect = data.getGeoTools().getClosestProjectedLinearLocationOnLineString(coordinate, linkSegmentGeometry);
        Coordinate closestLinkIntersectCoordinate = closestLinkIntersect.getCoordinate((Geometry)linkSegmentGeometry);
        DirectPosition dirPos1 = data.getGeoTools().toDirectPosition(closestLinkIntersectCoordinate);
        DirectPosition dirPos2 = data.getGeoTools().toDirectPosition(coordinate);
        return data.getGeoTools().getAzimuthInDegrees((Position)dirPos1, (Position)dirPos2, true);
    }
}

