/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerData;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.GeoContainerUtils;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.misc.CollectionUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.ConnectoidUtils;
import org.goplanit.zoning.modifier.event.handler.UpdateDirectedConnectoidsOnBreakLinkSegmentHandler;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.linearref.LinearLocation;
import org.opengis.referencing.operation.MathTransform;

public class GtfsLinkHelper {
    public static Collection<MacroscopicLink> findNearbyLinks(Point location, double pointSearchRadiusMeters, GtfsZoningHandlerData data) {
        Envelope searchEnvelope = data.getGeoTools().createBoundingBox(location.getX(), location.getY(), pointSearchRadiusMeters);
        searchEnvelope = PlanitJtsUtils.transformEnvelope((Envelope)searchEnvelope, (MathTransform)data.getCrsTransform());
        return GeoContainerUtils.queryEdgeQuadtree((Quadtree)data.getGeoIndexedLinks(), (Envelope)searchEnvelope);
    }

    public static Pair<Node, Boolean> extractNodeByLinkGeometryLocation(Point gtfsStopNodeLocation, MacroscopicLink referenceLink, MacroscopicNetworkLayer networkLayer, GtfsZoningHandlerData data) {
        PlanItRunTimeException.throwIfNull((Object)gtfsStopNodeLocation, (String)"Stop node location is null, not allowed");
        PlanItRunTimeException.throwIfNull((Object)referenceLink, (String)"Designated access link for GTFS stop is null, not allowed");
        double extremeNodeMaxDistanceMeters = 5.0;
        Node planitNode = data.getGeoTools().isDistanceWithinMetres(referenceLink.getNodeA().getPosition(), gtfsStopNodeLocation, 5.0) ? referenceLink.getNodeA() : null;
        Node node = planitNode = data.getGeoTools().isDistanceWithinMetres(referenceLink.getNodeB().getPosition(), gtfsStopNodeLocation, 5.0) ? referenceLink.getNodeB() : planitNode;
        if (planitNode != null) {
            return Pair.of((Object)planitNode, (Object)Boolean.FALSE);
        }
        int existingCoordinatePosition = PlanitJtsUtils.findFirstCoordinatePosition((Coordinate)gtfsStopNodeLocation.getCoordinate(), (LineString)referenceLink.getGeometry(), (double)1.0E-6).orElse(-1);
        if (existingCoordinatePosition < 0) {
            LinearLocation projectedLinearLocationOnLink = PlanitEntityGeoUtils.extractClosestProjectedLinearLocationToGeometryFromEdge((Geometry)gtfsStopNodeLocation, (Edge)referenceLink, (PlanitJtsCrsUtils)data.getGeoTools());
            referenceLink.updateGeometryInjectCoordinateAtProjectedLocation(projectedLinearLocationOnLink);
            existingCoordinatePosition = PlanitJtsUtils.findFirstCoordinatePosition((Coordinate)gtfsStopNodeLocation.getCoordinate(), (LineString)referenceLink.getGeometry(), (double)1.0E-6).orElse(-1);
        }
        gtfsStopNodeLocation = PlanitJtsUtils.createPoint((Coordinate)referenceLink.getGeometry().getCoordinateN(existingCoordinatePosition));
        planitNode = networkLayer.getNodes().getFactory().registerNew(gtfsStopNodeLocation, true);
        Map connectoidsAccessNodeLocationBeforeBreakLink = ConnectoidUtils.findDirectedConnectoidsReferencingLinks(List.of(referenceLink), data.getDirectedConnectoidsByLocation(networkLayer));
        UpdateDirectedConnectoidsOnBreakLinkSegmentHandler listener = new UpdateDirectedConnectoidsOnBreakLinkSegmentHandler(connectoidsAccessNodeLocationBeforeBreakLink);
        GtfsLinkHelper.breakLinksAtPlanitNode(planitNode, networkLayer, referenceLink, List.of(listener), data);
        return Pair.of((Object)planitNode, (Object)Boolean.TRUE);
    }

    public static void breakLinksAtPlanitNode(Node planitNode, MacroscopicNetworkLayer networkLayer, MacroscopicLink linkToBreak, Collection<GraphModifierListener> temporaryListeners, GtfsZoningHandlerData data) {
        if (!CollectionUtils.nullOrEmpty(temporaryListeners)) {
            temporaryListeners.forEach(l -> networkLayer.getLayerModifier().addListener(l));
        }
        data.removeGeoIndexedLink(linkToBreak);
        Map newlyBrokenLinks = networkLayer.getLayerModifier().breakAt((DirectedEdge)linkToBreak, (DirectedVertex)planitNode, data.getGeoTools().getCoordinateReferenceSystem());
        newlyBrokenLinks.forEach((id, linkPair) -> data.addGeoIndexedLinks((MacroscopicLink)linkPair.first(), (MacroscopicLink)linkPair.second()));
        if (!CollectionUtils.nullOrEmpty(temporaryListeners)) {
            temporaryListeners.forEach(l -> networkLayer.getLayerModifier().removeListener(l));
        }
    }
}

