/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import org.goplanit.gtfs.enums.GtfsFileType;
import org.goplanit.gtfs.enums.GtfsFileTypePresence;

public class GtfsFileConditions {
    private final GtfsFileTypePresence presenceCondition;
    private final GtfsFileType requiredWhenAbsent;
    private final GtfsFileType requiredWhenPresent;

    protected GtfsFileConditions(GtfsFileTypePresence presenceCondition, GtfsFileType requiredWhenAbsent, GtfsFileType requiredWhenPresent) {
        this.presenceCondition = presenceCondition;
        this.requiredWhenAbsent = requiredWhenAbsent;
        this.requiredWhenPresent = requiredWhenPresent;
    }

    public static GtfsFileConditions required() {
        return new GtfsFileConditions(GtfsFileTypePresence.REQUIRED, null, null);
    }

    public static GtfsFileConditions optional() {
        return new GtfsFileConditions(GtfsFileTypePresence.OTPTIONAL, null, null);
    }

    public static GtfsFileConditions requiredInPresenceOf(GtfsFileType otherFileType) {
        return new GtfsFileConditions(GtfsFileTypePresence.CONDITIONALLY_REQUIRED, null, otherFileType);
    }

    public static GtfsFileConditions requiredInAbsenceOf(GtfsFileType otherFileType) {
        return new GtfsFileConditions(GtfsFileTypePresence.CONDITIONALLY_REQUIRED, otherFileType, null);
    }

    public boolean isRequired() {
        return this.presenceCondition.equals((Object)GtfsFileTypePresence.REQUIRED);
    }

    public boolean isConditionallyRequired() {
        return this.presenceCondition.equals((Object)GtfsFileTypePresence.CONDITIONALLY_REQUIRED);
    }

    public boolean isOptional() {
        return this.presenceCondition.equals((Object)GtfsFileTypePresence.OTPTIONAL);
    }

    public GtfsFileType getOtherFileDependency() {
        return this.requiredWhenAbsent == null ? this.requiredWhenPresent : this.requiredWhenAbsent;
    }

    public boolean isRequiredWhenOtherFilePresent() {
        return this.isRequired() || this.isConditionallyRequired() && this.requiredWhenAbsent == null;
    }

    public boolean isRequiredWhenOtherFileAbsent() {
        return this.isRequired() || this.isConditionallyRequired() && this.requiredWhenAbsent != null;
    }
}

