/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import java.util.Collection;
import java.util.Set;
import org.goplanit.converter.zoning.ZoningConverterUtils;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerData;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.zoning.Zoning;

public class GtfsDirectedConnectoidHelper {
    public static Collection<DirectedConnectoid> createAndRegisterDirectedConnectoids(TransferZone transferZone, MacroscopicNetworkLayer networkLayer, Node accessNode, Iterable<? extends EdgeSegment> linkSegments, Set<Mode> allowedModes, GtfsZoningHandlerData data) {
        Collection createdConnectoids = ZoningConverterUtils.createAndRegisterDirectedConnectoids((Zoning)data.getZoning(), (TransferZone)transferZone, (Node)accessNode, linkSegments, allowedModes);
        for (DirectedConnectoid newConnectoid : createdConnectoids) {
            data.addDirectedConnectoidByLocation(networkLayer, newConnectoid.getAccessNode().getPosition(), newConnectoid);
            data.registerTransferZoneToConnectoidModes(transferZone, newConnectoid, allowedModes);
            data.getProfiler().incrementCreatedConnectoids();
        }
        return createdConnectoids;
    }
}

