/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettingsWithModeMapping;
import org.goplanit.gtfs.converter.service.GtfsServicesReaderSettings;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.mode.ModesImpl;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PredefinedModeType;

public class GtfsConverterReaderHelper {
    private static final Logger LOGGER = Logger.getLogger(GtfsConverterReaderHelper.class.getCanonicalName());

    public static HashMap<RouteType, List<Mode>> createCombinedActivatedPlanitModes(GtfsConverterReaderSettingsWithModeMapping settings, Modes allAvailablePlanitModes) {
        Set<PredefinedModeType> predefinedModeTypes = settings.getAcivatedPlanitPredefinedModes();
        Set planitModeInstances = predefinedModeTypes.stream().map(pmt -> allAvailablePlanitModes.get(pmt)).filter(e -> e != null).collect(Collectors.toSet());
        HashMap<RouteType, List<Mode>> gtfsModeToPlanitModeMapping = new HashMap<RouteType, List<Mode>>();
        Collection<RouteType> activatedGtfsModes = settings.getAcivatedGtfsModes();
        for (RouteType gtfsMode : activatedGtfsModes) {
            List<PredefinedModeType> mappedPredefinedPlanitModes = settings.getAcivatedPlanitPredefinedModes(gtfsMode);
            List availablePlanitModeInstances = planitModeInstances.stream().filter(m -> m.isPredefinedModeType() && mappedPredefinedPlanitModes.contains(m.getPredefinedModeType())).collect(Collectors.toList());
            gtfsModeToPlanitModeMapping.put(gtfsMode, availablePlanitModeInstances);
        }
        return gtfsModeToPlanitModeMapping;
    }

    public static void addToModeExternalId(Mode planitMode, RouteType gtfsMode) {
        if (planitMode != null) {
            String gtfsModeId = String.valueOf(gtfsMode.getValue());
            if (planitMode.hasExternalId() && !planitMode.containsExternalId(';', gtfsModeId)) {
                planitMode.appendExternalId(gtfsModeId, Character.valueOf(';'));
            } else {
                planitMode.setExternalId(gtfsModeId);
            }
        }
    }

    public static void syncActivatedPlanitPredefinedModesBeforeParsing(GtfsServicesReaderSettings settings, MacroscopicNetwork network) {
        IdGroupingToken token = IdGroupingToken.create((String)"temp");
        ModesImpl gtfsActivatedModes = new ModesImpl(token);
        settings.getAcivatedPlanitPredefinedModes().stream().forEach(mt -> gtfsActivatedModes.getFactory().registerNew(mt));
        Set supportedTrackTypes = network.getModes().stream().filter(m -> m.hasPhysicalFeatures()).map(m -> m.getPhysicalFeatures().getTrackType()).collect(Collectors.toSet());
        for (Mode gtfsActivatedMode : gtfsActivatedModes) {
            if (supportedTrackTypes.contains(gtfsActivatedMode.getPhysicalFeatures().getTrackType())) {
                network.getModes().getFactory().registerNew(gtfsActivatedMode.getPredefinedModeType());
                continue;
            }
            LOGGER.warning(String.format("DISCARD: Deactivating GTFS mode %s because its track type %s is not present on any mode [%s] in the physical network", gtfsActivatedMode.getPredefinedModeType(), gtfsActivatedMode.getPhysicalFeatures().getTrackType(), network.getModes().stream().map(m -> m.getName()).collect(Collectors.joining(","))));
            List<RouteType> gtfsRouteTypesToDeactivate = settings.getAcivatedGtfsModes(gtfsActivatedMode.getPredefinedModeType());
            settings.deactivateGtfsModes(gtfsRouteTypesToDeactivate);
        }
        IdGenerator.reset((IdGroupingToken)token);
    }
}

