/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.scheme;

import java.util.logging.Logger;
import org.goplanit.gtfs.enums.GtfsFileType;
import org.goplanit.gtfs.scheme.GtfsAgenciesScheme;
import org.goplanit.gtfs.scheme.GtfsAttributionsScheme;
import org.goplanit.gtfs.scheme.GtfsCalendarDatesScheme;
import org.goplanit.gtfs.scheme.GtfsCalendarsScheme;
import org.goplanit.gtfs.scheme.GtfsFareAttributesScheme;
import org.goplanit.gtfs.scheme.GtfsFareRulesScheme;
import org.goplanit.gtfs.scheme.GtfsFeedInfoScheme;
import org.goplanit.gtfs.scheme.GtfsFileScheme;
import org.goplanit.gtfs.scheme.GtfsFrequenciesScheme;
import org.goplanit.gtfs.scheme.GtfsLevelsScheme;
import org.goplanit.gtfs.scheme.GtfsPathwaysScheme;
import org.goplanit.gtfs.scheme.GtfsRoutesScheme;
import org.goplanit.gtfs.scheme.GtfsShapesScheme;
import org.goplanit.gtfs.scheme.GtfsStopTimesScheme;
import org.goplanit.gtfs.scheme.GtfsStopsScheme;
import org.goplanit.gtfs.scheme.GtfsTransfersScheme;
import org.goplanit.gtfs.scheme.GtfsTranslationsScheme;
import org.goplanit.gtfs.scheme.GtfsTripsScheme;

public class GtfsFileSchemeFactory {
    private static final Logger LOGGER = Logger.getLogger(GtfsFileSchemeFactory.class.getCanonicalName());

    public static GtfsFileScheme create(GtfsFileType fileType) {
        switch (fileType) {
            case AGENCIES: {
                return new GtfsAgenciesScheme();
            }
            case ATTRIBUTIONS: {
                return new GtfsAttributionsScheme();
            }
            case CALENDAR_DATES: {
                return new GtfsCalendarDatesScheme();
            }
            case CALENDARS: {
                return new GtfsCalendarsScheme();
            }
            case FARE_ATTRIBUTES: {
                return new GtfsFareAttributesScheme();
            }
            case FARE_RULES: {
                return new GtfsFareRulesScheme();
            }
            case FEED_INFO: {
                return new GtfsFeedInfoScheme();
            }
            case FREQUENCIES: {
                return new GtfsFrequenciesScheme();
            }
            case LEVELS: {
                return new GtfsLevelsScheme();
            }
            case PATHWAYS: {
                return new GtfsPathwaysScheme();
            }
            case ROUTES: {
                return new GtfsRoutesScheme();
            }
            case SHAPES: {
                return new GtfsShapesScheme();
            }
            case STOP_TIMES: {
                return new GtfsStopTimesScheme();
            }
            case STOPS: {
                return new GtfsStopsScheme();
            }
            case TRANSFERS: {
                return new GtfsTransfersScheme();
            }
            case TRANSLATIONS: {
                return new GtfsTranslationsScheme();
            }
            case TRIPS: {
                return new GtfsTripsScheme();
            }
        }
        LOGGER.warning(String.format("Unsupported GTFS file type %s", new Object[]{fileType}));
        return null;
    }
}

