/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.reader;

import java.net.URL;
import java.util.logging.Logger;
import org.goplanit.gtfs.enums.GtfsColumnType;
import org.goplanit.gtfs.reader.GtfsFileReaderAgencies;
import org.goplanit.gtfs.reader.GtfsFileReaderAttributions;
import org.goplanit.gtfs.reader.GtfsFileReaderBase;
import org.goplanit.gtfs.reader.GtfsFileReaderCalendarDates;
import org.goplanit.gtfs.reader.GtfsFileReaderCalendars;
import org.goplanit.gtfs.reader.GtfsFileReaderFareAttributes;
import org.goplanit.gtfs.reader.GtfsFileReaderFareRules;
import org.goplanit.gtfs.reader.GtfsFileReaderFeedInfo;
import org.goplanit.gtfs.reader.GtfsFileReaderFrequencies;
import org.goplanit.gtfs.reader.GtfsFileReaderLevels;
import org.goplanit.gtfs.reader.GtfsFileReaderPathways;
import org.goplanit.gtfs.reader.GtfsFileReaderRoutes;
import org.goplanit.gtfs.reader.GtfsFileReaderShapes;
import org.goplanit.gtfs.reader.GtfsFileReaderStopTimes;
import org.goplanit.gtfs.reader.GtfsFileReaderStops;
import org.goplanit.gtfs.reader.GtfsFileReaderTransfers;
import org.goplanit.gtfs.reader.GtfsFileReaderTranslations;
import org.goplanit.gtfs.reader.GtfsFileReaderTrips;
import org.goplanit.gtfs.reader.GtfsReader;
import org.goplanit.gtfs.scheme.GtfsFileScheme;
import org.goplanit.gtfs.util.GtfsFileConditions;
import org.goplanit.utils.misc.UrlUtils;

public class GtfsReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(GtfsReaderFactory.class.getCanonicalName());

    public static GtfsReader createDefaultReader(URL gtfsLocation) {
        return new GtfsReader(gtfsLocation, GtfsColumnType.ALL_COLUMNS);
    }

    public static GtfsFileReaderBase createFileReader(GtfsFileScheme fileScheme, String gtfsLocation) {
        return GtfsReaderFactory.createFileReader(fileScheme, UrlUtils.createFromLocalPathOrResource((String)gtfsLocation));
    }

    public static GtfsFileReaderBase createFileReader(GtfsFileScheme fileScheme, String gtfsLocation, GtfsColumnType columnType) {
        return GtfsReaderFactory.createFileReader(fileScheme, UrlUtils.createFromLocalPathOrResource((String)gtfsLocation), columnType);
    }

    public static GtfsFileReaderBase createFileReader(GtfsFileScheme fileScheme, URL gtfsLocation) {
        return GtfsReaderFactory.createFileReader(fileScheme, gtfsLocation, GtfsColumnType.ALL_COLUMNS);
    }

    public static GtfsFileReaderBase createFileReader(GtfsFileScheme fileScheme, URL gtfsLocation, GtfsColumnType columnType) {
        return GtfsReaderFactory.createFileReader(fileScheme, gtfsLocation, columnType, GtfsFileConditions.required());
    }

    public static GtfsFileReaderBase createFileReader(GtfsFileScheme fileScheme, URL gtfsLocation, GtfsColumnType columnType, GtfsFileConditions conditions) {
        GtfsFileReaderBase createdReader = null;
        switch (fileScheme.getFileType()) {
            case AGENCIES: {
                createdReader = new GtfsFileReaderAgencies(gtfsLocation, conditions);
                break;
            }
            case ATTRIBUTIONS: {
                createdReader = new GtfsFileReaderAttributions(gtfsLocation, conditions);
                break;
            }
            case CALENDARS: {
                createdReader = new GtfsFileReaderCalendars(gtfsLocation, conditions);
                break;
            }
            case CALENDAR_DATES: {
                createdReader = new GtfsFileReaderCalendarDates(gtfsLocation, conditions);
                break;
            }
            case FARE_ATTRIBUTES: {
                createdReader = new GtfsFileReaderFareAttributes(gtfsLocation, conditions);
                break;
            }
            case FARE_RULES: {
                createdReader = new GtfsFileReaderFareRules(gtfsLocation, conditions);
                break;
            }
            case FEED_INFO: {
                createdReader = new GtfsFileReaderFeedInfo(gtfsLocation, conditions);
                break;
            }
            case FREQUENCIES: {
                createdReader = new GtfsFileReaderFrequencies(gtfsLocation, conditions);
                break;
            }
            case LEVELS: {
                createdReader = new GtfsFileReaderLevels(gtfsLocation, conditions);
                break;
            }
            case PATHWAYS: {
                createdReader = new GtfsFileReaderPathways(gtfsLocation, conditions);
                break;
            }
            case ROUTES: {
                createdReader = new GtfsFileReaderRoutes(gtfsLocation, conditions);
                break;
            }
            case SHAPES: {
                createdReader = new GtfsFileReaderShapes(gtfsLocation, conditions);
                break;
            }
            case TRANSFERS: {
                createdReader = new GtfsFileReaderTransfers(gtfsLocation, conditions);
                break;
            }
            case TRANSLATIONS: {
                createdReader = new GtfsFileReaderTranslations(gtfsLocation, conditions);
                break;
            }
            case TRIPS: {
                createdReader = new GtfsFileReaderTrips(gtfsLocation, conditions);
                break;
            }
            case STOP_TIMES: {
                createdReader = new GtfsFileReaderStopTimes(gtfsLocation, conditions);
                break;
            }
            case STOPS: {
                createdReader = new GtfsFileReaderStops(gtfsLocation, conditions);
                break;
            }
            default: {
                LOGGER.warning(String.format("Unable to create GTFS file reader for given scheme %s", fileScheme));
                return null;
            }
        }
        createdReader.initialiseColumnConfiguration(columnType);
        return createdReader;
    }
}

