/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.reader;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.gtfs.entity.GtfsObject;
import org.goplanit.gtfs.enums.GtfsColumnType;
import org.goplanit.gtfs.enums.GtfsFileType;
import org.goplanit.gtfs.handler.GtfsFileHandler;
import org.goplanit.gtfs.reader.GtfsFileReaderBase;
import org.goplanit.gtfs.reader.GtfsReaderFactory;
import org.goplanit.gtfs.util.GtfsFileConditions;
import org.goplanit.gtfs.util.GtfsUtils;

public class GtfsReader {
    private static final Logger LOGGER = Logger.getLogger(GtfsReader.class.getCanonicalName());
    private final Map<GtfsFileType, GtfsFileReaderBase> fileReaders = new HashMap<GtfsFileType, GtfsFileReaderBase>();
    private final GtfsColumnType gtfsColumnConfiguration;
    private final URL gtfsLocation;

    private void read(GtfsFileType gtfsFileType, GtfsFileConditions gtfsFileCondition, Charset charSet) {
        if (this.fileReaders.containsKey((Object)gtfsFileType)) {
            GtfsFileReaderBase fileReader = this.fileReaders.get((Object)gtfsFileType);
            fileReader.setPresenceCondition(gtfsFileCondition);
            fileReader.read(charSet);
        }
    }

    protected GtfsReader(URL gtfsLocation, GtfsColumnType gtfsColumnConfiguration) {
        this.gtfsColumnConfiguration = gtfsColumnConfiguration;
        boolean validGtfsLocation = GtfsUtils.isValidGtfsLocation(gtfsLocation);
        URL uRL = this.gtfsLocation = validGtfsLocation ? gtfsLocation : null;
        if (!validGtfsLocation) {
            LOGGER.warning(String.format("Provided GTFS location (%s)is neither a directory nor a zip file, unable to instantiate reader", gtfsLocation));
        }
    }

    public void read(Charset charSet) {
        if (this.gtfsLocation == null) {
            return;
        }
        this.read(GtfsFileType.AGENCIES, GtfsFileConditions.required(), charSet);
        this.read(GtfsFileType.STOPS, GtfsFileConditions.required(), charSet);
        this.read(GtfsFileType.ROUTES, GtfsFileConditions.required(), charSet);
        this.read(GtfsFileType.TRIPS, GtfsFileConditions.required(), charSet);
        this.read(GtfsFileType.STOP_TIMES, GtfsFileConditions.required(), charSet);
        this.read(GtfsFileType.CALENDARS, GtfsFileConditions.requiredInAbsenceOf(GtfsFileType.CALENDAR_DATES), charSet);
        this.read(GtfsFileType.CALENDAR_DATES, GtfsFileConditions.requiredInAbsenceOf(GtfsFileType.CALENDARS), charSet);
        this.read(GtfsFileType.FARE_ATTRIBUTES, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.FARE_RULES, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.SHAPES, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.FREQUENCIES, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.TRANSFERS, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.PATHWAYS, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.LEVELS, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.FEED_INFO, GtfsFileConditions.requiredInPresenceOf(GtfsFileType.TRANSLATIONS), charSet);
        this.read(GtfsFileType.TRANSLATIONS, GtfsFileConditions.optional(), charSet);
        this.read(GtfsFileType.ATTRIBUTIONS, GtfsFileConditions.optional(), charSet);
    }

    public GtfsFileReaderBase addFileHandler(GtfsFileHandler<? extends GtfsObject> gtfsFileHandler) {
        if (gtfsFileHandler == null) {
            LOGGER.warning("Provided GFTSFileHandler is null, cannot be registered on GTFSReader");
            return null;
        }
        if (this.gtfsLocation == null) {
            return null;
        }
        GtfsFileType fileType = gtfsFileHandler.getFileScheme().getFileType();
        GtfsFileReaderBase fileReader = null;
        if (!this.fileReaders.containsKey((Object)fileType)) {
            fileReader = GtfsReaderFactory.createFileReader(gtfsFileHandler.getFileScheme(), this.gtfsLocation, this.gtfsColumnConfiguration);
            this.fileReaders.put(fileType, fileReader);
        } else {
            fileReader = this.fileReaders.get((Object)fileType);
        }
        fileReader.addHandler(gtfsFileHandler);
        return fileReader;
    }
}

