/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.reader;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.goplanit.gtfs.enums.GtfsKeyType;

public class GtfsFileReaderSettings {
    private final Set<GtfsKeyType> excludedColumns = new HashSet<GtfsKeyType>();
    private boolean logFileInputStreamInformation = false;

    public void excludeColumns(GtfsKeyType ... columnsToExclude) {
        Arrays.stream(columnsToExclude).forEach(key -> this.excludedColumns.add((GtfsKeyType)((Object)key)));
    }

    public void excludeColumns(Iterator<GtfsKeyType> columnsToExcludeIter) {
        columnsToExcludeIter.forEachRemaining(key -> this.excludedColumns.add((GtfsKeyType)((Object)key)));
    }

    public Set<GtfsKeyType> getExcludedColumns() {
        return Collections.unmodifiableSet(this.excludedColumns);
    }

    public boolean isExcludedColumn(GtfsKeyType column) {
        return this.excludedColumns.contains((Object)column);
    }

    public void setLogGtfsFileInputStreamInfo(boolean flag) {
        this.logFileInputStreamInformation = flag;
    }

    public boolean isLogGtfsFileInputStreamInfo() {
        return this.logFileInputStreamInformation;
    }
}

