/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.reader;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.goplanit.gtfs.entity.GtfsObject;
import org.goplanit.gtfs.entity.GtfsObjectFactory;
import org.goplanit.gtfs.enums.GtfsColumnType;
import org.goplanit.gtfs.enums.GtfsKeyType;
import org.goplanit.gtfs.handler.GtfsFileHandler;
import org.goplanit.gtfs.reader.GtfsFileReaderSettings;
import org.goplanit.gtfs.scheme.GtfsFileScheme;
import org.goplanit.gtfs.util.GtfsFileConditions;
import org.goplanit.gtfs.util.GtfsUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.StringUtils;

public abstract class GtfsFileReaderBase {
    private static final Logger LOGGER = Logger.getLogger(GtfsFileReaderBase.class.getCanonicalName());
    private final GtfsFileScheme fileScheme;
    private final URL gtfsLocation;
    private final Set<GtfsFileHandler<? extends GtfsObject>> handlers;
    private final GtfsFileReaderSettings settings;
    private GtfsFileConditions filePresenceCondition;

    private boolean isValid(Map<String, Integer> headerMap) {
        EnumSet<GtfsKeyType> supportedKeys = GtfsUtils.getSupportedKeys(this.fileScheme.getObjectType());
        boolean unsupportedColumns = false;
        for (String headerEntry : headerMap.keySet()) {
            if (GtfsKeyType.valueIn(supportedKeys, headerEntry.trim())) continue;
            LOGGER.warning(String.format("Encountered unknown GTFS column header (%s), column will be ignored", headerEntry));
            unsupportedColumns = true;
        }
        return !unsupportedColumns;
    }

    private Map<String, GtfsKeyType> mapHeadersToGtfsKeys(Map<String, Integer> headerMap) {
        HashMap<String, GtfsKeyType> headerToKeyMap = new HashMap<String, GtfsKeyType>();
        for (String headerEntry : headerMap.keySet()) {
            String comparableHeaderEntry = StringUtils.removeBOM((String)headerEntry.trim()).toLowerCase();
            GtfsKeyType.fromValue(comparableHeaderEntry).ifPresent(key -> headerToKeyMap.put(headerEntry, (GtfsKeyType)((Object)key)));
        }
        return headerToKeyMap;
    }

    private Map<String, GtfsKeyType> filterExcludedColumns(Map<String, GtfsKeyType> gtfsFileColumns) {
        HashMap<String, GtfsKeyType> filteredColumns = new HashMap<String, GtfsKeyType>(gtfsFileColumns);
        Iterator columnIter = filteredColumns.values().iterator();
        while (columnIter.hasNext()) {
            GtfsKeyType column = (GtfsKeyType)((Object)columnIter.next());
            if (!this.getSettings().isExcludedColumn(column)) continue;
            columnIter.remove();
        }
        return filteredColumns;
    }

    private long parseGtfsRecords(CSVParser csvParser, Map<String, GtfsKeyType> columnsToParse) {
        LongAdder numRecords = new LongAdder();
        for (CSVRecord gtfsEntryRecord : csvParser) {
            GtfsObject gtfsObject = GtfsObjectFactory.create(this.fileScheme.getObjectType());
            for (Map.Entry<String, GtfsKeyType> entry : columnsToParse.entrySet()) {
                GtfsKeyType key = entry.getValue();
                String value = gtfsEntryRecord.get(entry.getKey());
                gtfsObject.put(key, value);
            }
            for (GtfsFileHandler gtfsFileHandler : this.handlers) {
                gtfsFileHandler.handleRaw(gtfsObject);
            }
            numRecords.increment();
        }
        for (GtfsFileHandler<? extends GtfsObject> handler : this.handlers) {
            handler.handleComplete();
        }
        return numRecords.longValue();
    }

    public void setPresenceCondition(GtfsFileConditions filePresenceCondition) {
        this.filePresenceCondition = filePresenceCondition;
    }

    protected GtfsFileReaderBase(GtfsFileScheme fileScheme, URL gtfsLocation) {
        this(fileScheme, gtfsLocation, new GtfsFileReaderSettings());
    }

    protected GtfsFileReaderBase(GtfsFileScheme fileScheme, URL gtfsLocation, GtfsFileConditions filePresenceCondition) {
        this(fileScheme, gtfsLocation, filePresenceCondition, new GtfsFileReaderSettings());
    }

    protected void initialiseColumnConfiguration(GtfsColumnType columnType) {
        switch (columnType) {
            case NO_COLUMNS: {
                this.getSettings().excludeColumns(GtfsUtils.getSupportedKeys(this.getFileScheme().getObjectType()).iterator());
                return;
            }
            case ALL_COLUMNS: {
                return;
            }
        }
        LOGGER.severe(String.format("Chosen GTFS column configuration (%s) not supported by base reader implementation", new Object[]{columnType}));
    }

    protected GtfsFileReaderBase(GtfsFileScheme fileScheme, URL gtfsLocation, GtfsFileReaderSettings settings) {
        this(fileScheme, gtfsLocation, GtfsFileConditions.required(), settings);
    }

    protected GtfsFileReaderBase(GtfsFileScheme fileScheme, URL gtfsLocation, GtfsFileConditions filePresenceCondition, GtfsFileReaderSettings settings) {
        this.fileScheme = fileScheme;
        this.settings = settings;
        this.filePresenceCondition = filePresenceCondition;
        this.handlers = new HashSet<GtfsFileHandler<? extends GtfsObject>>();
        boolean validGtfsLocation = GtfsUtils.isValidGtfsLocation(gtfsLocation);
        URL uRL = this.gtfsLocation = validGtfsLocation ? gtfsLocation : null;
        if (!validGtfsLocation) {
            LOGGER.warning(String.format("Provided GTFS location (%s)is neither a directory nor a zip file, unable to instantiate file reader", gtfsLocation));
        }
    }

    public void read(Charset charSetToUse) {
        try (InputStream gtfsInputStream = GtfsUtils.createInputStream(this.gtfsLocation, this.fileScheme, this.filePresenceCondition, this.settings.isLogGtfsFileInputStreamInfo());){
            if (gtfsInputStream != null) {
                InputStreamReader gtfsInputReader = new InputStreamReader(gtfsInputStream, charSetToUse);
                CSVParser csvParser = new CSVParser((Reader)gtfsInputReader, CSVFormat.DEFAULT.withHeader(new String[0]));
                Map headerWithBom = csvParser.getHeaderMap();
                HashMap<String, Integer> headerMap = new HashMap<String, Integer>();
                headerWithBom.forEach((k, v) -> headerMap.put(StringUtils.removeBOM((String)k), (Integer)v));
                if (!this.isValid(headerMap)) {
                    LOGGER.warning(String.format("Header for %s - %s contains ignored columns, ", this.gtfsLocation, this.fileScheme.getFileType().value()));
                }
                long numRecords = this.parseGtfsRecords(csvParser, this.filterExcludedColumns(this.mapHeadersToGtfsKeys(headerWithBom)));
                if (this.settings.isLogGtfsFileInputStreamInfo()) {
                    LOGGER.info(String.format("Processed %d records from input stream", numRecords));
                }
                csvParser.close();
                ((Reader)gtfsInputReader).close();
                gtfsInputStream.close();
            } else {
                LOGGER.warning(String.format("Empty input stream for (location: %s, scheme: %s", this.gtfsLocation.toString(), this.fileScheme));
            }
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Error during parsing of GTFS file (%s - %s)", this.gtfsLocation.toString(), this.fileScheme.getFileType().value()));
            throw new PlanItRunTimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void addHandler(GtfsFileHandler<? extends GtfsObject> handler) {
        if (!handler.isCompatible(this.fileScheme)) {
            LOGGER.warning(String.format("DISCARD: GTFS handler incompatible with GTFS file reader for %s", this.fileScheme.toString()));
        }
        this.handlers.add(handler);
    }

    public GtfsFileScheme getFileScheme() {
        return this.fileScheme;
    }

    public GtfsFileReaderSettings getSettings() {
        return this.settings;
    }

    public void reset() {
        this.handlers.forEach(h -> h.reset());
    }
}

