/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.enums;

import java.util.logging.Logger;
import org.goplanit.utils.enums.EnumOf;
import org.goplanit.utils.enums.EnumValue;
import org.goplanit.utils.misc.StringUtils;

public enum StopLocationType implements EnumOf<StopLocationType, Short>,
EnumValue<Short>
{
    STOP_PLATFORM(0),
    STATION(1),
    ENTRANCE_EXIT(2),
    GENERIC_NODE(3),
    BOARDING_AREA(4);

    private static final Logger LOGGER;
    private final short value;

    private static StopLocationType dummyInstance() {
        return StopLocationType.values()[0];
    }

    private StopLocationType(short value) {
        this.value = value;
    }

    public Short getValue() {
        return this.value;
    }

    public static StopLocationType of(Short value) {
        return (StopLocationType)((Object)StopLocationType.dummyInstance().createFromValues(StopLocationType::values, value));
    }

    public static StopLocationType parseFrom(String value) {
        try {
            if (StringUtils.isNullOrBlank((String)value)) {
                return STOP_PLATFORM;
            }
            return StopLocationType.of(Short.valueOf(value));
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Unable to convert %s as short, cannot extract GTFS Stop Location Type", value));
            return null;
        }
    }

    static {
        LOGGER = Logger.getLogger(StopLocationType.class.getCanonicalName());
    }
}

