/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.enums;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.utils.enums.EnumOf;
import org.goplanit.utils.enums.EnumValue;

public enum RouteType implements EnumOf<RouteType, Short>,
EnumValue<Short>
{
    TRAM_LIGHTRAIL(0),
    SUBWAY_METRO(1),
    RAIL(2),
    BUS(3),
    FERRY(4),
    CABLE_TRAM(5),
    AERIAL(6),
    FUNICULAR(7),
    TROLLEY_BUS(11),
    MONO_RAIL(12),
    RAILWAY_SERVICE(100),
    HIGH_SPEED_RAIL_SERVICE(101),
    LONG_DISTANCE_TRAINS(102),
    INTER_REGIONAL_RAIL_SERVICE(103),
    CAR_TRANSPORT_RAIL_SERVICE(104),
    SLEEPER_RAIL_SERVICE(105),
    REGIONAL_RAIL_SERVICE(106),
    TOURIST_RAILWAY_SERVICE(107),
    RAIL_SHUTTLE_IN_COMPLEX(108),
    SUBURBAN_RAILWAY(109),
    REPLACEMENT_RAIL_SERVICE(110),
    SPECIAL_RAIL_SERVICE(111),
    LORRY_TRANSPORT_RAIL_SERVICE(112),
    ALL_RAIL_SERVICES(113),
    CROSS_COUNTRY_RAIL_SERVICE(114),
    VEHICLE_TRANSPORT_RAIL_SERVICE(115),
    RACK_AND_PINION_RAILWAY(116),
    ADDITIONAL_RAIL_SERVICE(117),
    COACH_SERVICE(200),
    INTERNATIONAL_COACH_SERVICE(201),
    NATIONAL_COACH_SERVICE(202),
    SHUTTLE_COACH_SERVICE(203),
    REGIONAL_COACH_SERVICE(204),
    SPECIAL_COACH_SERVICE(205),
    SIGHTSEEING_COACH_SERVICE(206),
    TOURIST_COACH_SERVICE(207),
    COMMUTER_COACH_SERVICE(208),
    ALL_COACH_SERVICES(209),
    URBAN_RAILWAY_SERVICE(400),
    METRO_SERVICE(401),
    UNDERGROUND_SERVICE(402),
    URBAN_RAILWAY_SERVICE_ALT(403),
    ALL_URBAN_RAILWAY_SERVICES(404),
    MONORAIL(405),
    BUS_SERVICE(700),
    REGIONAL_BUS_SERVICE(701),
    EXPRESS_BUS_SERVICE(702),
    STOPPING_BUS_SERVICE(703),
    LOCAL_BUS_SERVICE(704),
    NIGHT_BUS_SERVICE(705),
    POST_BUS_SERVICE(706),
    SPECIAL_NEEDS_BUS(707),
    MOBILITY_BUS_SERVICE(708),
    MOBILITY_BUS_FOR_REGISTERED_DISABLED(709),
    SIGHTSEEING_BUS(710),
    SHUTTLE_BUS(711),
    SCHOOL_BUS(712),
    SCHOOL_AND_PUBLIC_SERVICE_BUS(713),
    RAIL_REPLACEMENT_BUS_SERVICE(714),
    DEMAND_AND_RESPONSE_BUS_SERVICE(715),
    ALL_BUS_SERVICES(716),
    TROLLEYBUS_SERVICE(800),
    TRAM_SERVICE(900),
    CITY_TRAM_SERVICE(901),
    LOCAL_TRAM_SERVICE(902),
    REGIONAL_TRAM_SERVICE(903),
    SIGHTSEEING_TRAM_SERVICE(904),
    SHUTTLE_TRAM_SERVICE(905),
    ALL_TRAM_SERVICES(906),
    WATER_TRANSPORT_SERVICE(1000),
    AIR_SERVICE(1100),
    FERRY_SERVICE(1200),
    AERIAL_LIFT_SERVICE(1300),
    FUNICULAR_SERVICE(1400),
    TAXI_SERVICE(1500),
    COMMUNAL_TAXI_SERVICE(1501),
    WATER_TAXI_SERVICE(1502),
    RAIL_TAXI_SERVICE(1503),
    BIKE_TAXI_SERVICE(1504),
    LICENSED_TAXI_SERVICE(1505),
    PRIVATE_HIRE_SERVICE_VEHICLE(1506),
    ALL_TAXI_SERVICES(1507),
    MISCELLANEOUS_SERVICE(1700),
    HORSE_DRAWN_CARRIAGE(1702);

    private static final Logger LOGGER;
    private final short value;

    private static RouteType dummyInstance() {
        return RouteType.values()[0];
    }

    private RouteType(short value) {
        this.value = value;
    }

    public Short getValue() {
        return this.value;
    }

    public static RouteType of(short value) {
        return (RouteType)((Object)RouteType.dummyInstance().createFromValues(RouteType::values, value));
    }

    public static RouteType parseFrom(String value) {
        try {
            return RouteType.of(Short.valueOf(value));
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Unable to convert %s as short, cannot extract GTFS Stop Location Type", value));
            return null;
        }
    }

    public static Set<RouteType> getInValueRange(short minValue, short maxValue) {
        HashSet<RouteType> found = new HashSet<RouteType>();
        for (short i = minValue; i <= maxValue; i = (short)(i + 1)) {
            RouteType currValue = RouteType.of(i);
            if (currValue == null) continue;
            found.add(currValue);
        }
        return found;
    }

    static {
        LOGGER = Logger.getLogger(RouteType.class.getCanonicalName());
    }
}

