/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.entity;

import java.util.EnumSet;
import org.goplanit.gtfs.entity.GtfsObject;
import org.goplanit.gtfs.enums.GtfsKeyType;
import org.goplanit.gtfs.enums.StopLocationType;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.misc.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

public class GtfsStop
extends GtfsObject {
    public static final EnumSet<GtfsKeyType> SUPPORTED_KEYS = EnumSet.of(GtfsKeyType.STOP_ID, new GtfsKeyType[]{GtfsKeyType.STOP_CODE, GtfsKeyType.STOP_NAME, GtfsKeyType.STOP_DESC, GtfsKeyType.STOP_LAT, GtfsKeyType.STOP_LON, GtfsKeyType.ZONE_ID, GtfsKeyType.STOP_URL, GtfsKeyType.LOCATION_TYPE, GtfsKeyType.PARENT_STATION, GtfsKeyType.STOP_TIMEZONE, GtfsKeyType.WHEELCHAIR_BOARDING, GtfsKeyType.LEVEL_ID, GtfsKeyType.PLATFORM_CODE});

    @Override
    public EnumSet<GtfsKeyType> getSupportedKeys() {
        return SUPPORTED_KEYS;
    }

    public String getStopId() {
        return this.get(GtfsKeyType.STOP_ID);
    }

    public String getStopName() {
        return this.get(GtfsKeyType.STOP_NAME);
    }

    public boolean hasStopName() {
        return !StringUtils.isNullOrBlank((String)this.getStopName());
    }

    public boolean hasPlatformCode() {
        return !StringUtils.isNullOrBlank((String)this.getPlatformCode());
    }

    public String getPlatformCode() {
        return this.get(GtfsKeyType.PLATFORM_CODE);
    }

    public StopLocationType getLocationType() {
        return StopLocationType.parseFrom(this.getLocationTypeRaw());
    }

    public String getLocationTypeRaw() {
        return this.get(GtfsKeyType.LOCATION_TYPE);
    }

    public String getStopLatitude() {
        return this.get(GtfsKeyType.STOP_LAT);
    }

    public String getStopLongitude() {
        return this.get(GtfsKeyType.STOP_LON);
    }

    public Coordinate getLocationAsCoord() {
        return new Coordinate(Double.valueOf(this.getStopLongitude()).doubleValue(), Double.valueOf(this.getStopLatitude()).doubleValue());
    }

    public void setLocationAsCoord(Coordinate locationAsCoord) {
        this.put(GtfsKeyType.STOP_LON, String.valueOf(locationAsCoord.x));
        this.put(GtfsKeyType.STOP_LAT, String.valueOf(locationAsCoord.y));
    }

    public Point getLocationAsPoint() {
        try {
            return PlanitJtsUtils.createPoint((Coordinate)this.getLocationAsCoord());
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to transform geometry of GTFS stop %s to PLANit network CRS", new Object[]{this.getStopId()});
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("STOP: ");
        super.appendKeyValues(sb);
        return sb.toString();
    }
}

