/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.entity;

import java.util.EnumSet;
import org.goplanit.gtfs.entity.GtfsObject;
import org.goplanit.gtfs.enums.GtfsKeyType;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.utils.misc.StringUtils;

public class GtfsRoute
extends GtfsObject {
    public static final EnumSet<GtfsKeyType> SUPPORTED_KEYS = EnumSet.of(GtfsKeyType.ROUTE_ID, new GtfsKeyType[]{GtfsKeyType.AGENCY_ID, GtfsKeyType.ROUTE_SHORT_NAME, GtfsKeyType.ROUTE_LONG_NAME, GtfsKeyType.ROUTE_DESC, GtfsKeyType.ROUTE_TYPE, GtfsKeyType.ROUTE_URL, GtfsKeyType.ROUTE_COLOR, GtfsKeyType.ROUTE_TEXT_COLOR, GtfsKeyType.ROUTE_SORT_ORDER, GtfsKeyType.CONTINUOUS_PICKUP, GtfsKeyType.CONTINUOUS_DROP_OFF});

    @Override
    public EnumSet<GtfsKeyType> getSupportedKeys() {
        return SUPPORTED_KEYS;
    }

    public String getRouteId() {
        return this.get(GtfsKeyType.ROUTE_ID);
    }

    public String getRouteTypeRaw() {
        return this.get(GtfsKeyType.ROUTE_TYPE);
    }

    public RouteType getRouteType() {
        return RouteType.parseFrom(this.getRouteTypeRaw());
    }

    public String getShortName() {
        return this.get(GtfsKeyType.ROUTE_SHORT_NAME);
    }

    public String getLongName() {
        return this.get(GtfsKeyType.ROUTE_LONG_NAME);
    }

    public String getRouteDescription() {
        return this.get(GtfsKeyType.ROUTE_DESC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ROUTE: ");
        super.appendKeyValues(sb);
        return sb.toString();
    }

    public boolean hasShortName() {
        return !StringUtils.isNullOrBlank((String)this.getShortName());
    }

    public boolean hasLongName() {
        return !StringUtils.isNullOrBlank((String)this.getLongName());
    }

    public boolean hasRouteDescription() {
        return !StringUtils.isNullOrBlank((String)this.getRouteDescription());
    }

    public boolean hasValidName() {
        return this.hasShortName() || this.hasLongName();
    }
}

