/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.entity;

import java.util.EnumMap;
import java.util.EnumSet;
import org.goplanit.gtfs.enums.GtfsKeyType;

public abstract class GtfsObject {
    EnumMap<GtfsKeyType, String> keyValueMap = new EnumMap(GtfsKeyType.class);

    protected void appendKeyValues(StringBuilder sb) {
        this.keyValueMap.forEach((k, v) -> {
            sb.append(k.value());
            sb.append(" ");
            sb.append(v == null ? "n/a" : v);
            sb.append(", ");
        });
        sb.deleteCharAt(sb.length() - 1);
    }

    public String get(GtfsKeyType key) {
        return this.keyValueMap.get((Object)key);
    }

    public String put(GtfsKeyType key, String value) {
        return this.keyValueMap.put(key, value);
    }

    public boolean containsKey(GtfsKeyType key) {
        return this.keyValueMap.containsKey((Object)key);
    }

    public abstract EnumSet<GtfsKeyType> getSupportedKeys();
}

