/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.entity;

import java.time.DayOfWeek;
import java.util.Collection;
import java.util.EnumSet;
import org.goplanit.gtfs.entity.GtfsObject;
import org.goplanit.gtfs.enums.GtfsKeyType;
import org.goplanit.utils.exceptions.PlanItRunTimeException;

public class GtfsCalendar
extends GtfsObject {
    public static final EnumSet<GtfsKeyType> SUPPORTED_KEYS = EnumSet.of(GtfsKeyType.SERVICE_ID, new GtfsKeyType[]{GtfsKeyType.MONDAY, GtfsKeyType.TUESDAY, GtfsKeyType.WEDNESDAY, GtfsKeyType.THURSDAY, GtfsKeyType.FRIDAY, GtfsKeyType.SATURDAY, GtfsKeyType.SUNDAY, GtfsKeyType.START_DATE, GtfsKeyType.END_DATE});

    @Override
    public EnumSet<GtfsKeyType> getSupportedKeys() {
        return SUPPORTED_KEYS;
    }

    public static DayOfWeek asDayOfWeek(GtfsKeyType gtfsKeyTypeWeekDay) throws PlanItRunTimeException {
        switch (gtfsKeyTypeWeekDay) {
            case MONDAY: {
                return DayOfWeek.MONDAY;
            }
            case TUESDAY: {
                return DayOfWeek.TUESDAY;
            }
            case WEDNESDAY: {
                return DayOfWeek.WEDNESDAY;
            }
            case THURSDAY: {
                return DayOfWeek.THURSDAY;
            }
            case FRIDAY: {
                return DayOfWeek.FRIDAY;
            }
            case SATURDAY: {
                return DayOfWeek.SATURDAY;
            }
            case SUNDAY: {
                return DayOfWeek.SUNDAY;
            }
        }
        throw new PlanItRunTimeException("Invalid GTFSKeyType %s, unable to convert to day of week", new Object[]{gtfsKeyTypeWeekDay});
    }

    public static GtfsKeyType asGtfsKeyType(DayOfWeek dayOfWeek) throws PlanItRunTimeException {
        switch (dayOfWeek) {
            case MONDAY: {
                return GtfsKeyType.MONDAY;
            }
            case TUESDAY: {
                return GtfsKeyType.TUESDAY;
            }
            case WEDNESDAY: {
                return GtfsKeyType.WEDNESDAY;
            }
            case THURSDAY: {
                return GtfsKeyType.THURSDAY;
            }
            case FRIDAY: {
                return GtfsKeyType.FRIDAY;
            }
            case SATURDAY: {
                return GtfsKeyType.SATURDAY;
            }
            case SUNDAY: {
                return GtfsKeyType.SUNDAY;
            }
        }
        throw new PlanItRunTimeException("Invalid DayOfWeek %s, unable to convert to GTFS Key type", new Object[]{dayOfWeek});
    }

    public String getServiceId() {
        return this.get(GtfsKeyType.SERVICE_ID);
    }

    public boolean isActiveOnMonday() {
        return this.getMonday() == 1;
    }

    public boolean isActiveOnTuesday() {
        return this.getTuesday() == 1;
    }

    public boolean isActiveOnWednesday() {
        return this.getWednesday() == 1;
    }

    public boolean isActiveOnThursday() {
        return this.getThursday() == 1;
    }

    public boolean isActiveOnFriday() {
        return this.getFriday() == 1;
    }

    public boolean isActiveOnSaturday() {
        return this.getSaturday() == 1;
    }

    public boolean isActiveOnSunday() {
        return this.getSunday() == 1;
    }

    public int getMonday() {
        return Integer.parseInt(this.get(GtfsKeyType.MONDAY));
    }

    public int getTuesday() {
        return Integer.parseInt(this.get(GtfsKeyType.TUESDAY));
    }

    public int getWednesday() {
        return Integer.parseInt(this.get(GtfsKeyType.WEDNESDAY));
    }

    public int getThursday() {
        return Integer.parseInt(this.get(GtfsKeyType.THURSDAY));
    }

    public int getFriday() {
        return Integer.parseInt(this.get(GtfsKeyType.FRIDAY));
    }

    public int getSaturday() {
        return Integer.parseInt(this.get(GtfsKeyType.SATURDAY));
    }

    public int getSunday() {
        return Integer.parseInt(this.get(GtfsKeyType.SUNDAY));
    }

    public boolean isActiveOn(GtfsKeyType gtfsKeyTypeDayOfWeek) {
        return Integer.parseInt(this.get(gtfsKeyTypeDayOfWeek)) == 1;
    }

    public boolean isActiveOn(DayOfWeek dayOfWeek) {
        return this.isActiveOn(GtfsCalendar.asGtfsKeyType(dayOfWeek));
    }

    public boolean isActiveOnAny(Collection<DayOfWeek> daysOfWeek) {
        return daysOfWeek.stream().filter(e -> this.isActiveOn((DayOfWeek)e)).findFirst().isPresent();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CALENDAR: ");
        super.appendKeyValues(sb);
        return sb.toString();
    }
}

