/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.zoning.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.gtfs.converter.GtfsConverterHandlerData;
import org.goplanit.gtfs.converter.zoning.GtfsZoningReaderSettings;
import org.goplanit.gtfs.entity.GtfsStop;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.GeoContainerUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.Zones;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.index.quadtree.Quadtree;

public class GtfsZoningHandlerTransferZoneData
extends GtfsConverterHandlerData {
    private static final Logger LOGGER = Logger.getLogger(GtfsZoningHandlerTransferZoneData.class.getCanonicalName());
    private Map<String, TransferZone> mappedTransferZoneByGtfsStopId;
    private Map<TransferZone, Set<DirectedConnectoid>> transferZoneConnectoidIndex;
    private Quadtree geoIndexPreExistingTransferZones;
    private Map<String, TransferZone> preExistingTransferZonesByExternalId;
    private Map<String, GtfsStop> mappedGtfsStops;

    private void initialise(GtfsZoningReaderSettings settings, Zoning zoning) {
        this.mappedTransferZoneByGtfsStopId = new HashMap<String, TransferZone>();
        this.transferZoneConnectoidIndex = new HashMap<TransferZone, Set<DirectedConnectoid>>();
        this.mappedGtfsStops = new HashMap<String, GtfsStop>();
        this.geoIndexPreExistingTransferZones = GeoContainerUtils.toGeoIndexed((Zones)zoning.getTransferZones());
        this.preExistingTransferZonesByExternalId = zoning.getTransferZones().toMap(tz -> tz.getExternalId());
        if (!zoning.getTransferConnectoids().isEmpty()) {
            Map connectoidsByAccessZone = zoning.getTransferConnectoids().createIndexByAccessZone();
            for (Map.Entry entry : connectoidsByAccessZone.entrySet()) {
                if (!(entry.getKey() instanceof TransferZone)) continue;
                TransferZone transferZone = (TransferZone)entry.getKey();
                for (DirectedConnectoid dirConnectoid : (Set)entry.getValue()) {
                    this.registerTransferZoneToConnectoidModes(transferZone, dirConnectoid, this.getActivatedPlanitModesByGtfsMode());
                }
            }
        }
    }

    public GtfsZoningHandlerTransferZoneData(ServiceNetwork serviceNetwork, GtfsZoningReaderSettings settings, Zoning referenceZoning) {
        super(serviceNetwork, settings);
        this.initialise(settings, referenceZoning);
    }

    public void reset() {
        this.mappedTransferZoneByGtfsStopId.clear();
        this.transferZoneConnectoidIndex.clear();
        this.geoIndexPreExistingTransferZones = null;
        this.preExistingTransferZonesByExternalId.clear();
    }

    public void registerMappedGtfsStop(GtfsStop gtfsStop, TransferZone transferZone) {
        TransferZone mappedTransferZone = this.mappedTransferZoneByGtfsStopId.get(gtfsStop);
        if (mappedTransferZone != null && !mappedTransferZone.equals(transferZone)) {
            throw new PlanItRunTimeException("Different transfer zone attempted to be mapped to a single GTFS stop (STOP_ID %s), this is not allowed", new Object[]{gtfsStop.getStopId()});
        }
        this.mappedTransferZoneByGtfsStopId.put(gtfsStop.getStopId(), transferZone);
        GtfsStop oldStop = this.mappedGtfsStops.put(gtfsStop.getStopId(), gtfsStop);
        if (oldStop != null && !oldStop.equals(gtfsStop)) {
            LOGGER.warning(String.format("[DISCARD] Multiple GTFS stops found for the same GTFS STOP_ID %s, ignoring duplicate entry %s", oldStop.getStopId(), oldStop));
        }
    }

    public TransferZone getMappedTransferZone(GtfsStop gtfsStop) {
        return this.mappedTransferZoneByGtfsStopId.get(gtfsStop.getStopId());
    }

    public boolean hasMappedGtfsStop(TransferZone transferZone) {
        return this.mappedTransferZoneByGtfsStopId.values().contains(transferZone);
    }

    public GtfsStop getMappedGtfsStop(String gtfsStopId) {
        return this.mappedGtfsStops.get(gtfsStopId);
    }

    public Set<Mode> getSupportedPtModesIn(TransferZone planitTransferZone, Set<Mode> modesFilter) {
        Set<DirectedConnectoid> ptConnectoids = this.transferZoneConnectoidIndex.get(planitTransferZone);
        HashSet<Mode> ptServiceModes = new HashSet<Mode>();
        for (DirectedConnectoid connectoid : ptConnectoids) {
            ptServiceModes.addAll(connectoid.getAccessLinkSegment().getAllowedModesFrom(modesFilter));
        }
        return ptServiceModes;
    }

    public void registerTransferZoneToConnectoidModes(TransferZone transferZone, DirectedConnectoid directedConnectoid, Collection<Mode> activatedPlanitModes) {
        Set allowedModes = directedConnectoid.getAccessLinkSegment().getAllowedModesFrom(activatedPlanitModes);
        if (allowedModes.isEmpty()) {
            return;
        }
        this.transferZoneConnectoidIndex.putIfAbsent(transferZone, new HashSet());
        this.transferZoneConnectoidIndex.get(transferZone).add(directedConnectoid);
    }

    public Set<DirectedConnectoid> getTransferZoneConnectoids(TransferZone transferZone) {
        return this.transferZoneConnectoidIndex.get(transferZone);
    }

    public Quadtree getGeoIndexedPreExistingTransferZones() {
        return this.geoIndexPreExistingTransferZones;
    }

    public Map<String, TransferZone> getPreExistingTransferZonesByExternalId() {
        return this.preExistingTransferZonesByExternalId;
    }

    public Function<String, TransferZone> createGtfsStopToTransferZonesMappingFunction() {
        return new GtfsStopIdToTransferZone(this.mappedTransferZoneByGtfsStopId);
    }

    public class GtfsStopIdToTransferZone
    implements Function<String, TransferZone> {
        private final Map<String, TransferZone> mappedTransferZonesByGtfsStopId;

        private GtfsStopIdToTransferZone(Map<String, TransferZone> mappedTransferZonesByGtfsStopId) {
            this.mappedTransferZonesByGtfsStopId = mappedTransferZonesByGtfsStopId;
        }

        @Override
        public TransferZone apply(String gtfsStopId) {
            return this.mappedTransferZonesByGtfsStopId.get(gtfsStopId);
        }
    }
}

