/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.zoning.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.gtfs.enums.GtfsObjectType;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.zoning.Zoning;

public class GtfsZoningHandlerProfiler {
    private static final Logger LOGGER = Logger.getLogger(GtfsZoningHandlerProfiler.class.getCanonicalName());
    private Map<GtfsObjectType, LongAdder> gtfsObjectTypeCounters = new HashMap<GtfsObjectType, LongAdder>();
    private Pair<LongAdder, LongAdder> transferZoneCounterPair;
    private LongAdder connectoidCounterPair;
    private LongAdder transferZoneMatchesByPlatformName;
    private LongAdder transferZoneMatchesByAccessLinkSegment;

    private void initialise() {
        Arrays.stream(GtfsObjectType.values()).forEach(type -> this.gtfsObjectTypeCounters.put((GtfsObjectType)((Object)type), new LongAdder()));
        this.transferZoneCounterPair = Pair.of((Object)new LongAdder(), (Object)new LongAdder());
        this.transferZoneMatchesByPlatformName = new LongAdder();
        this.transferZoneMatchesByAccessLinkSegment = new LongAdder();
        this.connectoidCounterPair = new LongAdder();
    }

    public GtfsZoningHandlerProfiler() {
        this.initialise();
    }

    public void logProcessingStats(Zoning zoning) {
        this.gtfsObjectTypeCounters.forEach((k, v) -> {
            if (v.longValue() > 0L) {
                LOGGER.info(String.format("[STATS] processed %d GTFS %s entities", v.longValue(), k.toString()));
            }
        });
        LOGGER.info(String.format("[STATS] %d newly created transfer zones", ((LongAdder)this.transferZoneCounterPair.first()).intValue()));
        LOGGER.info(String.format("[STATS] %d newly created connectoids", this.connectoidCounterPair.intValue()));
        LOGGER.info(String.format("[STATS] %d pre-existing transfer zones matched to GTFS stops", ((LongAdder)this.transferZoneCounterPair.second()).intValue()));
        LOGGER.info(String.format("[STATS] %d pre-existing transfer zones matched to GTFS stops by platform code/name", this.transferZoneMatchesByPlatformName.intValue()));
        LOGGER.info(String.format("[STATS] %d pre-existing transfer zones matched to GTFS stops by access link segment", this.transferZoneMatchesByAccessLinkSegment.intValue()));
        zoning.logInfo(LoggingUtils.zoningPrefix((long)zoning.getId()).concat("[STATS]"));
    }

    public void reset() {
        this.gtfsObjectTypeCounters.values().forEach(v -> v.reset());
        this.transferZoneCounterPair.both(e -> e.reset());
        this.transferZoneMatchesByPlatformName.reset();
        this.transferZoneMatchesByAccessLinkSegment.reset();
        this.connectoidCounterPair.reset();
    }

    public void incrementCount(GtfsObjectType type) {
        this.gtfsObjectTypeCounters.get((Object)type).increment();
    }

    public void incrementAugmentedTransferZones() {
        ((LongAdder)this.transferZoneCounterPair.second()).increment();
    }

    public void incrementMatchedTransferZonesOnPlatformName() {
        this.transferZoneMatchesByPlatformName.increment();
    }

    public void incrementMatchedTransferZonesOnAccessLinkSegment() {
        this.transferZoneMatchesByAccessLinkSegment.increment();
    }

    public void incrementCreatedTransferZones() {
        ((LongAdder)this.transferZoneCounterPair.first()).increment();
    }

    public void incrementCreatedConnectoids() {
        this.connectoidCounterPair.increment();
    }
}

