/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.zoning.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.gtfs.converter.GtfsConverterHandlerData;
import org.goplanit.gtfs.converter.zoning.GtfsZoningReaderSettings;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerConnectoidData;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerProfiler;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerTransferZoneData;
import org.goplanit.gtfs.entity.GtfsStop;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.geo.GeoContainerUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.service.routed.RoutedModeServices;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GtfsZoningHandlerData
extends GtfsConverterHandlerData {
    private static final Logger LOGGER = Logger.getLogger(GtfsZoningHandlerData.class.getCanonicalName());
    final RoutedServices routedServices;
    private final GtfsZoningHandlerProfiler handlerProfiler;
    private Map<String, Pair<ServiceNode, List<Mode>>> serviceNodeModesByGtfsStopId;
    private GtfsZoningHandlerConnectoidData connectoidData;
    private GtfsZoningHandlerTransferZoneData transferZoneData;
    private Quadtree geoIndexedLinks;
    private Envelope referenceNetworkBoundingBox;
    private PlanitJtsCrsUtils geoTools;
    private MathTransform crsTransform;
    final Zoning zoning;

    protected void initialise() {
        this.serviceNodeModesByGtfsStopId = new HashMap<String, Pair<ServiceNode, List<Mode>>>();
        HashSet usedLayers = new HashSet();
        this.getActivatedPlanitModesByGtfsMode().forEach(m -> usedLayers.add((MacroscopicNetworkLayer)this.getServiceNetwork().getParentNetwork().getLayerByMode(m)));
        ArrayList linksCollection = new ArrayList();
        usedLayers.forEach(l -> linksCollection.add(l.getLinks()));
        this.geoIndexedLinks = GeoContainerUtils.toGeoIndexed(linksCollection);
        this.geoTools = new PlanitJtsCrsUtils(this.getServiceNetwork().getParentNetwork().getCoordinateReferenceSystem());
        this.crsTransform = PlanitJtsUtils.findMathTransform((CoordinateReferenceSystem)PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS, (CoordinateReferenceSystem)this.geoTools.getCoordinateReferenceSystem());
        for (RoutedServicesLayer routedServiceLayer : this.getRoutedServices().getLayers()) {
            for (RoutedModeServices routedModeServices : routedServiceLayer) {
                for (RoutedService routedService : routedModeServices) {
                    if (!routedService.getTripInfo().hasAnyTrips()) {
                        LOGGER.warning(String.format("Found empty routed service %s %s, indicating sub-optimal or corrupt PLANit routed services, this shouldn't happen", routedService.getXmlId(), routedService.getName()));
                        continue;
                    }
                    Set usedServiceNodes = routedService.getTripInfo().getScheduleBasedTrips().determineUsedServiceNodes();
                    usedServiceNodes.addAll(routedService.getTripInfo().getFrequencyBasedTrips().determineUsedServiceNodes());
                    for (ServiceNode serviceNode : usedServiceNodes) {
                        List supportedModes;
                        String gtfsStopId = this.getSettings().getServiceNodeToGtfsStopIdFunction().apply(serviceNode);
                        Pair entry = this.serviceNodeModesByGtfsStopId.get(gtfsStopId);
                        if (entry == null) {
                            entry = Pair.of((Object)serviceNode, new ArrayList(1));
                            this.serviceNodeModesByGtfsStopId.put(gtfsStopId, (Pair<ServiceNode, List<Mode>>)entry);
                        }
                        if ((supportedModes = (List)entry.second()).contains(routedService.getMode())) continue;
                        supportedModes.add(routedService.getMode());
                    }
                }
            }
        }
        this.referenceNetworkBoundingBox = this.getServiceNetwork().getParentNetwork().createBoundingBox();
        if (this.referenceNetworkBoundingBox == null) {
            LOGGER.severe("No bounding box could be created for reference network in GTFS zoning handler, likely network is empty");
        }
    }

    public GtfsZoningHandlerData(GtfsZoningReaderSettings settings, Zoning zoningToPopulate, ServiceNetwork serviceNetwork, RoutedServices routedServices, GtfsZoningHandlerProfiler handlerProfiler) {
        super(serviceNetwork, settings);
        this.zoning = zoningToPopulate;
        this.routedServices = routedServices;
        this.handlerProfiler = handlerProfiler;
        this.initialise();
        this.connectoidData = new GtfsZoningHandlerConnectoidData(serviceNetwork, zoningToPopulate);
        this.transferZoneData = new GtfsZoningHandlerTransferZoneData(serviceNetwork, settings, zoningToPopulate);
    }

    public List<Mode> getSupportedPtModes(GtfsStop gtfsStop) {
        Pair<ServiceNode, List<Mode>> resultPair = this.serviceNodeModesByGtfsStopId.get(gtfsStop.getStopId());
        return resultPair != null ? (List)resultPair.second() : null;
    }

    public Zoning getZoning() {
        return this.zoning;
    }

    public RoutedServices getRoutedServices() {
        return this.routedServices;
    }

    public GtfsZoningHandlerProfiler getProfiler() {
        return this.handlerProfiler;
    }

    @Override
    public GtfsZoningReaderSettings getSettings() {
        return (GtfsZoningReaderSettings)super.getSettings();
    }

    public PlanitJtsCrsUtils getGeoTools() {
        return this.geoTools;
    }

    public MathTransform getCrsTransform() {
        return this.crsTransform;
    }

    public Quadtree getGeoIndexedLinks() {
        return this.geoIndexedLinks;
    }

    public void removeGeoIndexedLink(MacroscopicLink link) {
        if (link != null) {
            this.geoIndexedLinks.remove(link.createEnvelope(), (Object)link);
        }
    }

    public void addGeoIndexedLink(MacroscopicLink link) {
        if (link != null) {
            this.geoIndexedLinks.insert(link.createEnvelope(), (Object)link);
        }
    }

    public void addGeoIndexedLinks(MacroscopicLink ... links) {
        if (links != null) {
            for (MacroscopicLink link : links) {
                this.geoIndexedLinks.insert(link.createEnvelope(), (Object)link);
            }
        }
    }

    public Envelope getReferenceNetworkBoundingBox() {
        return this.referenceNetworkBoundingBox;
    }

    public Map<Point, List<DirectedConnectoid>> getDirectedConnectoidsByLocation(MacroscopicNetworkLayer networkLayer) {
        return this.connectoidData.getDirectedConnectoidsByLocation(networkLayer);
    }

    public List<DirectedConnectoid> getDirectedConnectoidsByLocation(Point nodeLocation, MacroscopicNetworkLayer networkLayer) {
        return this.connectoidData.getDirectedConnectoidsByLocation(nodeLocation, networkLayer);
    }

    public boolean addDirectedConnectoidByLocation(MacroscopicNetworkLayer networkLayer, Point connectoidLocation, DirectedConnectoid connectoid) {
        return this.connectoidData.addDirectedConnectoidByLocation(networkLayer, connectoidLocation, connectoid);
    }

    public boolean hasAnyDirectedConnectoidsForLocation(Point location) {
        return this.connectoidData.hasAnyDirectedConnectoidsForLocation(location);
    }

    public boolean hasDirectedConnectoidForLocation(NetworkLayer networkLayer, Point point) {
        return this.connectoidData.hasDirectedConnectoidForLocation(networkLayer, point);
    }

    public void registerMappedGtfsStop(GtfsStop gtfsStop, TransferZone transferZone) {
        this.transferZoneData.registerMappedGtfsStop(gtfsStop, transferZone);
    }

    public TransferZone getMappedTransferZone(GtfsStop gtfsStop) {
        return this.transferZoneData.getMappedTransferZone(gtfsStop);
    }

    public boolean hasMappedGtfsStop(TransferZone transferZone) {
        return this.transferZoneData.hasMappedGtfsStop(transferZone);
    }

    public GtfsStop getMappedGtfsStop(String gtfsStopId) {
        return this.transferZoneData.getMappedGtfsStop(gtfsStopId);
    }

    public Set<Mode> getSupportedPtModesIn(TransferZone planitTransferZone, Set<Mode> modesFilter) {
        return this.transferZoneData.getSupportedPtModesIn(planitTransferZone, modesFilter);
    }

    public void registerTransferZoneToConnectoidModes(TransferZone transferZone, DirectedConnectoid directedConnectoid, Set<Mode> activatedPlanitModes) {
        this.transferZoneData.registerTransferZoneToConnectoidModes(transferZone, directedConnectoid, activatedPlanitModes);
    }

    public Set<DirectedConnectoid> getTransferZoneConnectoids(TransferZone transferZone) {
        return this.transferZoneData.getTransferZoneConnectoids(transferZone);
    }

    public Quadtree getGeoIndexedPreExistingTransferZones() {
        return this.transferZoneData.getGeoIndexedPreExistingTransferZones();
    }

    public Map<String, TransferZone> getPreExistingTransferZonesByExternalId() {
        return this.transferZoneData.getPreExistingTransferZonesByExternalId();
    }

    public Function<String, TransferZone> createGtfsStopToTransferZoneMappingFunction() {
        return this.transferZoneData.createGtfsStopToTransferZonesMappingFunction();
    }
}

