/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.zoning.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Point;

public class GtfsZoningHandlerConnectoidData {
    private static final Logger LOGGER = Logger.getLogger(GtfsZoningHandlerConnectoidData.class.getCanonicalName());
    private final Map<MacroscopicNetworkLayer, Map<Point, List<DirectedConnectoid>>> directedConnectoidsByLocation;

    public GtfsZoningHandlerConnectoidData(ServiceNetwork serviceNetwork, Zoning referenceZoning) {
        this.directedConnectoidsByLocation = referenceZoning.getTransferConnectoids().groupByPhysicalLayerAndCustomKey((Iterable)serviceNetwork.getParentNetwork().getTransportLayers(), d -> d.getAccessNode().getPosition());
    }

    public void reset() {
        this.directedConnectoidsByLocation.clear();
    }

    public Map<Point, List<DirectedConnectoid>> getDirectedConnectoidsByLocation(MacroscopicNetworkLayer networkLayer) {
        this.directedConnectoidsByLocation.putIfAbsent(networkLayer, new HashMap());
        return Collections.unmodifiableMap(this.directedConnectoidsByLocation.get(networkLayer));
    }

    public List<DirectedConnectoid> getDirectedConnectoidsByLocation(Point nodeLocation, MacroscopicNetworkLayer networkLayer) {
        return this.getDirectedConnectoidsByLocation(networkLayer).get(nodeLocation);
    }

    public boolean addDirectedConnectoidByLocation(MacroscopicNetworkLayer networkLayer, Point connectoidLocation, DirectedConnectoid connectoid) {
        this.directedConnectoidsByLocation.putIfAbsent(networkLayer, new HashMap());
        Map<Point, List<DirectedConnectoid>> connectoidsForLayer = this.directedConnectoidsByLocation.get(networkLayer);
        connectoidsForLayer.putIfAbsent(connectoidLocation, new ArrayList(1));
        List<DirectedConnectoid> connectoids = connectoidsForLayer.get(connectoidLocation);
        if (!connectoids.contains(connectoid)) {
            return connectoids.add(connectoid);
        }
        return false;
    }

    public boolean hasAnyDirectedConnectoidsForLocation(Point location) {
        for (Map.Entry<MacroscopicNetworkLayer, Map<Point, List<DirectedConnectoid>>> entry : this.directedConnectoidsByLocation.entrySet()) {
            if (!this.hasDirectedConnectoidForLocation((NetworkLayer)entry.getKey(), location)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDirectedConnectoidForLocation(NetworkLayer networkLayer, Point point) {
        Map<Point, List<DirectedConnectoid>> connectoidsForLayer = this.directedConnectoidsByLocation.get(networkLayer);
        return connectoidsForLayer != null && connectoidsForLayer.get(point) != null && !connectoidsForLayer.get(point).isEmpty();
    }
}

