/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.zoning.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.idmapping.IdMapperFunctionFactory;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.zoning.ZoningConverterUtils;
import org.goplanit.gtfs.converter.zoning.GtfsZoningReaderSettings;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerData;
import org.goplanit.gtfs.entity.GtfsStop;
import org.goplanit.gtfs.enums.GtfsObjectType;
import org.goplanit.gtfs.handler.GtfsFileHandlerStops;
import org.goplanit.gtfs.util.GtfsDirectedConnectoidHelper;
import org.goplanit.gtfs.util.GtfsLinkHelper;
import org.goplanit.gtfs.util.GtfsLinkSegmentHelper;
import org.goplanit.gtfs.util.GtfsTransferZoneHelper;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitGraphGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.operation.MathTransform;

public class GtfsPlanitFileHandlerStops
extends GtfsFileHandlerStops {
    private static final Logger LOGGER = Logger.getLogger(GtfsPlanitFileHandlerStops.class.getCanonicalName());
    private static final Function<Link, String> DEFAULT_LINK_TO_SOURCE_ID_MAPPING_FUNCTION = IdMapperFunctionFactory.createLinkIdMappingFunction((IdMapperType)IdMapperType.ID);
    private final GtfsZoningHandlerData data;

    private Pair<Collection<MacroscopicLink>, MacroscopicLink> findEligibleLinkMappings(GtfsStop gtfsStop, Point projectedGtfsStopLocation, SortedMap<Mode, SortedSet<Mode>> mode2EligibleModesMapping) {
        MacroscopicLink closestOfNearbyLinks = null;
        Collection<MacroscopicLink> nearbyLinks = null;
        boolean suppressLogging = false;
        if (this.data.getSettings().hasOverwrittenGtfsStopToLinkMapping(gtfsStop.getStopId())) {
            Pair<Object, IdMapperType> linkIdMapping = this.data.getSettings().getOverwrittenGtfsStopToLinkMapping(gtfsStop.getStopId());
            Object chosenLinkId = linkIdMapping.first();
            Function idMapper = IdMapperFunctionFactory.createLinkIdMappingFunction((IdMapperType)((IdMapperType)linkIdMapping.second()));
            block0: for (Map.Entry<Mode, SortedSet<Mode>> gtfsStopModeEntry : mode2EligibleModesMapping.entrySet()) {
                SortedSet<Mode> allEligibleModes = gtfsStopModeEntry.getValue();
                for (Mode eligibleMode : allEligibleModes) {
                    MacroscopicLink foundLink = (MacroscopicLink)((MacroscopicNetworkLayer)this.data.getServiceNetwork().getParentNetwork().getLayerByMode(eligibleMode)).getLinks().firstMatch(l -> chosenLinkId.equals(idMapper.apply(l)));
                    if (foundLink == null) continue;
                    closestOfNearbyLinks = foundLink;
                    nearbyLinks = Collections.singleton(closestOfNearbyLinks);
                    suppressLogging = true;
                    continue block0;
                }
            }
            if (closestOfNearbyLinks == null) {
                LOGGER.warning(String.format("Unable to find manually overwritten link mapping for GTFS stop id %s in network, instead trying to map as if it is a regular GTFS stop, verify settings", gtfsStop.getStopId()));
            }
        }
        if (closestOfNearbyLinks == null) {
            nearbyLinks = GtfsLinkHelper.findNearbyLinks(gtfsStop.getLocationAsPoint(), this.data.getSettings().getGtfsStopToLinkSearchRadiusMeters(), this.data);
            nearbyLinks.removeIf(l -> !mode2EligibleModesMapping.values().stream().flatMap(v -> v.stream()).anyMatch(m -> l.isModeAllowedOnAnySegment(m)));
            if (nearbyLinks.isEmpty() || nearbyLinks == null) {
                return null;
            }
            closestOfNearbyLinks = (MacroscopicLink)PlanitEntityGeoUtils.findPlanitEntityClosest((Coordinate)projectedGtfsStopLocation.getCoordinate(), nearbyLinks, (boolean)suppressLogging, (PlanitJtsCrsUtils)this.data.getGeoTools()).first();
        }
        return Pair.of(nearbyLinks, closestOfNearbyLinks);
    }

    private Function<Link, String> createAccessLinkToSourceIdFunctionByGtfsStop(GtfsStop gtfsStop, Function<Link, String> defaultIfNoOverwritten) {
        boolean overrideActive;
        Pair<Object, IdMapperType> overwrittenLinkWithIdMapper = this.data.getSettings().getOverwrittenGtfsStopToLinkMapping(gtfsStop.getStopId());
        boolean bl = overrideActive = overwrittenLinkWithIdMapper != null && overwrittenLinkWithIdMapper.bothNotNull();
        if (!overrideActive) {
            return defaultIfNoOverwritten;
        }
        return IdMapperFunctionFactory.createLinkIdMappingFunction((IdMapperType)((IdMapperType)overwrittenLinkWithIdMapper.second()));
    }

    private Function<String, String> createOverwrittenAccessLinkToSourceIdFunction(GtfsStop gtfsStop, Mode mode) {
        boolean overrideActive;
        Function<Link, String> linkToSourceId = this.createAccessLinkToSourceIdFunctionByGtfsStop(gtfsStop, null);
        Pair<Object, IdMapperType> overwrittenLinkWithIdMapper = this.data.getSettings().getOverwrittenGtfsStopToLinkMapping(gtfsStop.getStopId());
        boolean bl = overrideActive = overwrittenLinkWithIdMapper != null && overwrittenLinkWithIdMapper.bothNotNull();
        if (!overrideActive) {
            return null;
        }
        MacroscopicLink overwrittenAccessLink = (MacroscopicLink)((MacroscopicNetworkLayer)this.data.getServiceNetwork().getParentNetwork().getLayerByMode(mode)).getLinks().firstMatch(link -> overwrittenLinkWithIdMapper.first().equals(linkToSourceId.apply((Link)link)));
        return gtfsStopId -> (String)linkToSourceId.apply((Link)overwrittenAccessLink);
    }

    private Pair<MacroscopicLink, Set<MacroscopicLinkSegment>> findAppropriateStopLocationLinkFromLinkSegments(GtfsStop gtfsStop, Collection<Mode> eligibleAccessModes, Set<MacroscopicLinkSegment> potentialLinkSegments) {
        Point projectedGtfsStopLocation = (Point)PlanitJtsUtils.transformGeometry((Geometry)gtfsStop.getLocationAsPoint(), (MathTransform)this.data.getCrsTransform());
        Function<Link, String> linkToSourceId = this.createAccessLinkToSourceIdFunctionByGtfsStop(gtfsStop, DEFAULT_LINK_TO_SOURCE_ID_MAPPING_FUNCTION);
        Pair<Object, IdMapperType> linkWithIdMapper = this.data.getSettings().getOverwrittenGtfsStopToLinkMapping(gtfsStop.getStopId());
        boolean overrideActive = linkWithIdMapper != null && linkWithIdMapper.bothNotNull();
        HashSet<MacroscopicLinkSegment> linkSegmentsWithConnectoidLocation = new HashSet<MacroscopicLinkSegment>();
        for (Mode accessMode : eligibleAccessModes) {
            Function<String, String> overwrittenAccessLinkToSourceId = null;
            if (overrideActive) {
                overwrittenAccessLinkToSourceId = this.createOverwrittenAccessLinkToSourceIdFunction(gtfsStop, accessMode);
            }
            for (MacroscopicLinkSegment candidate : potentialLinkSegments) {
                if (!candidate.isModeAllowed(accessMode) || null == ZoningConverterUtils.findConnectoidLocationForWaitingAreaOnLinkSegment((String)gtfsStop.getStopId(), (Geometry)projectedGtfsStopLocation, (MacroscopicLinkSegment)candidate, (String)linkToSourceId.apply((Link)candidate.getParentLink()), (Mode)accessMode, (double)this.data.getSettings().getGtfsStopToLinkSearchRadiusMeters(), null, null, overwrittenAccessLinkToSourceId, (String)this.data.getSettings().getCountryName(), (PlanitJtsCrsUtils)this.data.getGeoTools())) continue;
                linkSegmentsWithConnectoidLocation.add(candidate);
            }
        }
        if (linkSegmentsWithConnectoidLocation.isEmpty()) {
            return null;
        }
        Set filteredLinks = linkSegmentsWithConnectoidLocation.stream().map(ls -> ls.getParentLink()).collect(Collectors.toSet());
        if (filteredLinks.size() == 1) {
            MacroscopicLink selectedAccessLink = ((MacroscopicLinkSegment)linkSegmentsWithConnectoidLocation.iterator().next()).getParentLink();
            return Pair.of((Object)selectedAccessLink, linkSegmentsWithConnectoidLocation);
        }
        Set finalFilteredLinks = PlanitGraphGeoUtils.findEdgesWithinClosestDistanceDeltaToGeometry((Geometry)projectedGtfsStopLocation, filteredLinks, (double)GtfsZoningReaderSettings.DEFAULT_CLOSEST_LINK_SEARCH_BUFFER_DISTANCE_M, (PlanitJtsCrsUtils)this.data.getGeoTools()).keySet();
        linkSegmentsWithConnectoidLocation.removeIf(ls -> !finalFilteredLinks.contains(ls.getParent()));
        if (finalFilteredLinks.size() == 1) {
            MacroscopicLink selectedAccessLink = (MacroscopicLink)finalFilteredLinks.iterator().next();
            return Pair.of((Object)selectedAccessLink, linkSegmentsWithConnectoidLocation);
        }
        if (eligibleAccessModes.stream().findAny().get().getPhysicalFeatures().getTrackType() == TrackModeType.ROAD && filteredLinks.size() > 1 && linkSegmentsWithConnectoidLocation.stream().map(MacroscopicLinkSegment::getCapacityOrDefaultPcuHLane).distinct().count() > 1L) {
            Optional<Double> maxCapacity = linkSegmentsWithConnectoidLocation.stream().map(MacroscopicLinkSegment::getCapacityOrDefaultPcuHLane).max(Comparator.naturalOrder());
            Set lowerCapacitySegments = linkSegmentsWithConnectoidLocation.stream().filter(ls -> Precision.smaller((double)ls.getCapacityOrDefaultPcuHLane(), (double)((Double)maxCapacity.get()), (double)1.0E-6)).collect(Collectors.toUnmodifiableSet());
            linkSegmentsWithConnectoidLocation.removeAll(lowerCapacitySegments);
        }
        filteredLinks = linkSegmentsWithConnectoidLocation.stream().map(ls -> ls.getParentLink()).collect(Collectors.toSet());
        MacroscopicLink finalSelectedAccessLink = (MacroscopicLink)filteredLinks.iterator().next();
        if (filteredLinks.size() > 1) {
            finalSelectedAccessLink = (MacroscopicLink)PlanitGraphGeoUtils.findEdgeClosest((Geometry)projectedGtfsStopLocation, filteredLinks, (PlanitJtsCrsUtils)this.data.getGeoTools());
        }
        MacroscopicLink dummy = finalSelectedAccessLink;
        linkSegmentsWithConnectoidLocation.removeIf(ls -> !ls.getParent().equals(dummy));
        return Pair.of((Object)finalSelectedAccessLink, linkSegmentsWithConnectoidLocation);
    }

    private Pair<MacroscopicLink, Set<MacroscopicLinkSegment>> findMostAppropriateStopLocationLinkFromLinks(GtfsStop gtfsStop, Collection<Mode> eligibleAccessModes, Collection<MacroscopicLink> eligibleLinks) {
        Point projectedGtfsStopLocation = (Point)PlanitJtsUtils.transformGeometry((Geometry)gtfsStop.getLocationAsPoint(), (MathTransform)this.data.getCrsTransform());
        Function<Link, String> linkToSourceId = this.createAccessLinkToSourceIdFunctionByGtfsStop(gtfsStop, DEFAULT_LINK_TO_SOURCE_ID_MAPPING_FUNCTION);
        Pair<Object, IdMapperType> linkWithIdMapper = this.data.getSettings().getOverwrittenGtfsStopToLinkMapping(gtfsStop.getStopId());
        boolean overrideActive = linkWithIdMapper != null && linkWithIdMapper.bothNotNull();
        HashSet<MacroscopicLinkSegment> accessLinkSegments = new HashSet<MacroscopicLinkSegment>(2);
        for (Mode accessMode : eligibleAccessModes) {
            Function<String, String> overwrittenAccessLinkToSourceId = null;
            if (overrideActive) {
                overwrittenAccessLinkToSourceId = this.createOverwrittenAccessLinkToSourceIdFunction(gtfsStop, accessMode);
            }
            for (MacroscopicLink currAccessLink : eligibleLinks) {
                boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessMode((Mode)accessMode);
                Collection currAccessLinkSegments = ZoningConverterUtils.findAccessLinkSegmentsForWaitingArea((String)gtfsStop.getStopId(), (Geometry)projectedGtfsStopLocation, (MacroscopicLink)currAccessLink, (String)linkToSourceId.apply((Link)currAccessLink), (Mode)accessMode, (String)this.data.getSettings().getCountryName(), (boolean)mustAvoidCrossingTraffic, overwrittenAccessLinkToSourceId, null, (PlanitJtsCrsUtils)this.data.getGeoTools());
                if (currAccessLinkSegments == null || currAccessLinkSegments.isEmpty()) continue;
                accessLinkSegments.addAll(currAccessLinkSegments);
            }
        }
        return this.findAppropriateStopLocationLinkFromLinkSegments(gtfsStop, eligibleAccessModes, accessLinkSegments);
    }

    private TransferZone matchByPlatform(GtfsStop gtfsStop, Collection<TransferZone> transferZones, SortedSet<Mode> allEligibleModes) {
        if (!gtfsStop.hasPlatformCode()) {
            return null;
        }
        for (TransferZone transferZone : transferZones) {
            List platformNames = transferZone.getTransferZonePlatformNames();
            if (platformNames == null || !platformNames.stream().anyMatch(name -> name.equalsIgnoreCase(gtfsStop.getPlatformCode())) || this.data.getSupportedPtModesIn(transferZone, allEligibleModes).isEmpty()) continue;
            return transferZone;
        }
        return null;
    }

    private Pair<TransferZone, DirectedConnectoid> matchByAccessLinkSegments(GtfsStop gtfsStop, Collection<? extends LinkSegment> preferredAccessLinkSegments, Collection<TransferZone> transferZones, double maxStopToAccessNodeDistanceMeters) {
        TransferZone match = null;
        DirectedConnectoid matchedConnectoid = null;
        for (TransferZone transferZone : transferZones) {
            Set<DirectedConnectoid> directedConnectoids = this.data.getTransferZoneConnectoids(transferZone);
            for (DirectedConnectoid cn : directedConnectoids) {
                if (!preferredAccessLinkSegments.contains(cn.getAccessLinkSegment())) continue;
                Point projectedGtfsStopLocation = (Point)PlanitJtsUtils.transformGeometry((Geometry)gtfsStop.getLocationAsPoint(), (MathTransform)this.data.getCrsTransform());
                double maxStopToAccessNodeDistanceForMatchedTransferZonesWithEqualAccessLinkSegment = this.data.getSettings().getGtfsStopToTransferZoneSearchRadiusMeters() + this.data.getSettings().getGtfsStopToLinkSearchRadiusMeters();
                if (this.data.getGeoTools().isDistanceWithinMetres(projectedGtfsStopLocation, cn.getAccessNode().getPosition(), maxStopToAccessNodeDistanceForMatchedTransferZonesWithEqualAccessLinkSegment)) {
                    if (match != null) {
                        List<TransferZone> options = List.of(match, transferZone);
                        Pair closestMatch = PlanitEntityGeoUtils.findPlanitEntityClosest((Coordinate)projectedGtfsStopLocation.getCoordinate(), List.of(match, transferZone), (boolean)false, (PlanitJtsCrsUtils)this.data.getGeoTools());
                        matchedConnectoid = ((TransferZone)closestMatch.first()).equals(match) ? matchedConnectoid : cn;
                        match = (TransferZone)closestMatch.first();
                        LOGGER.info(String.format("Choosing closest transfer zone %s with access link segment (%s, ext id: %s) for matched GTFS stop %s %s (location %s), from eligible options [%s], verify correctness", match.getIdsAsString(), cn.getAccessLinkSegment().getXmlId(), cn.getAccessLinkSegment().getParentLink().getExternalId(), gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), options.stream().map(tz -> "(" + tz.getIdsAsString() + ")").collect(Collectors.joining(","))));
                        continue;
                    }
                    match = transferZone;
                    matchedConnectoid = cn;
                    continue;
                }
                LOGGER.info(String.format("GTFS stop %s %s (location %s) initially matched to transfer zone (%s) sharing same preferred access link segment, but access node too far away, match ignored", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), transferZone.getIdsAsString()));
            }
        }
        return Pair.of(match, matchedConnectoid);
    }

    private TransferZone matchByClosestWithAcceptableAccessAngle(GtfsStop gtfsStop, Mode gtfsStopMode, Collection<? extends LinkSegment> gtfsAccessSegments, Collection<TransferZone> nearbyTransferZones, double maxAngleDegrees, double maxStopToAccessNodeDistanceMeters) {
        TransferZone matchedTransferZone = null;
        Point projectedGtfsStopLocation = (Point)PlanitJtsUtils.transformGeometry((Geometry)gtfsStop.getLocationAsPoint(), (MathTransform)this.data.getCrsTransform());
        boolean allowUTurn = false;
        boolean adjacentMatch = false;
        LinkSegment accessLinkSegment = gtfsAccessSegments.iterator().next();
        while (!adjacentMatch && !nearbyTransferZones.isEmpty()) {
            TransferZone currTransferZone = (TransferZone)GtfsTransferZoneHelper.findTransferZoneStopLocationClosestTo(projectedGtfsStopLocation.getCoordinate(), nearbyTransferZones, this.data).first();
            if (gtfsAccessSegments.size() > 1) break;
            Set<DirectedConnectoid> directedConnectoids = this.data.getTransferZoneConnectoids(currTransferZone);
            boolean angleMatchFound = false;
            for (DirectedConnectoid cn : directedConnectoids) {
                if (!this.data.getGeoTools().isDistanceWithinMetres(projectedGtfsStopLocation, cn.getAccessNode().getPosition(), maxStopToAccessNodeDistanceMeters) || !cn.getAccessLinkSegment().isModeAllowed(gtfsStopMode)) continue;
                Point zoneGeoCentroid = currTransferZone.getGeometry(true).getCentroid();
                double tzAzimuth = GtfsLinkSegmentHelper.getAzimuthFromLinkSegmentToCoordinate(cn.getAccessLinkSegment(), zoneGeoCentroid.getCoordinate(), this.data);
                double gtfsAzimuth = GtfsLinkSegmentHelper.getAzimuthFromLinkSegmentToCoordinate(accessLinkSegment, projectedGtfsStopLocation.getCoordinate(), this.data);
                double diffAngle = PlanitJtsUtils.minDiffAngleInDegrees((double)gtfsAzimuth, (double)tzAzimuth);
                if (diffAngle < maxAngleDegrees) {
                    angleMatchFound = true;
                    adjacentMatch = accessLinkSegment.isAdjacent((EdgeSegment)cn.getAccessLinkSegment(), false);
                }
                if (!adjacentMatch) continue;
                break;
            }
            if (angleMatchFound && (matchedTransferZone == null || adjacentMatch)) {
                matchedTransferZone = currTransferZone;
                continue;
            }
            nearbyTransferZones.remove(currTransferZone);
        }
        if (matchedTransferZone != null && !adjacentMatch) {
            LOGGER.warning(String.format("GTFS stop %s %s (location %s) mapped to transfer zone (%s, ext id:%s, name: %s), but GTFS preferred access link segment (XmlId: %s, ExtId: %s) not adjacent to existing access link segments, verify correctness", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), matchedTransferZone.getXmlId(), matchedTransferZone.getExternalId(), matchedTransferZone.getName(), accessLinkSegment.getXmlId(), accessLinkSegment.getParentLink().getExternalId()));
        }
        return matchedTransferZone;
    }

    private TransferZone findMatchFromExistingTransferZone(GtfsStop gtfsStop, List<Mode> primaryGtfsStopModes, Collection<TransferZone> nearbyTransferZones) {
        PlanItRunTimeException.throwIfNull((Object)gtfsStop, (String)"GTFS stop null, this is not allowed");
        if (nearbyTransferZones.isEmpty()) {
            return null;
        }
        TransferZone theTransferZone = null;
        for (Mode primaryMode : primaryGtfsStopModes) {
            ArrayList<TransferZone> consideredTransferZones = new ArrayList<TransferZone>(nearbyTransferZones);
            boolean stopLocationDirectionSpecific = ZoningConverterUtils.isAvoidCrossTrafficForAccessMode((Mode)primaryMode);
            SortedSet<Mode> allEligibleModes = this.data.expandWithCompatibleModes(primaryMode);
            consideredTransferZones.removeIf(tz -> this.data.getSupportedPtModesIn((TransferZone)tz, (Set<Mode>)allEligibleModes).isEmpty());
            if (consideredTransferZones.isEmpty()) continue;
            consideredTransferZones.removeIf(tz -> stopLocationDirectionSpecific && !GtfsTransferZoneHelper.isGtfsStopOnCorrectSideOfTransferZoneAccessLinkSegments(gtfsStop, primaryMode, tz, this.data, false));
            if (consideredTransferZones.isEmpty()) continue;
            if (this.data.getSettings().isDisallowGtfsStopToTransferZoneJointMapping(gtfsStop.getStopId())) {
                consideredTransferZones.removeIf(tz -> this.data.hasMappedGtfsStop((TransferZone)tz));
            }
            TransferZone modeTransferZone = this.findMatchingExistingTransferZoneByPlatformOrLinks(gtfsStop, primaryMode, nearbyTransferZones);
            if (theTransferZone != null && theTransferZone != modeTransferZone) {
                throw new PlanItRunTimeException("GTFS stop %s %s (location %s) supports multiple modes, but could not map those to a single transfer zone, this shouldn't happen, verify correctness", new Object[]{gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord()});
            }
            theTransferZone = modeTransferZone;
        }
        if (theTransferZone == null) {
            LOGGER.fine(String.format("GTFS stop %s %s (location %s) [mode(s): %s] not matched to nearby transfer zone(s) (%s), creating new transfer zone", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), primaryGtfsStopModes.stream().map(e -> e.getName()).collect(Collectors.joining()), nearbyTransferZones.stream().map(tz -> "[" + tz.getXmlId() + ", name: " + tz.getName() + ", ext id: " + tz.getExternalId() + "]").collect(Collectors.joining())));
        }
        return theTransferZone;
    }

    private TransferZone findMatchingExistingTransferZoneByPlatformOrLinks(GtfsStop gtfsStop, Mode primaryMode, Collection<TransferZone> nearbyTransferZones) {
        PlanItRunTimeException.throwIfNull((Object)primaryMode, (String)"GTFS stop's associated PLANit mode null, this is not allowed");
        PlanItRunTimeException.throwIfNullOrEmpty(nearbyTransferZones, (String)"No nearby transfer zones provided, this is not allowed", (Object[])new Object[0]);
        SortedSet<Mode> allEligibleModes = this.data.expandWithCompatibleModes(primaryMode);
        TransferZone matchedTransferZone = this.matchByPlatform(gtfsStop, nearbyTransferZones, allEligibleModes);
        if (matchedTransferZone != null) {
            this.data.getProfiler().incrementMatchedTransferZonesOnPlatformName();
            return matchedTransferZone;
        }
        Collection<MacroscopicLink> nearbyLinks = GtfsLinkHelper.findNearbyLinks(gtfsStop.getLocationAsPoint(), this.data.getSettings().getGtfsStopToLinkSearchRadiusMeters(), this.data);
        if (nearbyLinks == null || nearbyLinks.isEmpty()) {
            LOGGER.warning(String.format("No nearby links found for GTFS stop %s within search radius of %.2fm, consider expanding search radius, or override to attach to any of transfer zones: %s", gtfsStop.getStopId(), this.data.getSettings().getGtfsStopToLinkSearchRadiusMeters(), nearbyTransferZones.stream().map(tz -> "[" + tz.getXmlId() + ", name: " + tz.getName() + ", ext id: " + tz.getExternalId() + "]").collect(Collectors.joining())));
            return null;
        }
        Set<MacroscopicLinkSegment> transferZoneAccessLinkSegments = nearbyTransferZones.stream().flatMap(tz -> this.data.getTransferZoneConnectoids((TransferZone)tz).stream()).map(c -> (MacroscopicLinkSegment)c.getAccessLinkSegment()).collect(Collectors.toSet());
        if (transferZoneAccessLinkSegments.isEmpty()) {
            return null;
        }
        Pair<MacroscopicLink, Set<MacroscopicLinkSegment>> desiredAccessResult = this.findAppropriateStopLocationLinkFromLinkSegments(gtfsStop, allEligibleModes, transferZoneAccessLinkSegments);
        if (desiredAccessResult == null) {
            LOGGER.info(String.format("GTFS stop (%s %s %s, mode: %s) access Links [%s] of nearby transfer zones [%s] incompatible/too far, creating new transfer zone instead (unless indicated otherwise) ", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsPoint(), allEligibleModes.stream().map(m -> m.getPredefinedModeType().toString()).collect(Collectors.joining(",")), transferZoneAccessLinkSegments.stream().map(l -> l.getParentLink().getIdsAsString()).distinct().collect(Collectors.joining(",")), nearbyTransferZones.stream().map(tz -> "(" + tz.getIdsAsString() + ")").collect(Collectors.joining(","))));
            return null;
        }
        double maxStopToAccessNodeDistanceMeters = this.data.getSettings().getGtfsStopToTransferZoneSearchRadiusMeters() + this.data.getSettings().getGtfsStopToLinkSearchRadiusMeters();
        Pair<TransferZone, DirectedConnectoid> matchedTransferZoneAndConnectoid = this.matchByAccessLinkSegments(gtfsStop, (Collection)desiredAccessResult.second(), nearbyTransferZones, maxStopToAccessNodeDistanceMeters);
        matchedTransferZone = (TransferZone)matchedTransferZoneAndConnectoid.first();
        if (matchedTransferZone != null) {
            this.data.getProfiler().incrementMatchedTransferZonesOnAccessLinkSegment();
            if (this.data.getSettings().isLogGtfsStopToLinkMapping(gtfsStop.getStopId())) {
                LOGGER.info(String.format("GTFS stop (%s %s %s) mapped to PLANit link (%s) of existing PLANit transfer zone (%s)", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsPoint(), ((DirectedConnectoid)matchedTransferZoneAndConnectoid.second()).getAccessLinkSegment().getParentLink().getIdsAsString(), matchedTransferZone.getIdsAsString()));
            }
            return matchedTransferZone;
        }
        double maxAngleDegrees = 100.0;
        matchedTransferZone = this.matchByClosestWithAcceptableAccessAngle(gtfsStop, primaryMode, (Collection)desiredAccessResult.second(), nearbyTransferZones, 100.0, maxStopToAccessNodeDistanceMeters);
        if (this.data.hasMappedGtfsStop(matchedTransferZone) && primaryMode.getPhysicalFeatures().getTrackType() == TrackModeType.ROAD) {
            GtfsStop earlierMappedStop = this.data.getMappedGtfsStop(GtfsTransferZoneHelper.getLastTransferZoneExternalId(matchedTransferZone));
            LOGGER.warning(String.format("PLANit transfer zone (%s) for GTFS STOP (%s, %s, %s) already mapped to another GTFS stop (%s, %s, %s), consider disallowing joined mapping or force creating a new transfer zone via settings", matchedTransferZone.getIdsAsString(), gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord().toString(), earlierMappedStop.getStopId(), earlierMappedStop.getStopName(), earlierMappedStop.getLocationAsCoord().toString()));
        }
        if (this.data.getSettings().isLogGtfsStopToLinkMapping(gtfsStop.getStopId())) {
            String linkIds = this.data.getTransferZoneConnectoids(matchedTransferZone).stream().map(c -> c.getAccessLinkSegment().getParentLink()).distinct().map(l -> l.getIdsAsString()).collect(Collectors.joining(","));
            LOGGER.info(String.format("GTFS stop (%s %s %s) mapped to all eligible PLANit link(s) [%s] of existing PLANit transfer zone %s", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsPoint(), linkIds, matchedTransferZone.getIdsAsString()));
        }
        return matchedTransferZone;
    }

    private TransferZone createNewTransferZoneAndConnectoids(GtfsStop gtfsStop, List<Mode> primaryGtfsStopModes, TransferZoneType type) {
        PlanItRunTimeException.throwIfNull((Object)gtfsStop, (String)"GTFS stop null, this is not allowed");
        PlanItRunTimeException.throwIfNull(primaryGtfsStopModes, (String)"GTFS stop's associated PLANit mode(s) is/are null, this is not allowed");
        Point projectedGtfsStopLocation = (Point)PlanitJtsUtils.transformGeometry((Geometry)gtfsStop.getLocationAsPoint(), (MathTransform)this.data.getCrsTransform());
        if (!this.data.getReferenceNetworkBoundingBox().contains(projectedGtfsStopLocation.getCoordinate())) {
            return null;
        }
        TreeMap<Mode, SortedSet<Mode>> mode2EligibleModesMapping = new TreeMap<Mode, SortedSet<Mode>>();
        primaryGtfsStopModes.forEach(m -> mode2EligibleModesMapping.put((Mode)m, this.data.expandWithCompatibleModes((Mode)m)));
        Pair<Collection<MacroscopicLink>, MacroscopicLink> eligibleLinksAndClosest = this.findEligibleLinkMappings(gtfsStop, projectedGtfsStopLocation, mode2EligibleModesMapping);
        if (eligibleLinksAndClosest == null) {
            return null;
        }
        MacroscopicLink closestOfNearbyLinks = (MacroscopicLink)eligibleLinksAndClosest.second();
        Collection nearbyLinks = (Collection)eligibleLinksAndClosest.first();
        TransferZone newTransferZone = null;
        boolean connectoidsCreated = false;
        for (Mode gtfsStopMode : primaryGtfsStopModes) {
            SortedSet allEligibleModes = (SortedSet)mode2EligibleModesMapping.get(gtfsStopMode);
            Pair<MacroscopicLink, Set<MacroscopicLinkSegment>> accessResult = this.findMostAppropriateStopLocationLinkFromLinks(gtfsStop, allEligibleModes, nearbyLinks);
            if (accessResult == null) continue;
            boolean chosenNonClosestLink = false;
            if (!closestOfNearbyLinks.equals(accessResult.first())) {
                chosenNonClosestLink = true;
            }
            Function<Link, String> linkToSourceId = this.createAccessLinkToSourceIdFunctionByGtfsStop(gtfsStop, DEFAULT_LINK_TO_SOURCE_ID_MAPPING_FUNCTION);
            Pair<Object, IdMapperType> linkWithIdMapper = this.data.getSettings().getOverwrittenGtfsStopToLinkMapping(gtfsStop.getStopId());
            boolean linkOverrideActive = linkWithIdMapper != null && linkWithIdMapper.bothNotNull();
            Point connectoidLocation = null;
            Function<String, String> overwrittenAccessLinkToSourceId = null;
            block1: for (Mode currEligibleMode : allEligibleModes) {
                if (linkOverrideActive) {
                    overwrittenAccessLinkToSourceId = this.createOverwrittenAccessLinkToSourceIdFunction(gtfsStop, currEligibleMode);
                }
                for (MacroscopicLinkSegment linkSegment : (Set)accessResult.second()) {
                    connectoidLocation = ZoningConverterUtils.findConnectoidLocationForWaitingAreaOnLinkSegment((String)gtfsStop.getStopId(), (Geometry)projectedGtfsStopLocation, (MacroscopicLinkSegment)linkSegment, (String)linkToSourceId.apply((Link)accessResult.first()), (Mode)currEligibleMode, (double)this.data.getSettings().getGtfsStopToLinkSearchRadiusMeters(), null, null, overwrittenAccessLinkToSourceId, (String)this.data.getSettings().getCountryName(), (PlanitJtsCrsUtils)this.data.getGeoTools());
                    if (connectoidLocation == null || connectoidLocation.isEmpty()) continue;
                    break block1;
                }
            }
            if (connectoidLocation == null || connectoidLocation.isEmpty()) {
                LOGGER.warning(String.format("DISCARD: No connectoid location could be found for GTFS stop's %s %s %s selected access link [mode %s], should not happen", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), gtfsStopMode.getName()));
                continue;
            }
            if (chosenNonClosestLink && !linkOverrideActive) {
                LOGGER.warning(String.format("GTFS Stop %s (%s, %s, mode:%s) may be in wrong location/wrong side of modelled road because selected access link (%s %s) is not the closest link (%s, external id: %s), verify correctness", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), gtfsStopMode.getName(), ((MacroscopicLink)accessResult.first()).getName(), ((MacroscopicLink)accessResult.first()).getIdsAsString(), closestOfNearbyLinks.getXmlId(), closestOfNearbyLinks.getExternalId()));
            }
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.data.getServiceNetwork().getParentNetwork().getLayerByMode(gtfsStopMode);
            Pair<Node, Boolean> accessNodeResult = GtfsLinkHelper.extractNodeByLinkGeometryLocation(connectoidLocation, (MacroscopicLink)accessResult.first(), networkLayer, this.data);
            Node accessNode = (Node)accessNodeResult.first();
            boolean preExistingNode = (Boolean)accessNodeResult.second() == false;
            Collection accessLinkSegments = null;
            boolean enforceCrossTrafficRestrictionOnNonClosestLinks = true;
            if (preExistingNode && !chosenNonClosestLink) {
                boolean closestEligbleEdgeSegmentsAreAllExitingAccessNode = accessNode.hasExitEdgeSegments() && ((Set)accessResult.second()).stream().allMatch(ls -> accessNode.hasExitSegment((EdgeSegment)ls));
                enforceCrossTrafficRestrictionOnNonClosestLinks = !closestEligbleEdgeSegmentsAreAllExitingAccessNode;
            }
            for (MacroscopicLink link : accessNode.getLinks()) {
                Collection linkAccessLinkSegments;
                boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessMode((Mode)gtfsStopMode);
                if (!link.equals(closestOfNearbyLinks) && !enforceCrossTrafficRestrictionOnNonClosestLinks) {
                    mustAvoidCrossingTraffic = false;
                }
                if ((linkAccessLinkSegments = ZoningConverterUtils.findAccessEntryLinkSegmentsForWaitingArea((String)gtfsStop.getStopId(), (Geometry)projectedGtfsStopLocation, (MacroscopicLink)link, (String)link.getExternalId(), (Node)accessNode, (Mode)gtfsStopMode, (String)this.data.getSettings().getCountryName(), (boolean)mustAvoidCrossingTraffic, overwrittenAccessLinkToSourceId, null, (PlanitJtsCrsUtils)this.data.getGeoTools())) == null || linkAccessLinkSegments.isEmpty()) continue;
                if (accessLinkSegments == null) {
                    accessLinkSegments = linkAccessLinkSegments;
                    continue;
                }
                accessLinkSegments.addAll(linkAccessLinkSegments);
            }
            if (newTransferZone == null) {
                newTransferZone = GtfsTransferZoneHelper.createAndRegisterNewTransferZone(gtfsStop, projectedGtfsStopLocation, type, this.data);
                if (this.data.getSettings().isLogCreatedGtfsZones()) {
                    LOGGER.info(String.format("GTFS stop %s %s at location %s triggered creation of new PLANit Transfer zone %s %s", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord().toString(), newTransferZone.getXmlId(), newTransferZone.hasName() ? newTransferZone.getName() : ""));
                }
            }
            Collection finalAccessLinkSegments = accessLinkSegments;
            allEligibleModes.removeIf(m -> finalAccessLinkSegments.stream().anyMatch(ls -> !ls.isModeAllowed(m)));
            Collection<DirectedConnectoid> results = GtfsDirectedConnectoidHelper.createAndRegisterDirectedConnectoids(newTransferZone, networkLayer, accessNode, accessLinkSegments, allEligibleModes, this.data);
            connectoidsCreated = connectoidsCreated || results != null && !results.isEmpty();
        }
        double maxDistanceFromBoundingBoxForDebugMessage = 100.0;
        if (newTransferZone == null && !this.data.getGeoTools().isGeometryNearBoundingBox((Geometry)projectedGtfsStopLocation, this.data.getReferenceNetworkBoundingBox(), 100.0)) {
            LOGGER.warning(String.format("DISCARD: GTFS stop (%s %s location %s [mode(s) %s]) nearby available links [%s] incompatible/too far - GTFS stop resides near bounding box, or possible tagging mismatch, verify GTFS stop does not reside on wrong side of underlying road network", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), primaryGtfsStopModes.stream().map(m -> m.toString()).collect(Collectors.joining(",")), nearbyLinks.stream().map(l -> l.getIdsAsString()).collect(Collectors.joining(","))));
        }
        if (newTransferZone != null && !connectoidsCreated) {
            LOGGER.severe(String.format(" Transfer zone created for GTFS stop %s %s location %s [mode(s) %s] but no connection to the physical network was established, this shouldn't happen", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), primaryGtfsStopModes.stream().map(m -> m.toString()).collect(Collectors.joining(","))));
        }
        if (this.data.getSettings().isLogGtfsStopToLinkMapping(gtfsStop.getStopId()) && connectoidsCreated) {
            String linkIds = this.data.getTransferZoneConnectoids(newTransferZone).stream().map(c -> c.getAccessLinkSegment().getParentLink()).distinct().map(l -> l.getIdsAsString()).collect(Collectors.joining(","));
            LOGGER.info(String.format("GTFS stop (%s %s %s) mapped to PLANit link(s) [%s] - new PLANit transfer zone (%s)", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsPoint(), linkIds, newTransferZone.getIdsAsString()));
        }
        return newTransferZone;
    }

    private void updateTransferZoneConnectoidSecondaryCompatibleModes(TransferZone theTransferZone, List<Mode> primaryGtfsStopModes) {
        for (DirectedConnectoid connectoid : this.data.getTransferZoneConnectoids(theTransferZone)) {
            for (Mode primaryMode : primaryGtfsStopModes) {
                SortedSet<Mode> allEligibleModes = this.data.expandWithCompatibleModes(primaryMode);
                allEligibleModes.removeIf(m -> !connectoid.getAccessLinkSegment().isModeAllowed(m));
                connectoid.addAllowedModes((Zone)theTransferZone, allEligibleModes);
                this.data.registerTransferZoneToConnectoidModes(theTransferZone, connectoid, allEligibleModes);
            }
        }
    }

    private void attachToTransferZone(GtfsStop gtfsStop, TransferZone transferZone) {
        if (!transferZone.getExternalId().contains(gtfsStop.getStopId())) {
            transferZone.appendExternalId(gtfsStop.getStopId());
        }
        if (!transferZone.hasPlatformNames() && (!transferZone.hasName() || gtfsStop.hasStopName() && transferZone.getName().length() < gtfsStop.getStopName().length())) {
            transferZone.setName(gtfsStop.getStopName());
        }
        if (gtfsStop.hasPlatformCode()) {
            transferZone.addTransferZonePlatformName(gtfsStop.getPlatformCode());
        }
        this.data.registerMappedGtfsStop(gtfsStop, transferZone);
        if (this.data.getSettings().isLogMappedGtfsZones()) {
            LOGGER.info(String.format("Mapped GTFS stop %s %s at location %s to existing Transfer zone %s %s", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord().toString(), transferZone.getXmlId(), transferZone.hasName() ? transferZone.getName() : ""));
        }
    }

    private void handleStopPlatform(GtfsStop gtfsStop, List<Mode> primaryGtfsStopModes) {
        boolean createNewTransferZone;
        this.data.getProfiler().incrementCount(GtfsObjectType.STOP);
        if (gtfsStop.getStopId().equals("206036")) {
            int n = 4;
        }
        Collection<TransferZone> nearbyTransferZones = GtfsTransferZoneHelper.findNearbyTransferZones(gtfsStop.getLocationAsPoint(), this.data.getSettings().getGtfsStopToTransferZoneSearchRadiusMeters(), this.data);
        TransferZone theTransferZone = null;
        if (!nearbyTransferZones.isEmpty() && !this.data.getSettings().isForceCreateNewTransferZoneForGtfsStop(gtfsStop.getStopId())) {
            theTransferZone = this.findMatchFromExistingTransferZone(gtfsStop, primaryGtfsStopModes, nearbyTransferZones);
        }
        boolean bl = createNewTransferZone = theTransferZone == null;
        if (createNewTransferZone) {
            theTransferZone = this.createNewTransferZoneAndConnectoids(gtfsStop, primaryGtfsStopModes, TransferZoneType.PLATFORM);
        } else {
            this.updateTransferZoneConnectoidSecondaryCompatibleModes(theTransferZone, primaryGtfsStopModes);
        }
        if (theTransferZone != null) {
            if (this.data.getSettings().isExtendedLoggingForGtfsZoneActivated(gtfsStop.getStopId())) {
                String accessLinkIds = "unknown";
                Set<DirectedConnectoid> connectoids = this.data.getTransferZoneConnectoids(theTransferZone);
                if (connectoids != null) {
                    accessLinkIds = connectoids.stream().map(c -> "(" + c.getAccessLinkSegment().getParentLink().getIdsAsString() + ")").distinct().collect(Collectors.joining(","));
                }
                String message = createNewTransferZone ? "triggered creation of new transfer zone" : "matched to existing transfer zone";
                LOGGER.info(String.format("[TRACK] GTFS stop %s %s (location %s) %s %s with access link(s): %s", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), message, theTransferZone.getIdsAsString(), accessLinkIds));
            }
            this.attachToTransferZone(gtfsStop, theTransferZone);
            if (!createNewTransferZone) {
                this.data.getProfiler().incrementAugmentedTransferZones();
            }
        } else if (!nearbyTransferZones.isEmpty()) {
            LOGGER.warning(String.format("DISCARD: Unable to add TransferZone for GTFS stop %s %s %s despite nearby transfer zones [%s], verify correctness", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), nearbyTransferZones.stream().map(tz -> "(" + tz.getIdsAsString() + ")").collect(Collectors.joining(","))));
        }
    }

    private void handleOverwrittenTransferZoneMapping(GtfsStop gtfsStop, List<Mode> primaryGtfsStopModes) {
        Collection<Pair<Object, IdMapperType>> transferZoneIdAndTypePairs = this.data.getSettings().getOverwrittenGtfsStopTransferZoneMapping(gtfsStop.getStopId());
        for (Pair<Object, IdMapperType> transferZoneIdAndTypePair : transferZoneIdAndTypePairs) {
            TransferZone transferZone = null;
            if (transferZoneIdAndTypePair.second() == IdMapperType.EXTERNAL_ID) {
                transferZone = this.data.getPreExistingTransferZonesByExternalId().get((String)transferZoneIdAndTypePair.first());
            } else if (transferZoneIdAndTypePair.second() == IdMapperType.ID) {
                transferZone = (TransferZone)this.data.getZoning().getTransferZones().get((long)((Integer)transferZoneIdAndTypePair.first()).intValue());
            } else if (transferZoneIdAndTypePair.second() == IdMapperType.XML) {
                transferZone = (TransferZone)this.data.getZoning().getTransferZones().getByXmlId((String)transferZoneIdAndTypePair.first());
            }
            if (transferZone == null) {
                LOGGER.warning(String.format("GTFS stop %s %s (location %s) manually attached to existing transfer zone (%s, %s), but transfer zone not found, ignored", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), transferZoneIdAndTypePair.first(), transferZoneIdAndTypePair.second()));
                continue;
            }
            if (this.data.getSettings().isExtendedLoggingForGtfsZoneActivated(gtfsStop.getStopId())) {
                LOGGER.info(String.format("[TRACK] GTFS stop %s %s (location %s) manually attached to existing transfer zone %s", gtfsStop.getStopId(), gtfsStop.getStopName(), gtfsStop.getLocationAsCoord(), transferZone.getIdsAsString()));
            }
            this.updateTransferZoneConnectoidSecondaryCompatibleModes(transferZone, primaryGtfsStopModes);
            this.attachToTransferZone(gtfsStop, transferZone);
        }
    }

    public GtfsPlanitFileHandlerStops(GtfsZoningHandlerData data) {
        this.data = data;
    }

    @Override
    public void handle(GtfsStop gtfsStop) {
        if (this.data.getSettings().isExcludedGtfsStop(gtfsStop.getStopId())) {
            return;
        }
        List<Mode> gtfsStopModes = this.data.getSupportedPtModes(gtfsStop);
        if (gtfsStopModes == null) {
            return;
        }
        Set<Mode> activatedModes = this.data.getActivatedPlanitModesByGtfsMode();
        gtfsStopModes.removeIf(m -> !activatedModes.contains(m));
        if (gtfsStopModes.isEmpty()) {
            return;
        }
        if (gtfsStop.getStopId().equals("7575")) {
            int n = 4;
        }
        if (this.data.getSettings().isOverwrittenGtfsStopTransferZoneMapping(gtfsStop.getStopId())) {
            this.handleOverwrittenTransferZoneMapping(gtfsStop, gtfsStopModes);
            return;
        }
        if (this.data.getSettings().isOverwrittenGtfsStopLocation(gtfsStop.getStopId())) {
            gtfsStop.setLocationAsCoord(this.data.getSettings().getOverwrittenGtfsStopLocation(gtfsStop.getStopId()));
        }
        switch (gtfsStop.getLocationType()) {
            case STOP_PLATFORM: {
                this.handleStopPlatform(gtfsStop, gtfsStopModes);
                return;
            }
            case BOARDING_AREA: {
                return;
            }
            case STATION: {
                return;
            }
            case GENERIC_NODE: {
                return;
            }
            case ENTRANCE_EXIT: {
                return;
            }
        }
        throw new PlanItRunTimeException("Unrecognised GTFS stop location type %s encountered", new Object[]{gtfsStop.getLocationType()});
    }
}

