/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.zoning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettings;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettingsWithModeMapping;
import org.goplanit.gtfs.converter.service.GtfsServicesReaderSettings;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.locationtech.jts.geom.Coordinate;

public class GtfsZoningReaderSettings
extends GtfsConverterReaderSettingsWithModeMapping
implements GtfsConverterReaderSettings {
    private static final Logger LOGGER = Logger.getLogger(GtfsZoningReaderSettings.class.getCanonicalName());
    private double gtfsStop2TransferZoneSearchRadiusMeters = 40.0;
    private double gtfsStop2RoadSearchRadiusMeters = 40.0;
    private final Map<String, List<Pair<Object, IdMapperType>>> overwriteGtfsStopTransferZoneExternalIdMapping = new HashMap<String, List<Pair<Object, IdMapperType>>>();
    private final Map<String, Coordinate> overwriteGtfsStopLocationMapping = new HashMap<String, Coordinate>();
    private final Set<String> disallowGtfsTop2TransferZoneJointMapping = new HashSet<String>();
    private final Set<String> forceCreateNewTransferZoneForGtfsStops = new HashSet<String>();
    private final Set<String> excludeGtfsStopsById = new HashSet<String>();
    private final Map<String, Pair<Object, IdMapperType>> overwriteGtfsStop2LinkMapping = new HashMap<String, Pair<Object, IdMapperType>>();
    private final Set<String> logGtfsStop2PlanitLinkMapping = new HashSet<String>();
    private boolean removeUnusedTransferZones = true;
    private boolean logMappedGtfsZones = false;
    private boolean logCreatedGtfsZones = false;
    private Set<String> extendedLoggingByGtfsStopId = new HashSet<String>();
    public static final boolean DEFAULT_REMOVE_UNUSED_TRANSFER_ZONES = true;
    public static final double DEFAULT_GTFSSTOP_TRANSFERZONE_SEARCH_METERS = 40.0;
    public static final double DEFAULT_GTFSSTOP_LINK_SEARCH_METERS = 40.0;
    public static final boolean DEFAULT_LOG_MAPPED_GTFS_ZONES = false;
    public static final boolean DEFAULT_LOG_CREATED_GTFS_ZONES = false;
    public static double DEFAULT_CLOSEST_LINK_SEARCH_BUFFER_DISTANCE_M = 8.0;

    public GtfsZoningReaderSettings(GtfsConverterReaderSettingsWithModeMapping settings) {
        super(settings);
    }

    public double getGtfsStopToTransferZoneSearchRadiusMeters() {
        return this.gtfsStop2TransferZoneSearchRadiusMeters;
    }

    public void setGtfsStopToTransferZoneSearchRadiusMeters(Number searchRadiusMeters) {
        this.gtfsStop2TransferZoneSearchRadiusMeters = searchRadiusMeters.doubleValue();
    }

    public double getGtfsStopToLinkSearchRadiusMeters() {
        return this.gtfsStop2RoadSearchRadiusMeters;
    }

    public void setGtfsStopToLinkSearchRadiusMeters(Number searchRadiusMeters) {
        this.gtfsStop2RoadSearchRadiusMeters = searchRadiusMeters.doubleValue();
    }

    public Function<ServiceNode, String> getServiceNodeToGtfsStopIdFunction() {
        return GtfsServicesReaderSettings.getServiceNodeToGtfsStopIdMapping();
    }

    public void addOverwriteGtfsStopTransferZoneMapping(String gtfsStopId, Object transferZoneId, IdMapperType idType) {
        List<Pair<Object, IdMapperType>> overrides = this.overwriteGtfsStopTransferZoneExternalIdMapping.get(gtfsStopId);
        if (overrides == null) {
            overrides = new ArrayList<Pair<Object, IdMapperType>>(1);
            this.overwriteGtfsStopTransferZoneExternalIdMapping.put(gtfsStopId, overrides);
        }
        overrides.add((Pair<Object, IdMapperType>)Pair.of((Object)transferZoneId, (Object)idType));
    }

    public boolean isOverwrittenGtfsStopTransferZoneMapping(String gtfsStopId) {
        return this.overwriteGtfsStopTransferZoneExternalIdMapping.containsKey(gtfsStopId);
    }

    public Collection<Pair<Object, IdMapperType>> getOverwrittenGtfsStopTransferZoneMapping(String gtfsStopId) {
        return this.overwriteGtfsStopTransferZoneExternalIdMapping.get(gtfsStopId);
    }

    public void setOverwriteGtfsStopLocation(String gtfsStopId, double latitude, double longitude) {
        this.overwriteGtfsStopLocationMapping.put(gtfsStopId, new Coordinate(longitude, latitude));
    }

    public boolean isOverwrittenGtfsStopLocation(String gtfsStopId) {
        return this.overwriteGtfsStopLocationMapping.containsKey(gtfsStopId);
    }

    public Coordinate getOverwrittenGtfsStopLocation(String gtfsStopId) {
        return this.overwriteGtfsStopLocationMapping.get(gtfsStopId);
    }

    public boolean isLogMappedGtfsZones() {
        return this.logMappedGtfsZones;
    }

    public boolean isExtendedLoggingForGtfsZoneActivated(String gtfsStopId) {
        return this.extendedLoggingByGtfsStopId.contains(gtfsStopId);
    }

    public void setLogMappedGtfsZones(boolean logMappedGtfsZones) {
        this.logMappedGtfsZones = logMappedGtfsZones;
    }

    public void activateExtendedLoggingForGtfsZones(String ... gtfsStopIds) {
        this.activateExtendedLoggingForGtfsZones(Arrays.asList(gtfsStopIds));
    }

    public void activateExtendedLoggingForGtfsZones(List<String> gtfsStopIds) {
        this.extendedLoggingByGtfsStopId.addAll(gtfsStopIds);
    }

    public boolean isLogCreatedGtfsZones() {
        return this.logCreatedGtfsZones;
    }

    public void setLogCreatedGtfsZones(boolean logCreatedGtfsZones) {
        this.logCreatedGtfsZones = logCreatedGtfsZones;
    }

    public boolean isRemoveUnusedTransferZones() {
        return this.removeUnusedTransferZones;
    }

    public void setRemoveUnusedTransferZones(boolean removeUnusedTransferZones) {
        this.removeUnusedTransferZones = removeUnusedTransferZones;
    }

    @Override
    public void logSettings() {
        LOGGER.info("GTFS zoning reader settings:");
        LOGGER.info(String.format("GTFS stop-to-transfer zone mappings are %slogged", this.isLogMappedGtfsZones() ? "" : "not "));
        LOGGER.info(String.format("GTFS stop-to-transfer zone search radius (m): %.1f", this.getGtfsStopToTransferZoneSearchRadiusMeters()));
        LOGGER.info(String.format("GTFS stop-to-link search radius (m): %.1f", this.getGtfsStopToLinkSearchRadiusMeters()));
        LOGGER.info(String.format("GTFS remove unused transfer zones (stops): %s", this.isRemoveUnusedTransferZones()));
    }

    @Override
    public void reset() {
        this.setGtfsStopToTransferZoneSearchRadiusMeters(40.0);
        this.setGtfsStopToLinkSearchRadiusMeters(40.0);
        this.setRemoveUnusedTransferZones(true);
        this.excludeGtfsStopsById.clear();
        this.overwriteGtfsStop2LinkMapping.clear();
        this.disallowGtfsTop2TransferZoneJointMapping.clear();
        this.forceCreateNewTransferZoneForGtfsStops.clear();
    }

    public void excludeGtfsStopsById(String ... gtfsStopIds) {
        this.excludeGtfsStopsById(Arrays.asList(gtfsStopIds));
    }

    public void excludeGtfsStopsById(Collection<String> osmIds) {
        osmIds.forEach(osmId -> this.excludeGtfsStopById((String)osmId));
    }

    public void excludeGtfsStopById(String gtfsStopId) {
        this.excludeGtfsStopsById.add(gtfsStopId);
    }

    public boolean isExcludedGtfsStop(String gtfsStopId) {
        return this.excludeGtfsStopsById.contains(gtfsStopId);
    }

    public void overwriteGtfsStopToLinkMapping(String gtfsStopId, Object linkId, IdMapperType idMapperType) {
        this.overwriteGtfsStop2LinkMapping.put(gtfsStopId, (Pair<Object, IdMapperType>)Pair.of((Object)linkId, (Object)idMapperType));
    }

    public boolean hasOverwrittenGtfsStopToLinkMapping(String gtfsStopId) {
        return this.overwriteGtfsStop2LinkMapping.containsKey(gtfsStopId);
    }

    public Pair<Object, IdMapperType> getOverwrittenGtfsStopToLinkMapping(String gtfsStopId) {
        return this.overwriteGtfsStop2LinkMapping.get(gtfsStopId);
    }

    public void addLogGtfsStopToLinkMapping(String ... gtfsStopIds) {
        this.addLogGtfsStopToLinkMapping(Arrays.asList(gtfsStopIds));
    }

    public void addLogGtfsStopToLinkMapping(List<String> gtfsStopIds) {
        this.logGtfsStop2PlanitLinkMapping.addAll(gtfsStopIds.stream().collect(Collectors.toSet()));
    }

    public boolean isLogGtfsStopToLinkMapping(String gtfsStopId) {
        return this.logGtfsStop2PlanitLinkMapping.contains(gtfsStopId);
    }

    public void disallowGtfsStopToTransferZoneJointMapping(String ... gtfsStopIds) {
        this.disallowGtfsStopToTransferZoneJointMapping(Arrays.asList(gtfsStopIds));
    }

    public void disallowGtfsStopToTransferZoneJointMapping(List<String> gtfsStopIds) {
        this.disallowGtfsTop2TransferZoneJointMapping.addAll(gtfsStopIds);
    }

    public boolean isDisallowGtfsStopToTransferZoneJointMapping(String gtfsStopId) {
        return this.disallowGtfsTop2TransferZoneJointMapping.contains(gtfsStopId);
    }

    public void forceCreateNewTransferZoneForGtfsStops(String ... gtfsStopIds) {
        this.forceCreateNewTransferZoneForGtfsStops(Arrays.asList(gtfsStopIds));
    }

    public void forceCreateNewTransferZoneForGtfsStops(List<String> gtfsStopIds) {
        this.forceCreateNewTransferZoneForGtfsStops.addAll(gtfsStopIds);
    }

    public boolean isForceCreateNewTransferZoneForGtfsStop(String gtfsStopId) {
        return this.forceCreateNewTransferZoneForGtfsStops.contains(gtfsStopId);
    }
}

