/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.zoning;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.converter.zoning.ZoningReader;
import org.goplanit.graph.directed.modifier.event.handler.SyncXmlIdToIdBreakEdgeSegmentHandler;
import org.goplanit.graph.modifier.event.handler.SyncXmlIdToIdBreakEdgeHandler;
import org.goplanit.gtfs.converter.zoning.GtfsZoningReaderSettings;
import org.goplanit.gtfs.converter.zoning.handler.GtfsPlanitFileHandlerStops;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerData;
import org.goplanit.gtfs.converter.zoning.handler.GtfsZoningHandlerProfiler;
import org.goplanit.gtfs.enums.GtfsFileType;
import org.goplanit.gtfs.enums.GtfsKeyType;
import org.goplanit.gtfs.reader.GtfsFileReaderStops;
import org.goplanit.gtfs.reader.GtfsReaderFactory;
import org.goplanit.gtfs.scheme.GtfsFileSchemeFactory;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.MacroscopicNetworkModifierUtils;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.modifier.UntypedDirectedGraphLayerModifier;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.zoning.Zoning;
import org.goplanit.zoning.ZoningModifierUtils;

public class GtfsZoningReader
implements ZoningReader {
    private static final Logger LOGGER = Logger.getLogger(GtfsZoningReader.class.getCanonicalName());
    private final GtfsZoningReaderSettings gtfsSettings;
    private final Zoning zoning;
    private final ServiceNetwork serviceNetwork;
    private final RoutedServices routedServices;
    private Function<String, TransferZone> gtfsStopIdToTransferZoneMapping;
    private boolean readInvoked;

    private void logSettings() {
        if (this.zoning.getTransferConnectoids().isEmpty()) {
            LOGGER.info("PLANit Zoning has no transfer zone connectoids, creating new transfer zones for each eligible GTFS stop");
        } else {
            LOGGER.info("PLANit Zoning has transfer zone connectoids, fusing existing transfer zones with GTFS stops where possible");
        }
        this.getSettings().logSettings();
    }

    private void syncIdsAndinitialiseEventListeners() {
        SyncXmlIdToIdBreakEdgeHandler syncXmlIdToIdOnBreakLink = new SyncXmlIdToIdBreakEdgeHandler();
        SyncXmlIdToIdBreakEdgeSegmentHandler syncXmlIdToIdOnBreakLinkSegment = new SyncXmlIdToIdBreakEdgeSegmentHandler();
        MacroscopicNetwork referenceNetwork = this.serviceNetwork.getParentNetwork();
        for (MacroscopicNetworkLayer networkLayer : (MacroscopicNetworkLayers)referenceNetwork.getTransportLayers()) {
            UntypedDirectedGraphLayerModifier layerModifier = networkLayer.getLayerModifier();
            layerModifier.removeAllListeners();
            layerModifier.addListener((GraphModifierListener)syncXmlIdToIdOnBreakLink);
            layerModifier.addListener((GraphModifierListener)syncXmlIdToIdOnBreakLinkSegment);
        }
        LOGGER.info("Syncing PLANit network XML ids to internal ids");
        MacroscopicNetworkModifierUtils.syncManagedIdEntitiesContainerXmlIdsToIds((MacroscopicNetwork)referenceNetwork);
        LOGGER.info("Syncing PLANit zoning XML ids to internal ids");
        ZoningModifierUtils.syncManagedIdEntitiesContainerXmlIdsToIds((Zoning)this.zoning);
    }

    private GtfsZoningHandlerData initialiseBeforeParsing() {
        if (this.zoning.getCoordinateReferenceSystem() == null) {
            this.zoning.setCoordinateReferenceSystem(this.serviceNetwork.getParentNetwork().getCoordinateReferenceSystem());
        }
        this.readInvoked = false;
        this.syncIdsAndinitialiseEventListeners();
        return new GtfsZoningHandlerData(this.getSettings(), this.zoning, this.serviceNetwork, this.routedServices, new GtfsZoningHandlerProfiler());
    }

    private void processStops(GtfsZoningHandlerData gtfsZoningHandlerData) {
        LOGGER.info("Processing: mapping GTFS Stops...");
        GtfsPlanitFileHandlerStops stopsHandler = new GtfsPlanitFileHandlerStops(gtfsZoningHandlerData);
        GtfsFileReaderStops stopsFileReader = (GtfsFileReaderStops)GtfsReaderFactory.createFileReader(GtfsFileSchemeFactory.create(GtfsFileType.STOPS), this.getSettings().getInputSource());
        stopsFileReader.addHandler(stopsHandler);
        stopsFileReader.getSettings().excludeColumns(GtfsKeyType.STOP_CODE);
        stopsFileReader.getSettings().excludeColumns(GtfsKeyType.STOP_URL);
        stopsFileReader.getSettings().excludeColumns(GtfsKeyType.STOP_TIMEZONE);
        stopsFileReader.getSettings().excludeColumns(GtfsKeyType.WHEELCHAIR_BOARDING);
        stopsFileReader.read(StandardCharsets.UTF_8);
    }

    private void doMainProcessing(GtfsZoningHandlerData zoningHandlerData) {
        LOGGER.info("Processing: Identifying GTFS Stops, supplementing PLANit transfer zones memory model...");
        this.processStops(zoningHandlerData);
        LOGGER.info("Processing: GTFS stops Done");
    }

    protected GtfsZoningReader(GtfsZoningReaderSettings settings, Zoning zoningToPopulate) {
        this(settings, zoningToPopulate, null, null);
    }

    protected GtfsZoningReader(GtfsZoningReaderSettings settings, Zoning zoningToPopulate, ServiceNetwork serviceNetwork, RoutedServices routedServices) {
        this.gtfsSettings = settings;
        this.zoning = zoningToPopulate;
        this.serviceNetwork = serviceNetwork;
        this.routedServices = routedServices;
    }

    public Zoning read() {
        PlanItRunTimeException.throwIf((boolean)StringUtils.isNullOrBlank((String)this.getSettings().getCountryName()), (String)"Country not set for GTFS zoning reader, unable to proceed", (Object[])new Object[0]);
        PlanItRunTimeException.throwIfNull((Object)this.getSettings().getInputSource(), (String)"Input source not set for GTFS zoning reader, unable to proceed");
        PlanItRunTimeException.throwIfNull((Object)this.serviceNetwork.getParentNetwork(), (String)"Reference physical network not available when parsing GTFS zoning, unable to proceed");
        GtfsZoningHandlerData zoningHandlerData = this.initialiseBeforeParsing();
        this.logSettings();
        this.doMainProcessing(zoningHandlerData);
        zoningHandlerData.getProfiler().logProcessingStats(this.zoning);
        this.gtfsStopIdToTransferZoneMapping = zoningHandlerData.createGtfsStopToTransferZoneMappingFunction();
        this.readInvoked = true;
        return this.zoning;
    }

    public void reset() {
        this.readInvoked = false;
        this.gtfsStopIdToTransferZoneMapping = null;
    }

    public GtfsZoningReaderSettings getSettings() {
        return this.gtfsSettings;
    }

    public Function<String, TransferZone> getGtfsStopIdToTransferZoneMapping() {
        if (!this.readInvoked) {
            LOGGER.warning("Unable to provide GTFS Stop id to transfer zone mapping before read() has been invoked on reader, ignored");
            return null;
        }
        return this.gtfsStopIdToTransferZoneMapping;
    }
}

