/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service.handler;

import java.time.LocalTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.gtfs.converter.GtfsConverterHandlerData;
import org.goplanit.gtfs.converter.service.GtfsServicesHandlerProfiler;
import org.goplanit.gtfs.converter.service.GtfsServicesReaderSettings;
import org.goplanit.gtfs.entity.GtfsCalendar;
import org.goplanit.gtfs.entity.GtfsRoute;
import org.goplanit.gtfs.entity.GtfsTrip;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.misc.CustomIndexTracker;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.RoutedTripSchedule;
import org.goplanit.utils.time.ExtendedLocalTime;

public class GtfsServicesHandlerData
extends GtfsConverterHandlerData {
    private static final Logger LOGGER = Logger.getLogger(GtfsServicesHandlerData.class.getCanonicalName());
    private final GtfsServicesHandlerProfiler handlerProfiler;
    Map<String, GtfsCalendar> activeGtfsServiceIdCalendars;
    CustomIndexTracker customIndexTracker;
    Map<String, Pair<RouteType, RouteRemovalType>> removedRoutes;
    Map<TripRemovalType, Set<String>> removedGtfsTrips;
    Map<Mode, RoutedServicesLayer> routedServiceLayerByMode;
    Map<ServiceLeg, Mode> serviceLegMapMapping;
    final RoutedServices routedServices;

    private void initialise(RoutedServices routedServices) {
        this.routedServiceLayerByMode = routedServices.getLayers().indexLayersByMode();
        this.serviceLegMapMapping = new HashMap<ServiceLeg, Mode>();
        this.activeGtfsServiceIdCalendars = new HashMap<String, GtfsCalendar>();
        this.customIndexTracker = new CustomIndexTracker();
        this.customIndexTracker.initialiseEntityContainer(RoutedService.class, routedService -> routedService.getExternalId());
        this.customIndexTracker.initialiseEntityContainer(GtfsTrip.class, gtfsTrip -> gtfsTrip.getTripId());
        this.customIndexTracker.initialiseEntityContainer(RoutedTripSchedule.class, planitScheduledTrip -> planitScheduledTrip.getExternalId());
        this.customIndexTracker.initialiseEntityContainer(ServiceNode.class, GtfsServicesHandlerData.getServiceNodeToGtfsStopIdMapping());
        this.removedRoutes = new HashMap<String, Pair<RouteType, RouteRemovalType>>();
        this.removedGtfsTrips = new HashMap<TripRemovalType, Set<String>>();
    }

    public GtfsServicesHandlerData(GtfsServicesReaderSettings settings, ServiceNetwork serviceNetwork, RoutedServices routedServices, GtfsServicesHandlerProfiler handlerProfiler) {
        super(serviceNetwork, settings);
        this.routedServices = routedServices;
        this.handlerProfiler = handlerProfiler;
        this.initialise(routedServices);
    }

    RoutedServicesLayer getRoutedServicesLayer(Mode mode) {
        return this.routedServiceLayerByMode.get(mode);
    }

    public void indexByExternalId(RoutedService planitRoutedService) {
        this.customIndexTracker.register(RoutedService.class, (Object)planitRoutedService);
    }

    public RoutedService getRoutedServiceByExternalId(String externalId) {
        return (RoutedService)this.customIndexTracker.get(RoutedService.class, (Object)externalId);
    }

    public void registeredRemovedRoute(GtfsRoute gtfsRoute, RouteRemovalType reason) {
        this.removedRoutes.put(gtfsRoute.getRouteId(), (Pair<RouteType, RouteRemovalType>)Pair.of((Object)((Object)gtfsRoute.getRouteType()), (Object)((Object)reason)));
    }

    public boolean isGtfsRouteRemoved(String gtfsRouteId) {
        return this.removedRoutes.containsKey(gtfsRouteId);
    }

    public RouteRemovalType getGtfsRemovedRouteRemovalType(String gtfsRouteId) {
        return (RouteRemovalType)((Object)this.removedRoutes.getOrDefault(gtfsRouteId, (Pair<RouteType, RouteRemovalType>)Pair.of(null, (Object)((Object)RouteRemovalType.UNKNOWN))).second());
    }

    public void registeredRemovedGtfsTrip(GtfsTrip gtfsTrip, TripRemovalType type) {
        Set<String> removedGtfsTripsByType = this.removedGtfsTrips.get((Object)type);
        if (removedGtfsTripsByType == null) {
            removedGtfsTripsByType = new HashSet<String>();
            this.removedGtfsTrips.put(type, removedGtfsTripsByType);
        }
        removedGtfsTripsByType.add(gtfsTrip.getTripId());
    }

    public boolean isGtfsTripRemoved(String gtfsTripId) {
        return this.removedGtfsTrips.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(gtfsTripId)).findFirst().isPresent();
    }

    public void registerServiceLegMode(ServiceLeg parentLeg, Mode serviceLegMode) {
        this.serviceLegMapMapping.put(parentLeg, serviceLegMode);
    }

    public Mode getServiceLegMode(ServiceLeg serviceLeg) {
        return this.serviceLegMapMapping.get(serviceLeg);
    }

    public void registerServiceIdCalendarAsActive(GtfsCalendar gtfsCalendar) {
        this.activeGtfsServiceIdCalendars.put(gtfsCalendar.getServiceId(), gtfsCalendar);
    }

    public boolean hasActiveServiceIds() {
        return !this.activeGtfsServiceIdCalendars.isEmpty();
    }

    public boolean isServiceIdActivated(String serviceId) {
        return this.activeGtfsServiceIdCalendars.containsKey(serviceId);
    }

    public boolean isDepartureTimeOfServiceIdWithinEligibleTimePeriod(String serviceId, ExtendedLocalTime departureTime) {
        if (!this.isServiceIdActivated(serviceId)) {
            return false;
        }
        Function<LocalTime, Boolean> isEligibleDeparture = withinDayDepartureTime -> {
            if (!this.getSettings().hasTimePeriodFilters()) {
                return true;
            }
            return this.getSettings().getTimePeriodFilters().stream().anyMatch(period -> !((LocalTime)period.first()).isAfter((LocalTime)withinDayDepartureTime) && !((LocalTime)period.second()).isBefore((LocalTime)withinDayDepartureTime));
        };
        GtfsCalendar gtfsCalendar = this.activeGtfsServiceIdCalendars.get(serviceId);
        if (gtfsCalendar.isActiveOn(this.getSettings().getDayOfWeek())) {
            if (departureTime.exceedsSingleDay()) {
                return false;
            }
            return isEligibleDeparture.apply(departureTime.asLocalTimeBeforeMidnight());
        }
        if (gtfsCalendar.isActiveOn(this.getSettings().getDayOfWeek().minus(1L))) {
            if (!departureTime.exceedsSingleDay()) {
                return false;
            }
            return isEligibleDeparture.apply(departureTime.asLocalTimeAfterMidnight());
        }
        LOGGER.severe("ServiceId active but GTFSCalendar entry does not match eligible active day, this should not happen");
        return false;
    }

    public void indexByExternalId(ServiceNode planitServiceNode) {
        this.customIndexTracker.register(ServiceNode.class, (Object)planitServiceNode);
    }

    public ServiceNode getServiceNodeByExternalId(String externalId) {
        return (ServiceNode)this.customIndexTracker.get(ServiceNode.class, (Object)externalId);
    }

    public void indexByGtfsTripId(GtfsTrip gtfsTrip) {
        this.customIndexTracker.register(GtfsTrip.class, (Object)gtfsTrip);
    }

    public GtfsTrip getGtfsTripByGtfsTripId(String gtfsTripId) {
        return (GtfsTrip)this.customIndexTracker.get(GtfsTrip.class, (Object)gtfsTripId);
    }

    public void indexByExternalId(RoutedTripSchedule planitScheduleBasedTrip) {
        this.customIndexTracker.register(RoutedTripSchedule.class, (Object)planitScheduleBasedTrip);
    }

    public RoutedTripSchedule getPlanitScheduleBasedTripByExternalId(String externalId) {
        return (RoutedTripSchedule)this.customIndexTracker.get(RoutedTripSchedule.class, (Object)externalId);
    }

    public static Function<ServiceNode, String> getServiceNodeToGtfsStopIdMapping() {
        return ExternalIdAble::getExternalId;
    }

    public RoutedServices getRoutedServices() {
        return this.routedServices;
    }

    public GtfsServicesHandlerProfiler getProfiler() {
        return this.handlerProfiler;
    }

    @Override
    public GtfsServicesReaderSettings getSettings() {
        return (GtfsServicesReaderSettings)super.getSettings();
    }

    public static enum RouteRemovalType {
        SETTINGS_EXCLUDED,
        MODE_INCOMPATIBLE,
        UNKNOWN;

    }

    public static enum TripRemovalType {
        ROUTE_EXCLUDED,
        ROUTE_MODE_INCOMPATIBLE,
        SERVICE_ID_DISCARDED,
        TIME_PERIOD_DISCARDED,
        UNKNOWN;

    }
}

