/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service.handler;

import java.util.logging.Logger;
import org.goplanit.gtfs.converter.service.handler.GtfsServicesHandlerData;
import org.goplanit.gtfs.entity.GtfsTrip;
import org.goplanit.gtfs.handler.GtfsFileHandlerTrips;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.service.routed.RoutedService;

public class GtfsPlanitFileHandlerTrips
extends GtfsFileHandlerTrips {
    private static final Logger LOGGER = Logger.getLogger(GtfsPlanitFileHandlerTrips.class.getCanonicalName());
    private final GtfsServicesHandlerData data;

    private void processMissingRoute(GtfsTrip gtfsTrip) {
        if (!this.data.isGtfsRouteRemoved(gtfsTrip.getRouteId())) {
            LOGGER.severe(String.format("Unable to find GTFS route %s in PLANit memory model corresponding to GTFS trip %s, GTFS trip ignored", gtfsTrip.getRouteId(), gtfsTrip.getTripId()));
            this.data.registeredRemovedGtfsTrip(gtfsTrip, GtfsServicesHandlerData.TripRemovalType.UNKNOWN);
            return;
        }
        GtfsServicesHandlerData.RouteRemovalType removalReason = this.data.getGtfsRemovedRouteRemovalType(gtfsTrip.getRouteId());
        switch (removalReason) {
            case MODE_INCOMPATIBLE: {
                this.data.registeredRemovedGtfsTrip(gtfsTrip, GtfsServicesHandlerData.TripRemovalType.ROUTE_MODE_INCOMPATIBLE);
                return;
            }
            case SETTINGS_EXCLUDED: {
                this.data.registeredRemovedGtfsTrip(gtfsTrip, GtfsServicesHandlerData.TripRemovalType.ROUTE_EXCLUDED);
                return;
            }
        }
        LOGGER.severe(String.format("Unable to find GTFS route removal reason for GTFS trip %s, this should not happen, GTFS trip ignored", gtfsTrip.getRouteId(), gtfsTrip.getTripId()));
        this.data.registeredRemovedGtfsTrip(gtfsTrip, GtfsServicesHandlerData.TripRemovalType.UNKNOWN);
    }

    public GtfsPlanitFileHandlerTrips(GtfsServicesHandlerData gtfsServicesHandlerData) {
        this.data = gtfsServicesHandlerData;
        PlanItRunTimeException.throwIfNull((Object)this.data.getRoutedServices(), (String)"Routed services not present, unable to parse GTFS trips");
        PlanItRunTimeException.throwIfNull((Object)this.data.getServiceNetwork(), (String)"Services network not present, unable to parse GTFS trips");
        PlanItRunTimeException.throwIfNull((Object)this.data.hasActiveServiceIds(), (String)"GTFS Calendar likely not yet parsed, no service ids activated, unable to parse GTFS trips");
        PlanItRunTimeException.throwIf((this.data.getRoutedServices().getLayers().isEachLayerEmpty() ? 1 : 0) != 0, (String)"No GTFS routes parsed yet, unable to parse GTFS trips", (Object[])new Object[0]);
    }

    @Override
    public void handle(GtfsTrip gtfsTrip) {
        if (!this.data.isServiceIdActivated(gtfsTrip.getServiceId())) {
            this.data.registeredRemovedGtfsTrip(gtfsTrip, GtfsServicesHandlerData.TripRemovalType.SERVICE_ID_DISCARDED);
            return;
        }
        RoutedService planitRoutedService = this.data.getRoutedServiceByExternalId(gtfsTrip.getRouteId());
        if (planitRoutedService == null) {
            this.processMissingRoute(gtfsTrip);
            return;
        }
        this.data.indexByGtfsTripId(gtfsTrip);
    }
}

