/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.gtfs.converter.service.handler.GtfsServicesHandlerData;
import org.goplanit.gtfs.entity.GtfsStopTime;
import org.goplanit.gtfs.entity.GtfsTrip;
import org.goplanit.gtfs.handler.GtfsFileHandlerStopTimes;
import org.goplanit.gtfs.util.GtfsUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServiceTripInfo;
import org.goplanit.utils.service.routed.RoutedTripDeparture;
import org.goplanit.utils.service.routed.RoutedTripSchedule;
import org.goplanit.utils.time.ExtendedLocalTime;

public class GtfsPlanitFileHandlerStopTimes
extends GtfsFileHandlerStopTimes {
    private static final Logger LOGGER = Logger.getLogger(GtfsPlanitFileHandlerStopTimes.class.getCanonicalName());
    private final GtfsServicesHandlerData data;
    private final Set<String> activatedLoggingForGtfsRoutesByShortName;
    private final Map<String, Set<String>> uniqueRoutesForStopsIfLoggingRequired = new HashMap<String, Set<String>>();
    private GtfsTrip prevStopTimeTrip;
    private GtfsStopTime prevSameTripStopTime;

    private boolean isConsideredEqual(GtfsStopTime left, GtfsStopTime right) {
        return left.getTripId().equals(right.getTripId()) && left.getStopId().equals(right.getStopId()) && left.getDepartureTime().equals(right.getDepartureTime()) && left.getArrivalTime().equals(right.getArrivalTime());
    }

    private RoutedTripSchedule collectScheduledTrip(GtfsTrip gtfsTrip, RoutedService planitRoutedService) {
        RoutedTripSchedule planitTrip = this.data.getPlanitScheduleBasedTripByExternalId(gtfsTrip.getTripId());
        if (planitTrip == null) {
            RoutedServiceTripInfo tripsForService = planitRoutedService.getTripInfo();
            planitTrip = (RoutedTripSchedule)tripsForService.getScheduleBasedTrips().getFactory().registerNew();
            planitTrip.setXmlId(planitTrip.getId());
            planitTrip.setExternalId(gtfsTrip.getTripId());
            this.data.indexByExternalId(planitTrip);
            this.data.getProfiler().incrementScheduledTripCount();
        }
        return planitTrip;
    }

    private void registerDeparture(RoutedTripSchedule planitTrip, GtfsStopTime gtfsStopTime, ExtendedLocalTime departureTime) {
        RoutedTripDeparture departure = planitTrip.getDepartures().getFactory().registerNew(departureTime);
        departure.setXmlId(departure.getId());
    }

    private ServiceNode collectOrRegisterServiceNode(ServiceNetworkLayer layer, GtfsStopTime gtfsStopTime) {
        ServiceNode currServiceNode = this.data.getServiceNodeByExternalId(gtfsStopTime.getStopId());
        if (currServiceNode == null) {
            currServiceNode = layer.getServiceNodes().getFactory().registerNew();
            currServiceNode.setXmlId(currServiceNode.getId());
            currServiceNode.setExternalId(gtfsStopTime.getStopId());
            this.data.indexByExternalId(currServiceNode);
        }
        return currServiceNode;
    }

    private ServiceLegSegment collectOrRegisterNetworkServiceSegment(ServiceNetworkLayer layer, Mode serviceModeForStop, GtfsStopTime gtfsStopTime) {
        ServiceNode currServiceNode;
        ServiceNode prevServiceNode = this.data.getServiceNodeByExternalId(this.prevSameTripStopTime.getStopId());
        ServiceLegSegment serviceNetworkSegment = prevServiceNode.getLegSegment(currServiceNode = this.collectOrRegisterServiceNode(layer, gtfsStopTime));
        if (serviceNetworkSegment != null && !this.data.getServiceLegMode(serviceNetworkSegment.getParent()).equals(serviceModeForStop)) {
            serviceNetworkSegment = null;
        }
        if (serviceNetworkSegment == null) {
            ServiceLeg parentLeg = null;
            boolean dirPrevCur = true;
            ServiceLegSegment oppositeDirLegSegment = currServiceNode.getLegSegment(prevServiceNode);
            if (oppositeDirLegSegment == null) {
                parentLeg = layer.getLegs().getFactory().registerNew(prevServiceNode, currServiceNode, true);
                parentLeg.setXmlId(parentLeg.getId());
                parentLeg.setExternalId(parentLeg.getVertexA().getExternalId() + "_" + parentLeg.getVertexB().getExternalId());
            } else {
                parentLeg = oppositeDirLegSegment.getParent();
                dirPrevCur = false;
            }
            serviceNetworkSegment = layer.getLegSegments().getFactory().registerNew(parentLeg, dirPrevCur, true);
            serviceNetworkSegment.setXmlId(serviceNetworkSegment.getId());
            serviceNetworkSegment.setExternalId(dirPrevCur ? serviceNetworkSegment.getUpstreamServiceNode().getExternalId() + "_" + serviceNetworkSegment.getDownstreamServiceNode().getExternalId() : serviceNetworkSegment.getDownstreamServiceNode().getExternalId() + "_" + serviceNetworkSegment.getUpstreamServiceNode().getExternalId());
            this.data.registerServiceLegMode(parentLeg, serviceModeForStop);
        }
        return serviceNetworkSegment;
    }

    public GtfsPlanitFileHandlerStopTimes(GtfsServicesHandlerData gtfsServicesHandlerData) {
        this(gtfsServicesHandlerData, new HashSet<String>());
    }

    public GtfsPlanitFileHandlerStopTimes(GtfsServicesHandlerData gtfsServicesHandlerData, Set<String> activatedLoggingForGtfsRoutesByShortName) {
        this.data = gtfsServicesHandlerData;
        this.activatedLoggingForGtfsRoutesByShortName = activatedLoggingForGtfsRoutesByShortName;
        PlanItRunTimeException.throwIfNull((Object)this.data.getRoutedServices(), (String)"Routed services not present, unable to parse GTFS stop times");
        PlanItRunTimeException.throwIfNull((Object)this.data.getServiceNetwork(), (String)"Services network not present, unable to parse GTFS stop times");
        PlanItRunTimeException.throwIf((this.data.getRoutedServices().getLayers().isEachLayerEmpty() ? 1 : 0) != 0, (String)"No GTFS routes parsed yet, unable to parse GTFS stop times", (Object[])new Object[0]);
        this.reset();
    }

    @Override
    public void handle(GtfsStopTime gtfsStopTime) {
        if (this.data.isGtfsTripRemoved(gtfsStopTime.getTripId())) {
            return;
        }
        GtfsTrip gtfsTrip = this.data.getGtfsTripByGtfsTripId(gtfsStopTime.getTripId());
        if (gtfsTrip == null) {
            return;
        }
        RoutedService planitRoutedService = this.data.getRoutedServiceByExternalId(gtfsTrip.getRouteId());
        boolean logTrackedRoute = this.activatedLoggingForGtfsRoutesByShortName.contains(planitRoutedService.getName());
        if (planitRoutedService == null) {
            LOGGER.severe(String.format("Unable to find GTFS route %s in PLANit memory model corresponding to GTFS trip %s, GTFS stop time (stop id %s) ignored", gtfsTrip.getRouteId(), gtfsTrip.getTripId(), gtfsStopTime.getStopId()));
            return;
        }
        ServiceNetworkLayer layer = (ServiceNetworkLayer)this.data.getServiceNetwork().getLayerByMode(planitRoutedService.getMode());
        boolean isTripDepartureTime = false;
        if (gtfsTrip != this.prevStopTimeTrip) {
            this.prevSameTripStopTime = null;
            isTripDepartureTime = true;
        }
        ExtendedLocalTime arrivalTime = GtfsUtils.parseGtfsTime(gtfsStopTime.getArrivalTime());
        ExtendedLocalTime departureTime = GtfsUtils.parseGtfsTime(gtfsStopTime.getDepartureTime());
        if (isTripDepartureTime && !this.data.isDepartureTimeOfServiceIdWithinEligibleTimePeriod(gtfsTrip.getServiceId(), departureTime)) {
            if (!this.data.getSettings().isIncludePartialGtfsTripsIfStopsInTimePeriod()) {
                this.data.registeredRemovedGtfsTrip(gtfsTrip, GtfsServicesHandlerData.TripRemovalType.TIME_PERIOD_DISCARDED);
            }
            return;
        }
        if (!isTripDepartureTime && this.prevSameTripStopTime != null && this.isConsideredEqual(gtfsStopTime, this.prevSameTripStopTime)) {
            this.data.getProfiler().incrementDuplicateStopTimeCount();
            return;
        }
        RoutedTripSchedule planitTrip = this.collectScheduledTrip(gtfsTrip, planitRoutedService);
        if (planitTrip.getDepartures().isEmpty()) {
            this.registerDeparture(planitTrip, gtfsStopTime, departureTime);
            this.collectOrRegisterServiceNode(layer, gtfsStopTime);
        } else {
            if (this.prevStopTimeTrip == null) {
                LOGGER.severe(String.format("GTFS trip's stop times not consecutive for GTFS trip %s, GTFS parser does not yet support such stop_time files, log GitHub feature request!", gtfsStopTime.getTripId()));
                return;
            }
            ServiceLegSegment serviceNetworkSegment = this.collectOrRegisterNetworkServiceSegment(layer, planitRoutedService.getMode(), gtfsStopTime);
            ExtendedLocalTime duration = arrivalTime.minus(GtfsUtils.parseGtfsTime(this.prevSameTripStopTime.getDepartureTime()));
            ExtendedLocalTime dwellTime = departureTime.minus(arrivalTime);
            if (duration.exceedsSingleDay() || dwellTime.exceedsSingleDay()) {
                LOGGER.severe(String.format("Duration (%s) between stops (%s, %s) and/or dwell time at stop (%s) should be less than a day, ignored", duration, serviceNetworkSegment.getUpstreamServiceNode().getExternalId(), serviceNetworkSegment.getDownstreamServiceNode().getExternalId(), dwellTime));
                return;
            }
            planitTrip.addRelativeLegSegmentTiming(serviceNetworkSegment, duration.asLocalTimeBeforeMidnight(), dwellTime.asLocalTimeBeforeMidnight());
        }
        if (logTrackedRoute) {
            LOGGER.info(String.format("[TRACK] stop: %s, trip: %s, route: %s (%s), arrival--departure: %s -- %s", gtfsStopTime.getStopId(), planitTrip.getExternalId(), planitRoutedService.getName(), planitRoutedService.getNameDescription(), arrivalTime, departureTime));
        }
        if (this.data.getSettings().isLogGtfsStopRoute(gtfsStopTime.getStopId())) {
            this.uniqueRoutesForStopsIfLoggingRequired.putIfAbsent(gtfsStopTime.getStopId(), new TreeSet());
            this.uniqueRoutesForStopsIfLoggingRequired.get(gtfsStopTime.getStopId()).add("(name: " + planitRoutedService.getName() + " id: " + gtfsTrip.getRouteId() + ")");
        }
        this.data.getProfiler().incrementTripStopTimeCount();
        this.prevSameTripStopTime = gtfsStopTime;
        this.prevStopTimeTrip = gtfsTrip;
    }

    @Override
    public void reset() {
        this.prevSameTripStopTime = null;
        this.prevStopTimeTrip = null;
        this.uniqueRoutesForStopsIfLoggingRequired.clear();
    }

    public Map<String, Set<String>> getUniqueRoutesForTrackedGtfsStops() {
        return this.uniqueRoutesForStopsIfLoggingRequired;
    }
}

