/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service.handler;

import java.util.logging.Logger;
import org.goplanit.gtfs.converter.service.handler.GtfsServicesHandlerData;
import org.goplanit.gtfs.entity.GtfsRoute;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.gtfs.handler.GtfsFileHandlerRoutes;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.service.routed.RoutedModeServices;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServicesLayer;

public class GtfsPlanitFileHandlerRoutes
extends GtfsFileHandlerRoutes {
    private static final Logger LOGGER = Logger.getLogger(GtfsPlanitFileHandlerRoutes.class.getCanonicalName());
    private final GtfsServicesHandlerData data;

    public GtfsPlanitFileHandlerRoutes(GtfsServicesHandlerData gtfsServicesHandlerData) {
        this.data = gtfsServicesHandlerData;
        PlanItRunTimeException.throwIfNull((Object)this.data.getRoutedServices(), (String)"Routed services not present, unable to parse GTFS routes");
        PlanItRunTimeException.throwIfNull((Object)this.data.getServiceNetwork(), (String)"Services network not present, unable to parse GTFS routes");
    }

    @Override
    public void handle(GtfsRoute gtfsRoute) {
        if (!this.data.getSettings().isGtfsRouteIncludedByShortName(gtfsRoute.getShortName())) {
            this.data.registeredRemovedRoute(gtfsRoute, GtfsServicesHandlerData.RouteRemovalType.SETTINGS_EXCLUDED);
            return;
        }
        RouteType routeType = gtfsRoute.getRouteType();
        Mode planitMode = this.data.getPrimaryPlanitModeIfActivated(routeType);
        if (planitMode == null) {
            this.data.registeredRemovedRoute(gtfsRoute, GtfsServicesHandlerData.RouteRemovalType.MODE_INCOMPATIBLE);
            return;
        }
        RoutedServicesLayer layer = this.data.getRoutedServicesLayer(planitMode);
        if (layer == null) {
            LOGGER.severe(String.format("DISCARD: No PLANit layer available for PLANit mode %s that was activated and mapped from GTFS route type %s for GTFS Route %s", new Object[]{planitMode, gtfsRoute.getRouteType(), gtfsRoute.getRouteId()}));
            return;
        }
        RoutedModeServices servicesPerMode = layer.getServicesByMode(planitMode);
        RoutedService planitRoutedService = servicesPerMode.getFactory().registerNew();
        planitRoutedService.setXmlId(planitRoutedService.getId());
        planitRoutedService.setExternalId(gtfsRoute.getRouteId());
        if (!gtfsRoute.hasValidName()) {
            LOGGER.warning("GTFS route with id %s has no valid name (either long or short)");
        }
        if (gtfsRoute.hasShortName()) {
            planitRoutedService.setName(gtfsRoute.getShortName());
        }
        if (gtfsRoute.hasLongName()) {
            planitRoutedService.setNameDescription(gtfsRoute.getLongName());
        }
        if (gtfsRoute.hasRouteDescription()) {
            planitRoutedService.setServiceDescription(gtfsRoute.getRouteDescription());
        }
        this.data.indexByExternalId(planitRoutedService);
        this.data.getProfiler().incrementRouteCount(gtfsRoute.getRouteType());
    }
}

