/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service.handler;

import java.util.logging.Logger;
import org.goplanit.gtfs.converter.service.handler.GtfsServicesHandlerData;
import org.goplanit.gtfs.entity.GtfsFrequency;
import org.goplanit.gtfs.handler.GtfsFileHandlerFrequencies;
import org.goplanit.utils.exceptions.PlanItRunTimeException;

public class GtfsPlanitFileHandlerFrequencies
extends GtfsFileHandlerFrequencies {
    private static final Logger LOGGER = Logger.getLogger(GtfsPlanitFileHandlerFrequencies.class.getCanonicalName());
    private final GtfsServicesHandlerData data;

    public GtfsPlanitFileHandlerFrequencies(GtfsServicesHandlerData gtfsServicesHandlerData) {
        this.data = gtfsServicesHandlerData;
        PlanItRunTimeException.throwIfNull((Object)this.data.getRoutedServices(), (String)"Routed services not present, unable to parse GTFS frequencies");
        PlanItRunTimeException.throwIfNull((Object)this.data.getServiceNetwork(), (String)"Services network not present, unable to parse GTFS frequencies");
        PlanItRunTimeException.throwIf((this.data.getRoutedServices().getLayers().isEachLayerEmpty() ? 1 : 0) != 0, (String)"No GTFS routes parsed yet, unable to parse GTFS frequencies", (Object[])new Object[0]);
    }

    @Override
    public void handle(GtfsFrequency gtfsFrequency) {
        PlanItRunTimeException.throwIf((boolean)true, (String)"GTFS frequency handler not yet implemented", (Object[])new Object[0]);
    }
}

