/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service;

import java.net.URL;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.converter.ConverterReaderSettings;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettingsWithModeMapping;
import org.goplanit.gtfs.converter.RouteTypeExtendedToPredefinedPlanitModeMappingCreator;
import org.goplanit.gtfs.converter.RouteTypeOriginalToPlanitModeMappingCreator;
import org.goplanit.gtfs.enums.RouteTypeChoice;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.ComparablePair;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.UrlUtils;
import org.goplanit.utils.network.layer.service.ServiceNode;

public class GtfsServicesReaderSettings
extends GtfsConverterReaderSettingsWithModeMapping
implements ConverterReaderSettings {
    private static final Logger LOGGER = Logger.getLogger(GtfsServicesReaderSettings.class.getCanonicalName());
    private static final Function<ServiceNode, String> GET_SERVICENODE_TO_GTFS_STOP_ID_FUNCTION = sn -> sn.getExternalId();
    private boolean groupIdenticalGtfsTrips = true;
    private DayOfWeek dayOfWeek;
    private final Set<ComparablePair<LocalTime, LocalTime>> timePeriodFilters;
    private final Set<String> exceptionsToBlanketBlackListByShortName = new TreeSet<String>();
    private final Set<String> excludeGtfsRoutesByShortName = new HashSet<String>();
    private boolean includePartialGtfsTripsWithInvalidDepartureIfStopsInTimePeriod = true;
    private Set<String> logGtfsRouteInformationByShortName = new HashSet<String>();
    private final Set<String> logGtfsStopRoutes = new HashSet<String>();
    public static final boolean DEFAULT_GROUP_IDENTICAL_GTFS_TRIPS = true;
    public static final boolean DEFAULT_INCLUDE_PARTIAL_GTFS_TRIPS_IF_STOPS_IN_TIME_PERIOD = true;

    @Override
    protected void initialiseDefaultModeMappings() {
        switch (this.routeTypeChoice) {
            case EXTENDED: {
                RouteTypeExtendedToPredefinedPlanitModeMappingCreator.execute(this);
            }
            case ORIGINAL: {
                RouteTypeOriginalToPlanitModeMappingCreator.execute(this);
                break;
            }
            default: {
                throw new PlanItRunTimeException("Unsupported GTFS route type choice encountered");
            }
        }
    }

    boolean validate() {
        if (this.getDayOfWeek() == null) {
            LOGGER.severe("Day of week not chosen for GTFS services reader settings, unable to continue");
            return false;
        }
        return true;
    }

    public static Function<ServiceNode, String> getServiceNodeToGtfsStopIdMapping() {
        return GET_SERVICENODE_TO_GTFS_STOP_ID_FUNCTION;
    }

    public GtfsServicesReaderSettings(String countryName) {
        this((URL)null, countryName, null, RouteTypeChoice.EXTENDED);
    }

    public GtfsServicesReaderSettings(String inputSource, String countryName, RouteTypeChoice routeTypeChoice) {
        this(inputSource, countryName, null, routeTypeChoice);
    }

    public GtfsServicesReaderSettings(String inputSource, String countryName, DayOfWeek dayOfWeekFilter, RouteTypeChoice routeTypeChoice) {
        this(inputSource == null ? null : UrlUtils.createFrom((String)inputSource), countryName, dayOfWeekFilter, routeTypeChoice);
    }

    public GtfsServicesReaderSettings(URL inputSource, String countryName, DayOfWeek dayOfWeekFilter, RouteTypeChoice routeTypeChoice) {
        super(inputSource, countryName, routeTypeChoice);
        this.dayOfWeek = dayOfWeekFilter;
        this.timePeriodFilters = new TreeSet<ComparablePair<LocalTime, LocalTime>>();
    }

    public void excludeAllGtfsRoutesExceptByShortName(String ... gtfsShortNames) {
        this.excludeAllGtfsRoutesExceptByShortName(Arrays.asList(gtfsShortNames));
    }

    public void excludeAllGtfsRoutesExceptByShortName(List<String> gtfsShortNames) {
        this.exceptionsToBlanketBlackListByShortName.addAll(gtfsShortNames);
    }

    public boolean isGtfsRouteIncludedByShortName(String gtfsShortName) {
        return !this.excludeGtfsRoutesByShortName.contains(gtfsShortName) && (this.exceptionsToBlanketBlackListByShortName.isEmpty() || this.exceptionsToBlanketBlackListByShortName.contains(gtfsShortName));
    }

    public void excludeGtfsRoutesByShortName(String ... gtfsShortNames) {
        this.excludeGtfsRoutesByShortName(Arrays.asList(gtfsShortNames));
    }

    public void excludeGtfsRoutesByShortName(List<String> gtfsShortNames) {
        this.excludeGtfsRoutesByShortName.addAll(gtfsShortNames);
    }

    public void activateLoggingForGtfsRouteByShortName(String gtfsShortName) {
        this.logGtfsRouteInformationByShortName.add(gtfsShortName);
    }

    public boolean isActivatedLoggingForGtfsRouteByShortName(String gtfsShortName) {
        return this.logGtfsRouteInformationByShortName.contains(gtfsShortName);
    }

    public Set<String> getActivatedLoggingForGtfsRoutesByShortName() {
        return Collections.unmodifiableSet(this.logGtfsRouteInformationByShortName);
    }

    public void addTimePeriodFilter(LocalTime startTimeWithinDay, LocalTime endTimeWithinDay) {
        ComparablePair newEntry = ComparablePair.of((Comparable)startTimeWithinDay, (Comparable)endTimeWithinDay);
        boolean overlap = this.timePeriodFilters.stream().anyMatch(e -> !startTimeWithinDay.isBefore((LocalTime)e.first()) && !startTimeWithinDay.isAfter((LocalTime)e.second()) || !endTimeWithinDay.isBefore((LocalTime)e.first()) && !endTimeWithinDay.isAfter((LocalTime)e.second()));
        if (overlap) {
            LOGGER.warning(String.format("[DISCARD] overlapping time period filter, consider revising filter (%s to %s)", startTimeWithinDay.format(DateTimeFormatter.ISO_LOCAL_TIME), endTimeWithinDay.format(DateTimeFormatter.ISO_LOCAL_TIME)));
            return;
        }
        this.timePeriodFilters.add((ComparablePair<LocalTime, LocalTime>)newEntry);
    }

    public Set<Pair<LocalTime, LocalTime>> getTimePeriodFilters() {
        return Collections.unmodifiableSet(this.timePeriodFilters);
    }

    public boolean hasTimePeriodFilters() {
        return this.getTimePeriodFilters() != null && !this.getTimePeriodFilters().isEmpty();
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public void logSettings() {
        super.logSettings();
        LOGGER.info(String.format("Activated day of week: %s", this.dayOfWeek.getDisplayName(TextStyle.FULL, Locale.ENGLISH)));
        if (this.hasTimePeriodFilters()) {
            LOGGER.info("Activated time periods:");
            this.getTimePeriodFilters().forEach(e -> LOGGER.info(String.format("Start-time: %s End-time: %s", ((LocalTime)e.first()).format(DateTimeFormatter.ISO_LOCAL_TIME), ((LocalTime)e.second()).format(DateTimeFormatter.ISO_LOCAL_TIME))));
        } else {
            LOGGER.info("Activated time periods: ALL - NO FILTER");
        }
        if (!this.exceptionsToBlanketBlackListByShortName.isEmpty()) {
            LOGGER.info(String.format("Filtering GTFS routes to only include: %s", String.join((CharSequence)",", this.exceptionsToBlanketBlackListByShortName)));
        }
        LOGGER.info(String.format("Consolidate identical GTFS trips: %s ", String.valueOf(this.isGroupIdenticalGtfsTrips())));
        LOGGER.info(String.format("Including partial GTFS trips for portion within time period: %s ", String.valueOf(this.isIncludePartialGtfsTripsIfStopsInTimePeriod())));
        for (String entry : this.logGtfsRouteInformationByShortName) {
            LOGGER.info(String.format("Tracking GTFS route %s information while parsing", entry));
        }
    }

    public boolean isGroupIdenticalGtfsTrips() {
        return this.groupIdenticalGtfsTrips;
    }

    public void setGroupIdenticalGtfsTrips(boolean groupIdenticalGtfsTrips) {
        this.groupIdenticalGtfsTrips = groupIdenticalGtfsTrips;
    }

    public boolean isIncludePartialGtfsTripsIfStopsInTimePeriod() {
        return this.includePartialGtfsTripsWithInvalidDepartureIfStopsInTimePeriod;
    }

    public void setIncludePartialGtfsTripsIfStopsInTimePeriod(boolean includePartialGtfsTripsIfStopsInTimePeriod) {
        this.includePartialGtfsTripsWithInvalidDepartureIfStopsInTimePeriod = includePartialGtfsTripsIfStopsInTimePeriod;
    }

    public void addLogGtfsStopRoutes(String ... gtfsStopIds) {
        this.addLogGtfsStopRoutes(Arrays.asList(gtfsStopIds));
    }

    public void addLogGtfsStopRoutes(List<String> gtfsStopIds) {
        this.logGtfsStopRoutes.addAll(gtfsStopIds);
    }

    public boolean isLogGtfsStopRoute(String gtfsStopId) {
        return this.logGtfsStopRoutes.contains(gtfsStopId);
    }

    @Override
    public void reset() {
        super.reset();
        this.timePeriodFilters.clear();
        this.dayOfWeek = null;
        this.logGtfsStopRoutes.clear();
        this.excludeGtfsRoutesByShortName.clear();
        this.exceptionsToBlanketBlackListByShortName.clear();
    }
}

