/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service;

import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.PairConverterReader;
import org.goplanit.gtfs.converter.service.GtfsServicesHandlerProfiler;
import org.goplanit.gtfs.converter.service.GtfsServicesReaderSettings;
import org.goplanit.gtfs.converter.service.handler.GtfsPlanitFileHandlerCalendar;
import org.goplanit.gtfs.converter.service.handler.GtfsPlanitFileHandlerRoutes;
import org.goplanit.gtfs.converter.service.handler.GtfsPlanitFileHandlerStopTimes;
import org.goplanit.gtfs.converter.service.handler.GtfsPlanitFileHandlerTrips;
import org.goplanit.gtfs.converter.service.handler.GtfsServicesHandlerData;
import org.goplanit.gtfs.entity.GtfsCalendar;
import org.goplanit.gtfs.enums.GtfsFileType;
import org.goplanit.gtfs.reader.GtfsFileReaderCalendars;
import org.goplanit.gtfs.reader.GtfsFileReaderRoutes;
import org.goplanit.gtfs.reader.GtfsFileReaderStopTimes;
import org.goplanit.gtfs.reader.GtfsFileReaderTrips;
import org.goplanit.gtfs.reader.GtfsReaderFactory;
import org.goplanit.gtfs.scheme.GtfsFileSchemeFactory;
import org.goplanit.gtfs.util.GtfsConverterReaderHelper;
import org.goplanit.gtfs.util.GtfsRoutedServicesModifierUtils;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;

public class GtfsServicesReader
implements PairConverterReader<ServiceNetwork, RoutedServices> {
    private static final Logger LOGGER = Logger.getLogger(GtfsServicesReader.class.getCanonicalName());
    private MacroscopicNetwork referenceNetwork = null;
    private final GtfsServicesReaderSettings settings;
    private IdGroupingToken idToken;

    private GtfsServicesHandlerData initialiseBeforeParsing() {
        ServiceNetwork serviceNetwork = new ServiceNetwork(this.idToken, this.referenceNetwork);
        RoutedServices routedServices = new RoutedServices(this.idToken, serviceNetwork);
        PlanItRunTimeException.throwIf((routedServices.getParentNetwork() != serviceNetwork ? 1 : 0) != 0, (String)"Routed services its service network does not match the service network provided", (Object[])new Object[0]);
        PlanItRunTimeException.throwIf((!((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).isEmpty() && ((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).isEachLayerEmpty() ? 1 : 0) != 0, (String)"Service network is expected to have been initialise with empty layers before populating with GTFS routes", (Object[])new Object[0]);
        PlanItRunTimeException.throwIf((!routedServices.getLayers().isEmpty() && routedServices.getLayers().isEachLayerEmpty() ? 1 : 0) != 0, (String)"Routed services layers are expected to have been initialised empty when populating with GTFS routes", (Object[])new Object[0]);
        GtfsConverterReaderHelper.syncActivatedPlanitPredefinedModesBeforeParsing(this.getSettings(), serviceNetwork.getParentNetwork());
        ((MacroscopicNetworkLayers)this.referenceNetwork.getTransportLayers()).forEach(parentLayer -> ((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).getFactory().registerNew(parentLayer));
        ((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).forEach(parentLayer -> routedServices.getLayers().getFactory().registerNew(parentLayer));
        GtfsServicesHandlerProfiler handlerProfiler = new GtfsServicesHandlerProfiler();
        return new GtfsServicesHandlerData(this.getSettings(), serviceNetwork, routedServices, handlerProfiler);
    }

    private void logSettings() {
        this.getSettings().logSettings();
    }

    private void processFrequencies(GtfsServicesHandlerData fileHandlerData) {
    }

    private void processStopTimes(GtfsServicesHandlerData fileHandlerData) {
        LOGGER.info("Processing: parsing GTFS trip stop times...");
        GtfsPlanitFileHandlerStopTimes tripStopTimeHandler = new GtfsPlanitFileHandlerStopTimes(fileHandlerData, this.settings.getActivatedLoggingForGtfsRoutesByShortName());
        GtfsFileReaderStopTimes stopTimeFileReader = (GtfsFileReaderStopTimes)GtfsReaderFactory.createFileReader(GtfsFileSchemeFactory.create(GtfsFileType.STOP_TIMES), this.getSettings().getInputSource());
        stopTimeFileReader.addHandler(tripStopTimeHandler);
        stopTimeFileReader.read(StandardCharsets.UTF_8);
        tripStopTimeHandler.getUniqueRoutesForTrackedGtfsStops().entrySet().stream().forEach(e -> LOGGER.info(String.format("GTFS stop %s is visited by GTFS routes [%s]", e.getKey(), ((Set)e.getValue()).stream().collect(Collectors.joining(",")))));
    }

    private void processTrips(GtfsServicesHandlerData fileHandlerData) {
        LOGGER.info("Processing: parsing GTFS trips...");
        GtfsPlanitFileHandlerTrips tripsHandler = new GtfsPlanitFileHandlerTrips(fileHandlerData);
        GtfsFileReaderTrips tripsFileReader = (GtfsFileReaderTrips)GtfsReaderFactory.createFileReader(GtfsFileSchemeFactory.create(GtfsFileType.TRIPS), this.getSettings().getInputSource());
        tripsFileReader.addHandler(tripsHandler);
        tripsFileReader.read(StandardCharsets.UTF_8);
    }

    private void processCalendars(GtfsServicesHandlerData fileHandlerData) {
        LOGGER.info("Processing: parsing GTFS Calendar...");
        Predicate<GtfsCalendar> filterServiceIds = calRow -> calRow.isActiveOn(this.getSettings().getDayOfWeek()) || calRow.isActiveOn(this.getSettings().getDayOfWeek().minus(1L));
        GtfsPlanitFileHandlerCalendar calendarHandler = new GtfsPlanitFileHandlerCalendar(fileHandlerData, filterServiceIds);
        GtfsFileReaderCalendars calendarFileReader = (GtfsFileReaderCalendars)GtfsReaderFactory.createFileReader(GtfsFileSchemeFactory.create(GtfsFileType.CALENDARS), this.getSettings().getInputSource());
        calendarFileReader.addHandler(calendarHandler);
        calendarFileReader.read(StandardCharsets.UTF_8);
    }

    private void processRoutes(GtfsServicesHandlerData fileHandlerData) {
        LOGGER.info("Processing: parsing GTFS Routes...");
        GtfsPlanitFileHandlerRoutes routesHandler = new GtfsPlanitFileHandlerRoutes(fileHandlerData);
        GtfsFileReaderRoutes routesFileReader = (GtfsFileReaderRoutes)GtfsReaderFactory.createFileReader(GtfsFileSchemeFactory.create(GtfsFileType.ROUTES), this.getSettings().getInputSource());
        routesFileReader.addHandler(routesHandler);
        routesFileReader.read(StandardCharsets.UTF_8);
    }

    private void logPlanitStats(GtfsServicesHandlerData fileHandlerData) {
        fileHandlerData.getServiceNetwork().logInfo(LoggingUtils.serviceNetworkPrefix((long)fileHandlerData.getServiceNetwork().getId()));
        fileHandlerData.getRoutedServices().logInfo(LoggingUtils.routedServicesPrefix((long)fileHandlerData.getRoutedServices().getId()));
    }

    protected void doMainProcessing(GtfsServicesHandlerData fileHandlerData) {
        LOGGER.info("Processing: Identifying GTFS services, populating PLANit memory model...");
        this.processRoutes(fileHandlerData);
        this.processCalendars(fileHandlerData);
        this.processTrips(fileHandlerData);
        this.processStopTimes(fileHandlerData);
        this.processFrequencies(fileHandlerData);
        GtfsRoutedServicesModifierUtils.removeScheduledTripsWithoutLegs(fileHandlerData.getRoutedServices());
        GtfsRoutedServicesModifierUtils.removeServiceRoutesWithoutTrips(fileHandlerData.getRoutedServices());
        GtfsRoutedServicesModifierUtils.removeEmptyRoutedServices(fileHandlerData.getRoutedServices());
        if (this.getSettings().isGroupIdenticalGtfsTrips()) {
            LOGGER.info("Optimising: Consolidating GTFS trip departures with identical relative schedules...");
            GtfsRoutedServicesModifierUtils.groupIdenticallyScheduledPlanitTrips(fileHandlerData.getRoutedServices());
        }
        GtfsRoutedServicesModifierUtils.removeDuplicateTripDepartures(fileHandlerData.getRoutedServices());
        LOGGER.info("Processing: GTFS services Done");
    }

    protected GtfsServicesReader(MacroscopicNetwork referenceNetwork, GtfsServicesReaderSettings settings) {
        this(IdGroupingToken.collectGlobalToken(), referenceNetwork, settings);
    }

    protected GtfsServicesReader(IdGroupingToken idToken, MacroscopicNetwork referenceNetwork, GtfsServicesReaderSettings settings) {
        this.referenceNetwork = referenceNetwork;
        this.settings = settings;
        this.idToken = idToken;
    }

    public Pair<ServiceNetwork, RoutedServices> read() {
        PlanItRunTimeException.throwIf((boolean)StringUtils.isNullOrBlank((String)this.getSettings().getCountryName()), (String)"Country not set for GTFS services reader, unable to proceed", (Object[])new Object[0]);
        PlanItRunTimeException.throwIfNull((Object)this.getSettings().getInputSource(), (String)"Input directory not set for GTFS services reader, unable to proceed");
        PlanItRunTimeException.throwIfNull((Object)this.referenceNetwork, (String)"Reference network not available when parsing GTFS services, unable to proceed");
        GtfsServicesHandlerData fileHandlerData = this.initialiseBeforeParsing();
        boolean valid = this.getSettings().validate();
        if (!valid) {
            LOGGER.severe("GTFS routed services reader settings incomplete or invalid, unable to commence parsing");
            return null;
        }
        this.logSettings();
        this.doMainProcessing(fileHandlerData);
        fileHandlerData.getProfiler().logProcessingStats();
        this.logPlanitStats(fileHandlerData);
        return Pair.of((Object)fileHandlerData.getServiceNetwork(), (Object)fileHandlerData.getRoutedServices());
    }

    public Function<ServiceNode, String> getServiceNodeToGtfsStopIdMapping() {
        return GtfsServicesHandlerData.getServiceNodeToGtfsStopIdMapping();
    }

    public GtfsServicesReaderSettings getSettings() {
        return this.settings;
    }

    public String getTypeDescription() {
        return "GTFS services Reader";
    }

    public void reset() {
    }
}

