/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.gtfs.enums.RouteType;

public class GtfsServicesHandlerProfiler {
    private static final Logger LOGGER = Logger.getLogger(GtfsServicesHandlerProfiler.class.getCanonicalName());
    private Map<RouteType, LongAdder> gtfsRoutesCounter;
    private LongAdder gtfsScheduleBasedTripCounter;
    private LongAdder gtfsTripStopTimeCounter;
    private LongAdder gtfsDuplicateTripStopTimeCounter;
    private LongAdder gtfsFrequencyCounter;

    private void initialise() {
        this.gtfsRoutesCounter = new HashMap<RouteType, LongAdder>();
        this.gtfsTripStopTimeCounter = new LongAdder();
        this.gtfsScheduleBasedTripCounter = new LongAdder();
        this.gtfsFrequencyCounter = new LongAdder();
        this.gtfsDuplicateTripStopTimeCounter = new LongAdder();
    }

    public GtfsServicesHandlerProfiler() {
        this.initialise();
    }

    public void logProcessingStats() {
        LOGGER.info(String.format("[STATS] discarded %d duplicate GTFS trip stop time entries", this.gtfsDuplicateTripStopTimeCounter.longValue()));
        this.gtfsRoutesCounter.forEach((k, v) -> LOGGER.info(String.format("[STATS] processed %d GTFS routes - %s ", v.longValue(), k)));
        LOGGER.info(String.format("[STATS] processed %d GTFS trips (scheduled)", this.gtfsScheduleBasedTripCounter.longValue()));
        LOGGER.info(String.format("[STATS] processed %d GTFS trip stop times", this.gtfsTripStopTimeCounter.longValue()));
        LOGGER.info(String.format("[STATS] processed %d GTFS trip frequency entries", this.gtfsFrequencyCounter.longValue()));
    }

    public void reset() {
        this.gtfsRoutesCounter.clear();
        this.gtfsScheduleBasedTripCounter.reset();
        this.gtfsTripStopTimeCounter.reset();
        this.gtfsFrequencyCounter.reset();
    }

    public void incrementRouteCount(RouteType gtfsRouteType) {
        LongAdder routeTypeAdder = this.gtfsRoutesCounter.get((Object)gtfsRouteType);
        if (routeTypeAdder == null) {
            routeTypeAdder = new LongAdder();
            this.gtfsRoutesCounter.put(gtfsRouteType, routeTypeAdder);
        }
        routeTypeAdder.increment();
    }

    public void incrementTripFrequencyCount() {
        this.gtfsFrequencyCounter.increment();
    }

    public void incrementScheduledTripCount() {
        this.gtfsScheduleBasedTripCounter.increment();
    }

    public void incrementTripStopTimeCount() {
        this.gtfsTripStopTimeCounter.increment();
    }

    public void incrementDuplicateStopTimeCount() {
        this.gtfsDuplicateTripStopTimeCounter.increment();
    }
}

