/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.intermodal;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.algorithms.shortest.ShortestPathAStar;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.gtfs.converter.intermodal.GtfsIntermodalReaderSettings;
import org.goplanit.gtfs.converter.intermodal.GtfsServicesAndZoningIntegratorData;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.network.layer.service.ServiceLegSegmentImpl;
import org.goplanit.path.SimpleDirectedPathFactoryImpl;
import org.goplanit.path.SimpleDirectedPathImpl;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.IterableUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.path.DirectedPathFactory;
import org.goplanit.utils.path.SimpleDirectedPath;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class GtfsServicesAndZoningReaderIntegrator {
    private static final Logger LOGGER = Logger.getLogger(GtfsServicesAndZoningReaderIntegrator.class.getCanonicalName());
    private final GtfsServicesAndZoningIntegratorData data;
    private final Function<ServiceNode, String> serviceNodeToGtfsStopIdMapping;
    private final Function<String, TransferZone> gtfsStopIdToTransferZoneMapping;

    private void initialise() {
        this.data.initialise();
    }

    private Map<Node, List<DirectedConnectoid>> findTransferZoneConnectoidsGroupByAccessNode(String gtfsStopId, TransferZone transferZone, ServiceNode gtfsStopServiceNode) {
        Set<DirectedConnectoid> transferZoneConnectoids = this.data.getConnectoidsByAccessZone(transferZone);
        Map<Node, List<DirectedConnectoid>> resultByAccessNode = transferZoneConnectoids.stream().collect(Collectors.groupingBy(c -> c.getAccessNode()));
        if (gtfsStopServiceNode.hasPhysicalParentNodes()) {
            resultByAccessNode.entrySet().removeIf(e -> !gtfsStopServiceNode.isMappedToPhysicalParentNode((Node)e.getKey()));
        }
        if (resultByAccessNode.isEmpty() && gtfsStopServiceNode.hasPhysicalParentNodes()) {
            LOGGER.severe(String.format("Unable to find available transfer zone access nodes for leg segment, likely GTFS stop %s mapped to incorrect physical access node upon earlier path search", gtfsStopId));
        }
        return resultByAccessNode;
    }

    private SimpleDirectedPath findMostLikelyPathBetweenGtfsStopServiceNodes(ServiceNetworkLayer layer, ServiceLegSegment serviceLegSegment, Mode mode) {
        String gtfsStopIdUpstream = this.serviceNodeToGtfsStopIdMapping.apply(serviceLegSegment.getUpstreamServiceNode());
        TransferZone transferZoneUpstream = this.gtfsStopIdToTransferZoneMapping.apply(gtfsStopIdUpstream);
        String gtfsStopIdDownstream = this.serviceNodeToGtfsStopIdMapping.apply(serviceLegSegment.getDownstreamServiceNode());
        TransferZone transferZoneDownstream = this.gtfsStopIdToTransferZoneMapping.apply(gtfsStopIdDownstream);
        if (transferZoneUpstream == null || transferZoneDownstream == null) {
            return null;
        }
        if (gtfsStopIdUpstream.equals("2000449") && gtfsStopIdDownstream.equals("2000453")) {
            int n = 4;
        }
        Map<Node, List<DirectedConnectoid>> upstreamConnectoidsByAccessNode = this.findTransferZoneConnectoidsGroupByAccessNode(gtfsStopIdUpstream, transferZoneUpstream, serviceLegSegment.getUpstreamServiceNode());
        Map<Node, List<DirectedConnectoid>> downstreamConnectoidsByAccessNode = this.findTransferZoneConnectoidsGroupByAccessNode(gtfsStopIdDownstream, transferZoneDownstream, serviceLegSegment.getDownstreamServiceNode());
        if (upstreamConnectoidsByAccessNode.isEmpty() || downstreamConnectoidsByAccessNode.isEmpty()) {
            return null;
        }
        SimpleDirectedPath chosenPath = null;
        if (!layer.supports(mode)) {
            LOGGER.severe(String.format("Service layer does not seem to support the mode (%s), the service leg is attributed to, this shouldn't happen", mode.getName()));
            return null;
        }
        ShortestPathAStar shortestPathAlgo = this.data.getShortestPathAlgoByMode(mode);
        upstreamConnectoidsByAccessNode.values().forEach(cList -> cList.removeIf(c -> !c.isModeAllowed((Zone)transferZoneUpstream, mode)));
        downstreamConnectoidsByAccessNode.values().forEach(cList -> cList.removeIf(c -> !c.isModeAllowed((Zone)transferZoneDownstream, mode)));
        if (!upstreamConnectoidsByAccessNode.values().stream().flatMap(e -> e.stream()).findFirst().isPresent() && !downstreamConnectoidsByAccessNode.values().stream().flatMap(e -> e.stream()).findFirst().isPresent()) {
            LOGGER.severe(String.format("Service leg segment connecting GTFS stop pair [%s (%s), %s (%s)] not mode compatible [mode (%s)] with PLANit mapped stops (connectoids), this shouldn't happen", gtfsStopIdUpstream, transferZoneUpstream.getName(), gtfsStopIdDownstream, transferZoneDownstream.getName(), mode.getName()));
            return null;
        }
        Map<Node, List<DirectedConnectoid>> finalDownstreamConnectoidsByAccessNode = downstreamConnectoidsByAccessNode;
        TreeSet<SimpleDirectedPath> allLegSegmentPathOptions = new TreeSet<SimpleDirectedPath>(Comparator.comparing(Object::hashCode));
        upstreamConnectoidsByAccessNode.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(upstreamEntry -> {
            if (((List)upstreamEntry.getValue()).isEmpty()) {
                return;
            }
            finalDownstreamConnectoidsByAccessNode.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(downstreamEntry -> {
                if (((List)downstreamEntry.getValue()).isEmpty()) {
                    return;
                }
                Set<SimpleDirectedPath> accessNodePathOptions = this.createShortestPathsBetweenAccessNodes(mode, (List)upstreamEntry.getValue(), transferZoneUpstream, (List)downstreamEntry.getValue(), transferZoneDownstream, shortestPathAlgo);
                allLegSegmentPathOptions.addAll(accessNodePathOptions);
            });
        });
        if (allLegSegmentPathOptions.isEmpty()) {
            LOGGER.warning(String.format("Valid service leg segment [mode (%s)] connects GTFS stops [%s (%s), %s (%s)], but no eligible physical path found, verify expected path (partly) exits parsed bounding box", mode.getName(), gtfsStopIdUpstream, transferZoneUpstream.getName(), gtfsStopIdDownstream, transferZoneDownstream.getName()));
            return null;
        }
        chosenPath = allLegSegmentPathOptions.iterator().next();
        if (allLegSegmentPathOptions.size() > 1) {
            LOGGER.fine(String.format("Multiple paths possible between two GTFS stops (%s, %s) for mode %s, due to GTFS stop having multiple possible access points to physical network, e.g., train platform, choosing first", gtfsStopIdUpstream, gtfsStopIdDownstream, mode.getName()));
            chosenPath = allLegSegmentPathOptions.stream().min(Comparator.comparingDouble(p -> p.computeLengthKm())).get();
        }
        return chosenPath;
    }

    private Set<SimpleDirectedPath> createShortestPathsBetweenAccessNodes(Mode mode, List<DirectedConnectoid> upstreamAccessNodeConnectoids, TransferZone transferZoneUpstream, List<DirectedConnectoid> downstreamAccessNodeConnectoids, TransferZone transferZoneDownstream, ShortestPathAStar shortestPathAlgo) {
        HashSet<SimpleDirectedPath> createdPaths = new HashSet<SimpleDirectedPath>();
        for (DirectedConnectoid upstreamConnectoid : upstreamAccessNodeConnectoids) {
            if (!upstreamConnectoid.isModeAllowed((Zone)transferZoneUpstream, mode) || !upstreamConnectoid.getAccessLinkSegment().isModeAllowed(mode)) continue;
            for (DirectedConnectoid downstreamConnectoid : downstreamAccessNodeConnectoids) {
                if (!downstreamConnectoid.isModeAllowed((Zone)transferZoneDownstream, mode) || !downstreamConnectoid.getAccessLinkSegment().isModeAllowed(mode)) continue;
                try {
                    boolean banInitialUTurn = !mode.hasPhysicalFeatures() || mode.getPhysicalFeatures().getTrackType() == TrackModeType.ROAD;
                    HashSet<EdgeSegment> bannedLinkSegments = new HashSet<EdgeSegment>();
                    if (upstreamConnectoid.getAccessLinkSegment().getOppositeDirectionSegment() != null && banInitialUTurn) {
                        bannedLinkSegments.add(upstreamConnectoid.getAccessLinkSegment().getOppositeDirectionSegment());
                    }
                    if (downstreamConnectoid.getAccessLinkSegment().getOppositeDirectionSegment() != null) {
                        bannedLinkSegments.add(downstreamConnectoid.getAccessLinkSegment().getOppositeDirectionSegment());
                    }
                    ShortestPathResult result = shortestPathAlgo.executeOneToOne((DirectedVertex)upstreamConnectoid.getAccessNode(), (DirectedVertex)downstreamConnectoid.getAccessLinkSegment().getUpstreamNode(), bannedLinkSegments);
                    SimpleDirectedPathImpl foundPath = (SimpleDirectedPathImpl)result.createPath((DirectedPathFactory)new SimpleDirectedPathFactoryImpl(), (DirectedVertex)upstreamConnectoid.getAccessNode(), (DirectedVertex)downstreamConnectoid.getAccessLinkSegment().getUpstreamNode());
                    foundPath.append(new EdgeSegment[]{downstreamConnectoid.getAccessLinkSegment()});
                    createdPaths.add((SimpleDirectedPath)foundPath);
                }
                catch (PlanItRunTimeException planItRunTimeException) {}
            }
        }
        Iterator iter = createdPaths.iterator();
        while (iter.hasNext()) {
            SimpleDirectedPath currOption = (SimpleDirectedPath)iter.next();
            if (!createdPaths.stream().anyMatch(o -> o != currOption && currOption.containsSubPath(o.iterator()))) continue;
            iter.remove();
        }
        return createdPaths;
    }

    private void validateInputs() {
        PlanItRunTimeException.throwIfNull(this.serviceNodeToGtfsStopIdMapping, (String)"serviceNodeToGtfsStopIdMapping is null");
        PlanItRunTimeException.throwIfNull(this.gtfsStopIdToTransferZoneMapping, (String)"gtfsStopIdToTransferZoneMapping is null");
        PlanItRunTimeException.throwIfNull((Object)this.data.getServiceNetwork(), (String)"serviceNetwork is null");
        PlanItRunTimeException.throwIfNull((Object)this.data.getSettings(), (String)"GTFS Intermodal reader settings is null");
        PlanItRunTimeException.throwIfNull((Object)this.data.getZoning(), (String)"zoning is null");
        PlanItRunTimeException.throwIf((((MacroscopicNetworkLayers)this.data.getServiceNetwork().getParentNetwork().getTransportLayers()).size() > 1 ? 1 : 0) != 0, (String)"Currently GTFS converter only supports physical reference networks with a single layer", (Object[])new Object[0]);
        PlanItRunTimeException.throwIf((((ServiceNetworkLayers)this.data.getServiceNetwork().getTransportLayers()).size() > 1 ? 1 : 0) != 0, (String)"Currently GTFS converter only supports service networks with a single layer", (Object[])new Object[0]);
    }

    private void mapServiceLegSegmentToPhysicalNetwork(ServiceNetworkLayer layer, ServiceLegSegmentImpl legSegment) {
        Mode expectedMode = this.data.getExpectedModeForServiceLeg(legSegment.getParent());
        SimpleDirectedPath chosenPath = this.findMostLikelyPathBetweenGtfsStopServiceNodes(layer, (ServiceLegSegment)legSegment, expectedMode);
        if (chosenPath != null) {
            legSegment.setPhysicalParentSegments(IterableUtils.toTypeCastList((Iterable)chosenPath));
            return;
        }
    }

    public GtfsServicesAndZoningReaderIntegrator(GtfsIntermodalReaderSettings settings, Zoning zoning, ServiceNetwork serviceNetwork, RoutedServices routedServices, Function<ServiceNode, String> serviceNodeToGtfsStopIdMapping, Function<String, TransferZone> gtfsStopIdToTransferZoneMapping) {
        this.serviceNodeToGtfsStopIdMapping = serviceNodeToGtfsStopIdMapping;
        this.gtfsStopIdToTransferZoneMapping = gtfsStopIdToTransferZoneMapping;
        this.data = new GtfsServicesAndZoningIntegratorData(serviceNetwork, routedServices, zoning, settings);
        this.validateInputs();
    }

    public void execute() {
        this.initialise();
        ((ServiceNetworkLayers)this.data.getServiceNetwork().getTransportLayers()).forEach(l -> l.getLegs().forEach(leg -> leg.forEachSegment(legSegment -> this.mapServiceLegSegmentToPhysicalNetwork((ServiceNetworkLayer)l, (ServiceLegSegmentImpl)legSegment))));
    }

    public void reset() {
        this.data.reset();
    }
}

