/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.intermodal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestPathAStar;
import org.goplanit.component.PlanitComponentFactory;
import org.goplanit.cost.CostUtils;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.gtfs.converter.GtfsConverterHandlerData;
import org.goplanit.gtfs.converter.intermodal.GtfsIntermodalReaderSettings;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.network.UntypedPhysicalNetwork;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class GtfsServicesAndZoningIntegratorData {
    private static final Logger LOGGER = Logger.getLogger(GtfsServicesAndZoningIntegratorData.class.getCanonicalName());
    private final Zoning zoning;
    private final RoutedServices routedServices;
    private final GtfsIntermodalReaderSettings settings;
    private Map<Zone, Set<DirectedConnectoid>> connectoidsByAccessZone;
    private Map<Mode, ShortestPathAStar> shortestPathAlgoByMode;
    private Map<ServiceLeg, Mode> serviceLegToModeMapping;
    private GtfsConverterHandlerData modeMappingData;

    private void initialiseShortestPathAlgorithmForMode(Mode mode) {
        MacroscopicNetwork network = this.getServiceNetwork().getParentNetwork();
        IdGroupingToken idToken = network.getIdGroupingToken();
        AbstractPhysicalCost physicalCostApproach = (AbstractPhysicalCost)PlanitComponentFactory.create(AbstractPhysicalCost.class, (String)this.settings.getStopToStopPathSearchPhysicalCostApproach(), (Object[])new Object[]{idToken});
        double[] modalLinkSegmentCosts = CostUtils.createAndPopulateModalSegmentCost((Mode)mode, (AbstractPhysicalCost)physicalCostApproach, (UntypedPhysicalNetwork)network);
        int numberOfVerticesAllLayers = TransportModelNetwork.getNumberOfVerticesAllLayers((LayeredNetwork)network, (Zoning)this.zoning);
        double heuristicMultiplier = Math.min(1.0 / mode.getMaximumSpeedKmH(), ((MacroscopicNetworkLayer)network.getLayerByMode(mode)).findMaximumPaceHKm(mode));
        this.shortestPathAlgoByMode.put(mode, new ShortestPathAStar(modalLinkSegmentCosts, numberOfVerticesAllLayers, network.getCoordinateReferenceSystem(), heuristicMultiplier));
    }

    protected GtfsServicesAndZoningIntegratorData(ServiceNetwork serviceNetwork, RoutedServices routedServices, Zoning zoning, GtfsIntermodalReaderSettings settings) {
        this.modeMappingData = new GtfsConverterHandlerData(serviceNetwork, settings.getServiceSettings());
        this.settings = settings;
        this.zoning = zoning;
        this.routedServices = routedServices;
    }

    public void initialise() {
        this.connectoidsByAccessZone = this.zoning.getTransferConnectoids().createIndexByAccessZone();
        Collection eligibleServiceModes = ((ServiceNetworkLayers)this.getServiceNetwork().getTransportLayers()).getSupportedModes();
        eligibleServiceModes.retainAll(this.getActivatedPlanitModes());
        if (eligibleServiceModes.isEmpty()) {
            LOGGER.severe("No eligible modes found on any of the service network layers that are configured as activated for the GTFS reader, consider revising your configuration");
        }
        this.shortestPathAlgoByMode = new HashMap<Mode, ShortestPathAStar>();
        for (Mode mode : eligibleServiceModes) {
            this.initialiseShortestPathAlgorithmForMode(mode);
        }
        this.serviceLegToModeMapping = new HashMap<ServiceLeg, Mode>();
        this.routedServices.getLayers().forEach(l -> l.forEach(rs -> rs.forEach(s -> s.getTripInfo().getLegSegmentsStream().forEach(ls -> this.serviceLegToModeMapping.put(ls.getParent(), s.getMode())))));
    }

    public ServiceNetwork getServiceNetwork() {
        return this.modeMappingData.getServiceNetwork();
    }

    public Zoning getZoning() {
        return this.zoning;
    }

    public Collection<Mode> getActivatedPlanitModes() {
        return this.modeMappingData.getActivatedPlanitModesByGtfsMode();
    }

    public Mode getExpectedModeForServiceLeg(ServiceLeg serviceLeg) {
        return this.serviceLegToModeMapping.get(serviceLeg);
    }

    public Mode getPrimaryPlanitModeIfActivated(RouteType gtfsMode) {
        return this.modeMappingData.getPrimaryPlanitModeIfActivated(gtfsMode);
    }

    public List<Mode> getCompatiblePlanitModesIfActivated(RouteType gtfsMode) {
        return this.modeMappingData.getCompatiblePlanitModesIfActivated(gtfsMode);
    }

    public Set<Mode> getCompatiblePlanitModesIfActivated(Mode planitMode) {
        return this.modeMappingData.getCompatiblePlanitModesIfActivated(planitMode);
    }

    public Set<Mode> expandWithCompatibleModes(Mode planitMode) {
        return this.modeMappingData.expandWithCompatibleModes(planitMode);
    }

    public GtfsIntermodalReaderSettings getSettings() {
        return this.settings;
    }

    public Set<DirectedConnectoid> getConnectoidsByAccessZone(TransferZone transferZone) {
        return this.connectoidsByAccessZone.get(transferZone);
    }

    public ShortestPathAStar getShortestPathAlgoByMode(Mode mode) {
        return this.shortestPathAlgoByMode.get(mode);
    }

    public void reset() {
        this.connectoidsByAccessZone = null;
        this.shortestPathAlgoByMode = null;
    }
}

