/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.intermodal;

import java.net.URL;
import java.time.DayOfWeek;
import org.goplanit.converter.ConverterReaderSettings;
import org.goplanit.cost.physical.PhysicalCost;
import org.goplanit.gtfs.converter.service.GtfsServicesReaderSettings;
import org.goplanit.gtfs.converter.zoning.GtfsZoningReaderSettings;
import org.goplanit.gtfs.enums.RouteTypeChoice;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.UrlUtils;

public class GtfsIntermodalReaderSettings
implements ConverterReaderSettings {
    public final String DEFAULT_STOP_TO_STOP_COST_APPROACH;
    protected final GtfsServicesReaderSettings servicesReaderSettings;
    protected final GtfsZoningReaderSettings zoningSettings;
    private final String stopToStopPathSearchPhysicalCostApproach;

    public GtfsIntermodalReaderSettings(String countryName) {
        this(".", countryName, RouteTypeChoice.EXTENDED);
    }

    public GtfsIntermodalReaderSettings(String inputSource, String countryName, RouteTypeChoice routeTypeChoice) {
        this.stopToStopPathSearchPhysicalCostApproach = this.DEFAULT_STOP_TO_STOP_COST_APPROACH = PhysicalCost.FREEFLOW;
        this.servicesReaderSettings = new GtfsServicesReaderSettings(inputSource, countryName, routeTypeChoice);
        this.zoningSettings = new GtfsZoningReaderSettings(this.servicesReaderSettings);
    }

    public GtfsIntermodalReaderSettings(String inputSource, String countryName, DayOfWeek dayOfWeek, RouteTypeChoice routeTypeChoice) {
        this(inputSource == null ? null : UrlUtils.createFrom((String)inputSource), countryName, dayOfWeek, routeTypeChoice);
    }

    public GtfsIntermodalReaderSettings(URL inputSource, String countryName, DayOfWeek dayOfWeek, RouteTypeChoice routeTypeChoice) {
        this.stopToStopPathSearchPhysicalCostApproach = this.DEFAULT_STOP_TO_STOP_COST_APPROACH = PhysicalCost.FREEFLOW;
        this.servicesReaderSettings = new GtfsServicesReaderSettings(inputSource, countryName, dayOfWeek, routeTypeChoice);
        this.zoningSettings = new GtfsZoningReaderSettings(this.servicesReaderSettings);
    }

    public void reset() {
        this.getServiceSettings().reset();
        this.getZoningSettings().reset();
    }

    public void logSettings() {
        this.getServiceSettings().logSettings();
        this.getZoningSettings().logSettings();
    }

    public GtfsServicesReaderSettings getServiceSettings() {
        return this.servicesReaderSettings;
    }

    public GtfsZoningReaderSettings getZoningSettings() {
        return this.zoningSettings;
    }

    public String getCountryName() {
        return this.servicesReaderSettings.getCountryName();
    }

    public URL getInputSource() {
        return this.servicesReaderSettings.getInputSource();
    }

    public void setInputFile(String inputFile) {
        try {
            URL urlInputSource = UrlUtils.createFromLocalPath((String)inputFile);
            this.getServiceSettings().setInputSource(urlInputSource);
            this.getZoningSettings().setInputSource(urlInputSource);
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to extract URL from input file location %s", new Object[]{inputFile});
        }
    }

    public String getStopToStopPathSearchPhysicalCostApproach() {
        return this.stopToStopPathSearchPhysicalCostApproach;
    }
}

