/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.intermodal;

import com.sun.istack.NotNull;
import java.time.DayOfWeek;
import org.goplanit.converter.PairConverterReader;
import org.goplanit.gtfs.converter.intermodal.GtfsIntermodalReader;
import org.goplanit.gtfs.converter.intermodal.GtfsIntermodalReaderSettings;
import org.goplanit.gtfs.enums.RouteTypeChoice;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.zoning.Zoning;

public class GtfsIntermodalReaderFactory {
    public static GtfsIntermodalReader create(String inputDirectory, String countryName, @NotNull DayOfWeek dayOfWeek, @NotNull MacroscopicNetwork parentNetwork, RouteTypeChoice typeChoice) {
        return GtfsIntermodalReaderFactory.create(inputDirectory, countryName, dayOfWeek, parentNetwork, IdGroupingToken.collectGlobalToken(), typeChoice);
    }

    public static GtfsIntermodalReader create(String inputDirectory, String countryName, @NotNull DayOfWeek dayOfWeek, @NotNull MacroscopicNetwork parentNetwork, @NotNull IdGroupingToken zoningIdToken, RouteTypeChoice typeChoice) {
        Zoning emptyZoning = new Zoning(zoningIdToken, parentNetwork.getNetworkGroupingTokenId());
        return GtfsIntermodalReaderFactory.create(inputDirectory, countryName, dayOfWeek, parentNetwork, emptyZoning, typeChoice);
    }

    public static GtfsIntermodalReader create(String inputDirectory, String countryName, MacroscopicNetwork parentNetwork, Zoning parentZoning, RouteTypeChoice typeChoice) {
        GtfsIntermodalReaderSettings intermodalReaderSettings = new GtfsIntermodalReaderSettings(inputDirectory, countryName, typeChoice);
        return GtfsIntermodalReaderFactory.create(parentNetwork, parentZoning, intermodalReaderSettings);
    }

    public static GtfsIntermodalReader create(String inputDirectory, String countryName, DayOfWeek dayOfWeek, MacroscopicNetwork parentNetwork, Zoning parentZoning, RouteTypeChoice typeChoice) {
        return GtfsIntermodalReaderFactory.create(parentNetwork, parentZoning, new GtfsIntermodalReaderSettings(inputDirectory, countryName, dayOfWeek, typeChoice));
    }

    public static GtfsIntermodalReader create(MacroscopicNetwork parentNetwork, Zoning parentZoning, GtfsIntermodalReaderSettings settings) {
        return new GtfsIntermodalReader(parentNetwork.getIdGroupingToken(), parentNetwork, parentZoning, settings);
    }

    public static GtfsIntermodalReader create(String countryName, PairConverterReader<MacroscopicNetwork, Zoning> networkAndZoningReader) {
        return GtfsIntermodalReaderFactory.create(new GtfsIntermodalReaderSettings(countryName), networkAndZoningReader);
    }

    public static GtfsIntermodalReader create(GtfsIntermodalReaderSettings settings, PairConverterReader<MacroscopicNetwork, Zoning> networkAndZoningReader) {
        return new GtfsIntermodalReader(networkAndZoningReader, settings);
    }
}

