/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter.intermodal;

import java.util.List;
import java.util.logging.Logger;
import org.goplanit.converter.PairConverterReader;
import org.goplanit.converter.intermodal.IntermodalReader;
import org.goplanit.gtfs.converter.intermodal.GtfsIntermodalReaderSettings;
import org.goplanit.gtfs.converter.intermodal.GtfsServicesAndZoningReaderIntegrator;
import org.goplanit.gtfs.converter.service.GtfsServicesReader;
import org.goplanit.gtfs.converter.service.GtfsServicesReaderFactory;
import org.goplanit.gtfs.converter.zoning.GtfsZoningReader;
import org.goplanit.gtfs.converter.zoning.GtfsZoningReaderFactory;
import org.goplanit.gtfs.util.GtfsRoutedServicesModifierUtils;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.service.routed.modifier.event.handler.SyncDeparturesXmlIdToIdHandler;
import org.goplanit.service.routed.modifier.event.handler.SyncRoutedServicesXmlIdToIdHandler;
import org.goplanit.service.routed.modifier.event.handler.SyncRoutedTripsXmlIdToIdHandler;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.Quadruple;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.zoning.Zoning;

public class GtfsIntermodalReader
implements IntermodalReader<ServiceNetwork, RoutedServices> {
    protected final GtfsIntermodalReaderSettings settings;
    private static final Logger LOGGER = Logger.getLogger(GtfsServicesReader.class.getCanonicalName());
    private IdGroupingToken idToken;
    private MacroscopicNetwork parentNetwork;
    private Zoning parentZoning;
    private PairConverterReader<MacroscopicNetwork, Zoning> networkAndZoningReader;

    private void truncateToServiceNetwork(RoutedServices routedServices) {
        List<SyncRoutedTripsXmlIdToIdHandler> listeners = List.of(new SyncDeparturesXmlIdToIdHandler(), new SyncRoutedServicesXmlIdToIdHandler(), new SyncRoutedTripsXmlIdToIdHandler());
        for (RoutedServicesLayer layer : routedServices.getLayers()) {
            listeners.forEach(l -> layer.getLayerModifier().addListener(l));
            layer.getLayerModifier().truncateToServiceNetwork();
            listeners.forEach(l -> layer.getLayerModifier().removeListener(l));
        }
    }

    protected GtfsIntermodalReader(IdGroupingToken idToken, MacroscopicNetwork parentNetwork, Zoning parentZoning, GtfsIntermodalReaderSettings settings) {
        this.settings = settings;
        this.idToken = idToken;
        this.networkAndZoningReader = null;
        this.parentNetwork = parentNetwork;
        this.parentZoning = parentZoning;
    }

    protected GtfsIntermodalReader(PairConverterReader<MacroscopicNetwork, Zoning> networkAndZoningReader, GtfsIntermodalReaderSettings settings) {
        this.settings = settings;
        this.idToken = null;
        this.networkAndZoningReader = networkAndZoningReader;
        this.parentNetwork = null;
        this.parentZoning = null;
    }

    public Pair<MacroscopicNetwork, Zoning> read() {
        LOGGER.warning("GTFS Intermodal Reader only supports readWithServices(), read() is not supported due to absence of physical network in GTFS data...");
        LOGGER.warning("...To parse a compatible network consider using the OSM Intermodal Reader or another compatible network reader to pre-load the network");
        return null;
    }

    public void reset() {
    }

    public GtfsIntermodalReaderSettings getSettings() {
        return this.settings;
    }

    public boolean supportServiceConversion() {
        return true;
    }

    public Quadruple<MacroscopicNetwork, Zoning, ServiceNetwork, RoutedServices> readWithServices() {
        if ((this.parentNetwork == null || this.parentZoning == null) && this.networkAndZoningReader == null) {
            LOGGER.severe("GTFS intermodal reader incorrectly configured, no network and/or zoning available, yet no reader present to construct them beforehand, this shouldn't happen");
            return null;
        }
        if (this.networkAndZoningReader != null) {
            Pair networkAndZoning = this.networkAndZoningReader.read();
            if (networkAndZoning == null || networkAndZoning.anyIsNull()) {
                LOGGER.severe("Unable to construct network and/or zoning for GTFS intermodal reader");
                return null;
            }
            this.parentNetwork = (MacroscopicNetwork)networkAndZoning.first();
            this.parentZoning = (Zoning)networkAndZoning.second();
            this.idToken = this.parentNetwork.getIdGroupingToken();
        }
        GtfsServicesReader servicesReader = GtfsServicesReaderFactory.create(this.parentNetwork, this.getSettings().getServiceSettings());
        Pair<ServiceNetwork, RoutedServices> servicesResult = servicesReader.read();
        GtfsZoningReader zoningReader = GtfsZoningReaderFactory.create(this.getSettings().getZoningSettings(), this.parentZoning, (ServiceNetwork)servicesResult.first(), (RoutedServices)servicesResult.second(), servicesReader.getServiceNodeToGtfsStopIdMapping());
        Zoning zoning = zoningReader.read();
        GtfsServicesAndZoningReaderIntegrator integrator = new GtfsServicesAndZoningReaderIntegrator(this.settings, zoning, (ServiceNetwork)servicesResult.first(), (RoutedServices)servicesResult.second(), servicesReader.getServiceNodeToGtfsStopIdMapping(), zoningReader.getGtfsStopIdToTransferZoneMapping());
        integrator.execute();
        ((ServiceNetworkLayers)((ServiceNetwork)servicesResult.first()).getTransportLayers()).forEach(l -> l.getLayerModifier().removeUnmappedServiceNetworkEntities());
        this.truncateToServiceNetwork((RoutedServices)servicesResult.second());
        if (this.getSettings().getServiceSettings().isGroupIdenticalGtfsTrips()) {
            LOGGER.info("Optimising: Consolidating remaining GTFS trip departures with identical relative schedules...");
            GtfsRoutedServicesModifierUtils.groupIdenticallyScheduledPlanitTrips((RoutedServices)servicesResult.second());
        }
        GtfsRoutedServicesModifierUtils.removeDuplicateTripDepartures((RoutedServices)servicesResult.second());
        if (this.getSettings().getZoningSettings().isRemoveUnusedTransferZones()) {
            zoning.getZoningModifier().removeUnusedTransferConnectoids((ServiceNetworkLayers)((ServiceNetwork)servicesResult.first()).getTransportLayers(), true);
            zoning.getZoningModifier().removeDanglingTransferZones(true);
            zoning.getZoningModifier().removeDanglingTransferZoneGroups();
        }
        LOGGER.info("Final result Stats:");
        this.parentNetwork.logInfo(LoggingUtils.networkPrefix((long)this.parentNetwork.getId()));
        zoning.logInfo(LoggingUtils.zoningPrefix((long)zoning.getId()));
        ((ServiceNetwork)servicesResult.first()).logInfo(LoggingUtils.serviceNetworkPrefix((long)((ServiceNetwork)servicesResult.first()).getId()));
        ((RoutedServices)servicesResult.second()).logInfo(LoggingUtils.routedServicesPrefix((long)((RoutedServices)servicesResult.second()).getId()));
        return Quadruple.of((Object)this.parentNetwork, (Object)zoning, (Object)((ServiceNetwork)servicesResult.first()), (Object)((RoutedServices)servicesResult.second()));
    }
}

