/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettingsWithModeMapping;
import org.goplanit.gtfs.converter.RouteTypeToPlanitModeMappingCreator;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.utils.mode.PredefinedModeType;

public class RouteTypeExtendedToPredefinedPlanitModeMappingCreator
extends RouteTypeToPlanitModeMappingCreator {
    public static void execute(GtfsConverterReaderSettingsWithModeMapping settings) {
        HashMap<PredefinedModeType, Set<RouteType>> modeMappings = new HashMap<PredefinedModeType, Set<RouteType>>();
        HashMap gtfs2PlanitModeMappings = new HashMap();
        Set<RouteType> trainTypes = RouteType.getInValueRange((short)100, (short)117);
        trainTypes.add(RouteType.of((short)400));
        trainTypes.addAll(RouteType.getInValueRange((short)403, (short)404));
        trainTypes.add(RouteType.of((short)1503));
        trainTypes.forEach(gtfsModeType -> gtfs2PlanitModeMappings.put(gtfsModeType, List.of(PredefinedModeType.TRAIN)));
        modeMappings.put(PredefinedModeType.TRAIN, trainTypes);
        Set<RouteType> busTypes = RouteType.getInValueRange((short)200, (short)209);
        busTypes.addAll(RouteType.getInValueRange((short)700, (short)716));
        busTypes.add(RouteType.of((short)800));
        busTypes.forEach(gtfsModeType -> gtfs2PlanitModeMappings.put(gtfsModeType, List.of(PredefinedModeType.BUS)));
        modeMappings.put(PredefinedModeType.BUS, busTypes);
        modeMappings.put(PredefinedModeType.SUBWAY, RouteType.getInValueRange((short)401, (short)402));
        busTypes.forEach(gtfsModeType -> gtfs2PlanitModeMappings.put(gtfsModeType, List.of(PredefinedModeType.BUS)));
        Set<RouteType> tramLightRailTypes = RouteType.getInValueRange((short)900, (short)906);
        modeMappings.put(PredefinedModeType.LIGHTRAIL, tramLightRailTypes);
        tramLightRailTypes.forEach(gtfsModeType -> gtfs2PlanitModeMappings.put(gtfsModeType, List.of(PredefinedModeType.TRAM, PredefinedModeType.LIGHTRAIL)));
        Set<RouteType> ferryWaterTypes = Set.of(RouteType.WATER_TAXI_SERVICE, RouteType.WATER_TRANSPORT_SERVICE, RouteType.FERRY_SERVICE);
        ferryWaterTypes.forEach(gtfsModeType -> gtfs2PlanitModeMappings.put(gtfsModeType, List.of(PredefinedModeType.FERRY)));
        gtfs2PlanitModeMappings.entrySet().forEach(e -> settings.setDefaultGtfs2PredefinedModeTypeMapping((RouteType)((Object)((Object)e.getKey())), (List)e.getValue()));
        gtfs2PlanitModeMappings.keySet().forEach(gtfsRouteType -> settings.activateGtfsRouteTypeMode((RouteType)((Object)gtfsRouteType)));
    }
}

