/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettingsImpl;
import org.goplanit.gtfs.converter.RouteTypeExtendedToPredefinedPlanitModeMappingCreator;
import org.goplanit.gtfs.converter.RouteTypeOriginalToPlanitModeMappingCreator;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.gtfs.enums.RouteTypeChoice;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.UrlUtils;
import org.goplanit.utils.mode.PredefinedModeType;

public class GtfsConverterReaderSettingsWithModeMapping
extends GtfsConverterReaderSettingsImpl {
    private static final Logger LOGGER = Logger.getLogger(GtfsConverterReaderSettingsWithModeMapping.class.getCanonicalName());
    protected final RouteTypeChoice routeTypeChoice;
    protected final Map<RouteType, List<PredefinedModeType>> defaultGtfsMode2PrefinedModeTypeMap;
    protected final Set<RouteType> activatedGtfsModes;

    private <T> Set<RouteType> findGtfsModesFor(Map<RouteType, List<T>> modeTypeMap, T modeMapping) {
        HashSet<RouteType> routeTypes = new HashSet<RouteType>();
        for (Map.Entry<RouteType, List<T>> entry : modeTypeMap.entrySet()) {
            if (!entry.getValue().contains(modeMapping) || !this.isGtfsModeActivated(entry.getKey())) continue;
            routeTypes.add(entry.getKey());
        }
        return routeTypes;
    }

    protected void initialiseDefaultModeMappings() {
        switch (this.routeTypeChoice) {
            case EXTENDED: {
                RouteTypeExtendedToPredefinedPlanitModeMappingCreator.execute(this);
            }
            case ORIGINAL: {
                RouteTypeOriginalToPlanitModeMappingCreator.execute(this);
                break;
            }
            default: {
                throw new PlanItRunTimeException("Unsupported GTFS route type choice encountered");
            }
        }
    }

    protected void setDefaultGtfs2PredefinedModeTypeMapping(RouteType gtfsRouteType, PredefinedModeType planitMode) {
        if (gtfsRouteType == null) {
            LOGGER.warning("GTFS mode is null, cannot add it to default PLANit mode mapping, ignored");
            return;
        }
        if (planitMode == PredefinedModeType.CUSTOM) {
            LOGGER.warning(String.format("PLANit mode is not a predefined type, cannot add it to default mode mapping, ignored", new Object[]{gtfsRouteType}));
            return;
        }
        List<PredefinedModeType> planitModes = this.defaultGtfsMode2PrefinedModeTypeMap.get((Object)gtfsRouteType);
        if (planitModes == null) {
            planitModes = new ArrayList<PredefinedModeType>(1);
            this.defaultGtfsMode2PrefinedModeTypeMap.put(gtfsRouteType, planitModes);
        }
        if (!planitModes.contains(planitMode)) {
            planitModes.add(planitMode);
        }
    }

    protected void setDefaultGtfs2PredefinedModeTypeMapping(RouteType gtfsRouteType, List<PredefinedModeType> planitModes) {
        planitModes.forEach(planitMode -> this.setDefaultGtfs2PredefinedModeTypeMapping(gtfsRouteType, (PredefinedModeType)planitMode));
    }

    protected void activateGtfsRouteTypeMode(RouteType gtfsMode) {
        if (gtfsMode == null) {
            LOGGER.warning("GTFS mode is null, cannot add it to Gtfs to PLANit mode mapping, ignored");
            return;
        }
        if (!this.defaultGtfsMode2PrefinedModeTypeMap.containsKey((Object)gtfsMode)) {
            LOGGER.warning(String.format("GTFS mode %s has no PLANit predefined mode type mapping, cannot activate, ignored", new Object[]{gtfsMode}));
            return;
        }
        this.activatedGtfsModes.add(gtfsMode);
    }

    protected GtfsConverterReaderSettingsWithModeMapping(String inputSource, String countryName, RouteTypeChoice routeTypeChoice) {
        this(UrlUtils.createFrom((String)inputSource), countryName, routeTypeChoice);
    }

    protected GtfsConverterReaderSettingsWithModeMapping(URL inputSource, String countryName, RouteTypeChoice routeTypeChoice) {
        super(inputSource, countryName);
        this.routeTypeChoice = routeTypeChoice;
        this.activatedGtfsModes = new HashSet<RouteType>();
        this.defaultGtfsMode2PrefinedModeTypeMap = new HashMap<RouteType, List<PredefinedModeType>>();
        this.initialiseDefaultModeMappings();
    }

    protected GtfsConverterReaderSettingsWithModeMapping(GtfsConverterReaderSettingsWithModeMapping other) {
        super(other.getInputSource(), other.getCountryName());
        this.routeTypeChoice = other.getRouteTypeChoice();
        this.activatedGtfsModes = other.activatedGtfsModes;
        this.defaultGtfsMode2PrefinedModeTypeMap = other.defaultGtfsMode2PrefinedModeTypeMap;
    }

    public void deactivateGtfsMode(RouteType gtfsMode) {
        if (gtfsMode == null) {
            LOGGER.warning("GTFS mode is null, cannot deactivate it, ignored");
            return;
        }
        LOGGER.fine(String.format("GTFS mode %s deactivated", new Object[]{gtfsMode}));
        this.activatedGtfsModes.remove((Object)gtfsMode);
    }

    public boolean isGtfsModeActivated(RouteType gtfsMode) {
        return this.activatedGtfsModes.contains((Object)gtfsMode);
    }

    public void deactivateGtfsModes(Collection<RouteType> GtfsModes) {
        for (RouteType gtfsMode : GtfsModes) {
            this.deactivateGtfsMode(gtfsMode);
        }
    }

    public void deactivateAllModesExcept(List<RouteType> remainingGtfsModes) {
        List<RouteType> toBeRemovedModes = List.of(RouteType.values());
        ArrayList remainingRoadModes = remainingGtfsModes == null ? new ArrayList() : remainingGtfsModes;
        TreeSet<RouteType> finalToBeRemovedModes = new TreeSet<RouteType>(toBeRemovedModes);
        finalToBeRemovedModes.removeAll(remainingRoadModes);
        this.deactivateGtfsModes(finalToBeRemovedModes);
    }

    public Collection<RouteType> getAcivatedGtfsModes() {
        return Collections.unmodifiableCollection(this.activatedGtfsModes);
    }

    public Set<PredefinedModeType> getAcivatedPlanitPredefinedModes() {
        return this.activatedGtfsModes.stream().flatMap(gtfsMode -> this.defaultGtfsMode2PrefinedModeTypeMap.getOrDefault(gtfsMode, Collections.emptyList()).stream()).filter(e -> e != null).collect(Collectors.toSet());
    }

    public List<PredefinedModeType> getAcivatedPlanitPredefinedModes(RouteType gtfsMode) {
        if (!this.activatedGtfsModes.contains((Object)gtfsMode)) {
            return null;
        }
        return this.defaultGtfsMode2PrefinedModeTypeMap.get((Object)gtfsMode);
    }

    public List<RouteType> getAcivatedGtfsModes(PredefinedModeType planitModeType) {
        Set mappedGtfsModes = this.defaultGtfsMode2PrefinedModeTypeMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(planitModeType)).map(e -> (RouteType)((Object)((Object)e.getKey()))).collect(Collectors.toSet());
        return mappedGtfsModes.stream().filter(this.activatedGtfsModes::contains).distinct().collect(Collectors.toList());
    }

    public Set<RouteType> findGtfsModesFor(PredefinedModeType predefinedModeType) {
        return this.findGtfsModesFor(this.defaultGtfsMode2PrefinedModeTypeMap, predefinedModeType);
    }

    public RouteTypeChoice getRouteTypeChoice() {
        return this.routeTypeChoice;
    }

    @Override
    public void logSettings() {
        super.logSettings();
        LOGGER.info(String.format("Route type choice set to: %s ", new Object[]{this.routeTypeChoice}));
        for (Map.Entry<RouteType, List<PredefinedModeType>> entry : this.defaultGtfsMode2PrefinedModeTypeMap.entrySet()) {
            if (this.activatedGtfsModes.contains((Object)entry.getKey())) {
                LOGGER.info(String.format("[ACTIVATED] %s --> %s", new Object[]{entry.getKey(), entry.getValue().stream().map(e -> e.toString()).collect(Collectors.joining(","))}));
                continue;
            }
            LOGGER.info(String.format("[DEACTIVATED] %s", new Object[]{entry.getKey()}));
        }
    }

    @Override
    public void reset() {
        super.reset();
    }
}

