/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter;

import java.net.URL;
import java.util.logging.Logger;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettings;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.UrlUtils;

public class GtfsConverterReaderSettingsImpl
implements GtfsConverterReaderSettings {
    private static final Logger LOGGER = Logger.getLogger(GtfsConverterReaderSettingsImpl.class.getCanonicalName());
    private URL inputSource;
    private final String countryName;

    public GtfsConverterReaderSettingsImpl(String countryName) {
        this(null, countryName);
    }

    public GtfsConverterReaderSettingsImpl(URL inputSource, String countryName) {
        this.inputSource = inputSource;
        this.countryName = countryName;
    }

    public void reset() {
    }

    @Override
    public final String getCountryName() {
        return this.countryName;
    }

    public final void setInputSource(URL inputSource) {
        this.inputSource = inputSource;
    }

    public void setInputFile(String inputFile) {
        try {
            this.setInputSource(UrlUtils.createFrom((String)inputFile));
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to extract URL from input source %s", new Object[]{this.inputSource});
        }
    }

    @Override
    public final URL getInputSource() {
        return this.inputSource;
    }

    @Override
    public void logSettings() {
        LOGGER.info(String.format("GTFS input source: %s", this.getInputSource()));
        LOGGER.info(String.format("Country: %s", this.getCountryName()));
    }
}

