/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gtfs.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.goplanit.gtfs.converter.GtfsConverterReaderSettingsWithModeMapping;
import org.goplanit.gtfs.enums.RouteType;
import org.goplanit.gtfs.util.GtfsConverterReaderHelper;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.utils.containers.ContainerUtils;
import org.goplanit.utils.containers.ListUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;

public class GtfsConverterHandlerData {
    private HashMap<RouteType, List<Mode>> activatedPlanitModesByGtfsMode;
    private Set<Mode> activatedPlanitModes;
    private Map<Mode, SortedSet<Mode>> secondaryModeCompatibility;
    final ServiceNetwork serviceNetwork;
    final GtfsConverterReaderSettingsWithModeMapping settings;

    public GtfsConverterHandlerData(ServiceNetwork serviceNetwork, GtfsConverterReaderSettingsWithModeMapping settings) {
        this.serviceNetwork = serviceNetwork;
        this.activatedPlanitModesByGtfsMode = GtfsConverterReaderHelper.createCombinedActivatedPlanitModes(settings, this.getServiceNetwork().getParentNetwork().getModes());
        this.activatedPlanitModes = this.activatedPlanitModesByGtfsMode.values().stream().flatMap(e -> e.stream()).collect(Collectors.toSet());
        this.settings = settings;
        this.secondaryModeCompatibility = new HashMap<Mode, SortedSet<Mode>>();
        for (List<Mode> planitModesForGtfsMode : this.activatedPlanitModesByGtfsMode.values()) {
            if (planitModesForGtfsMode.size() <= 1) continue;
            List currModePairPermutations = ListUtils.getPairPermutations(planitModesForGtfsMode, (boolean)false);
            for (Pair entry : currModePairPermutations) {
                SortedSet result = this.secondaryModeCompatibility.getOrDefault(entry.first(), new TreeSet());
                result.add((Mode)entry.second());
                this.secondaryModeCompatibility.put((Mode)entry.first(), result);
            }
        }
    }

    public ServiceNetwork getServiceNetwork() {
        return this.serviceNetwork;
    }

    public Set<Mode> getActivatedPlanitModesByGtfsMode() {
        return Collections.unmodifiableSet(this.activatedPlanitModes);
    }

    public Mode getPrimaryPlanitModeIfActivated(RouteType gtfsMode) {
        List<Mode> availableModes = this.activatedPlanitModesByGtfsMode.get((Object)gtfsMode);
        if (availableModes == null || availableModes.isEmpty()) {
            return null;
        }
        return availableModes.get(0);
    }

    public List<Mode> getCompatiblePlanitModesIfActivated(RouteType gtfsMode) {
        return ContainerUtils.wrapInUnmodifiableListUnlessNull(this.activatedPlanitModesByGtfsMode.get((Object)gtfsMode));
    }

    public SortedSet<Mode> getCompatiblePlanitModesIfActivated(Mode planitMode) {
        return ContainerUtils.wrapInUnmodifiableSortedSetUnlessNull(this.secondaryModeCompatibility.get(planitMode));
    }

    public SortedSet<Mode> expandWithCompatibleModes(Mode planitMode) {
        SortedSet<Mode> compatibleAltModes = this.secondaryModeCompatibility.get(planitMode);
        if (compatibleAltModes == null) {
            return new TreeSet<Mode>(Collections.singleton(planitMode));
        }
        return Stream.concat(compatibleAltModes.stream(), Stream.of(planitMode)).collect(Collectors.toCollection(TreeSet::new));
    }

    public GtfsConverterReaderSettingsWithModeMapping getSettings() {
        return this.settings;
    }
}

