package org.goplanit.gtfs.reader;

import java.net.URL;

import org.goplanit.gtfs.scheme.GtfsTransfersScheme;
import org.goplanit.gtfs.util.GtfsFileConditions;

/**
 * A GTFS file reader for parsing GTFS transfers entries
 * 
 * @author markr
 *
 */
public class GtfsFileReaderTransfers extends GtfsFileReaderBase {

  /**
   * Constructor
   * 
   * @param gtfsLocation to extract file to parse from (dir or zip file)
   * @param filePresenceCondition on being present
   */
  protected GtfsFileReaderTransfers(URL gtfsLocation, GtfsFileConditions filePresenceCondition) {
    super(new GtfsTransfersScheme(), gtfsLocation, filePresenceCondition);
  }

}
