/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning.modifier.event.handler;

import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.graph.directed.modifier.event.BreakEdgeSegmentEvent;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModifierListener;
import org.goplanit.utils.graph.modifier.event.GraphModificationEvent;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.locationtech.jts.geom.Point;

public class UpdateDirectedConnectoidsOnBreakLinkSegmentHandler
implements DirectedGraphModifierListener {
    private static final Logger LOGGER = Logger.getLogger(UpdateDirectedConnectoidsOnBreakLinkSegmentHandler.class.getCanonicalName());
    private final Map<Point, DirectedConnectoid> connectoidsAccessNodeLocationBeforeBreakLink;

    protected void updateConnectedAccessLinkSegment(DirectedVertex vertex, LinkSegment brokenEdgeSegment) {
        DirectedConnectoid connectoid = null;
        if (this.connectoidsAccessNodeLocationBeforeBreakLink.containsKey(brokenEdgeSegment.getDownstreamVertex().getPosition()) && !(connectoid = this.connectoidsAccessNodeLocationBeforeBreakLink.get(brokenEdgeSegment.getDownstreamVertex().getPosition())).isNodeAccessDownstream()) {
            LOGGER.severe(String.format("update of connectoids only supported when access node resides on downstream end of access link segment, but for connectoid %d this is not the case", connectoid.getId()));
            return;
        }
        if (connectoid != null && !connectoid.getAccessLinkSegment().idEquals((Object)brokenEdgeSegment) && brokenEdgeSegment.getUpstreamVertex().idEquals((Object)connectoid.getAccessLinkSegment().getDownstreamVertex()) && brokenEdgeSegment.getUpstreamVertex().idEquals((Object)vertex)) {
            connectoid.replaceAccessLinkSegment(brokenEdgeSegment);
        }
    }

    public UpdateDirectedConnectoidsOnBreakLinkSegmentHandler(Map<Point, DirectedConnectoid> connectoidsAccessNodeLocationBeforeBreakLink) {
        this.connectoidsAccessNodeLocationBeforeBreakLink = connectoidsAccessNodeLocationBeforeBreakLink;
    }

    public EventType[] getKnownSupportedEventTypes() {
        return new EventType[]{BreakEdgeSegmentEvent.EVENT_TYPE};
    }

    public void onGraphModificationEvent(GraphModificationEvent event) {
        LOGGER.warning(String.format("%s only supports break edge segment events", UpdateDirectedConnectoidsOnBreakLinkSegmentHandler.class.getName()));
    }

    public void onDirectedGraphModificationEvent(DirectedGraphModificationEvent event) {
        if (!event.getType().equals((Object)BreakEdgeSegmentEvent.EVENT_TYPE)) {
            LOGGER.warning(String.format("%s only supports break edge segment events", UpdateDirectedConnectoidsOnBreakLinkSegmentHandler.class.getName()));
            return;
        }
        BreakEdgeSegmentEvent breakEdgeSegmentEvent = (BreakEdgeSegmentEvent)((Object)BreakEdgeSegmentEvent.class.cast(event));
        this.updateConnectedAccessLinkSegment(breakEdgeSegmentEvent.getVertexToBreakAt(), (LinkSegment)breakEdgeSegmentEvent.getNewlyBrokenEdgeSegment());
    }
}

