/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning.modifier.event.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.graph.modifier.event.RemoveSubGraphEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphVertexEvent;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModifierListener;
import org.goplanit.utils.graph.modifier.event.GraphModificationEvent;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.zoning.Zoning;

public class UpdateConnectoidsOnVertexRemovalHandler
implements DirectedGraphModifierListener {
    private static final Logger LOGGER = Logger.getLogger(UpdateConnectoidsOnVertexRemovalHandler.class.getCanonicalName());
    protected final Zoning zoning;
    protected Map<DirectedVertex, ArrayList<Connectoid>> connectoidsByAccessVertex;
    boolean removedConnectoids = false;

    protected void initialiseIndices() {
        DirectedVertex accessVertex;
        if (this.zoning == null) {
            LOGGER.severe(String.format("Zoning is null when initialising in %s, %s invalid", this.getClass().getName()));
        }
        this.connectoidsByAccessVertex = new HashMap<DirectedVertex, ArrayList<Connectoid>>();
        for (UndirectedConnectoid connectoid : this.zoning.getOdConnectoids()) {
            accessVertex = connectoid.getAccessVertex();
            if (accessVertex == null) continue;
            this.connectoidsByAccessVertex.putIfAbsent(accessVertex, new ArrayList(1));
            this.connectoidsByAccessVertex.get(accessVertex).add((Connectoid)connectoid);
        }
        for (UndirectedConnectoid connectoid : this.zoning.getTransferConnectoids()) {
            accessVertex = connectoid.getAccessVertex();
            if (accessVertex == null) continue;
            this.connectoidsByAccessVertex.putIfAbsent(accessVertex, new ArrayList(1));
            this.connectoidsByAccessVertex.get(accessVertex).add((Connectoid)connectoid);
        }
    }

    protected void removeConnectoidsWithAccessVertex(Vertex vertex) {
        if (this.connectoidsByAccessVertex.containsKey(vertex)) {
            ArrayList<Connectoid> connectoids = this.connectoidsByAccessVertex.get(vertex);
            for (Connectoid connectoid : connectoids) {
                if (connectoid instanceof UndirectedConnectoid) {
                    this.zoning.getOdConnectoids().remove((Object)((UndirectedConnectoid)connectoid));
                    this.removedConnectoids = true;
                } else if (connectoid instanceof DirectedConnectoid) {
                    this.zoning.getTransferConnectoids().remove((Object)((DirectedConnectoid)connectoid));
                    this.removedConnectoids = true;
                } else {
                    LOGGER.severe(String.format("unknown connectoid type used on vertex %d", vertex.getId()));
                    continue;
                }
                this.connectoidsByAccessVertex.remove(connectoid.getAccessVertex());
            }
        }
    }

    protected void afterSubGraphRemovalComplete() {
        if (this.removedConnectoids) {
            this.zoning.getZoningModifier().recreateConnectoidIds();
        }
        this.removedConnectoids = false;
    }

    public UpdateConnectoidsOnVertexRemovalHandler(Zoning zoning) {
        this.zoning = zoning;
        this.initialiseIndices();
    }

    public EventType[] getKnownSupportedEventTypes() {
        return new EventType[]{RemoveSubGraphVertexEvent.EVENT_TYPE, RemoveSubGraphEvent.EVENT_TYPE};
    }

    public void onGraphModificationEvent(GraphModificationEvent event) {
        if (event.getType().equals((Object)RemoveSubGraphVertexEvent.EVENT_TYPE)) {
            this.removeConnectoidsWithAccessVertex(((RemoveSubGraphVertexEvent)((Object)RemoveSubGraphVertexEvent.class.cast(event))).getRemovedVertex());
        } else if (event.getType().equals((Object)RemoveSubGraphEvent.EVENT_TYPE)) {
            this.afterSubGraphRemovalComplete();
        } else {
            LOGGER.warning(String.format("%s invoked for unsupported event", UpdateConnectoidsOnVertexRemovalHandler.class.getName()));
        }
    }

    public void onDirectedGraphModificationEvent(DirectedGraphModificationEvent event) {
        LOGGER.warning(String.format("%s only supports graph modification events", UpdateConnectoidsOnVertexRemovalHandler.class.getName()));
    }
}

