/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning.modifier;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.modifier.ZoningModifier;
import org.goplanit.utils.zoning.modifier.event.ZoningModificationEvent;
import org.goplanit.utils.zoning.modifier.event.ZoningModifierEventType;
import org.goplanit.utils.zoning.modifier.event.ZoningModifierListener;
import org.goplanit.zoning.Zoning;
import org.goplanit.zoning.modifier.event.ModifiedZoneIdsEvent;
import org.goplanit.zoning.modifier.event.RecreatedZoningEntitiesManagedIdsEvent;

public class ZoningModifierImpl
extends EventProducerImpl
implements ZoningModifier {
    private static final Logger LOGGER = Logger.getLogger(ZoningModifierImpl.class.getCanonicalName());
    protected final Zoning zoning;

    private void addInternalEventListeners() {
        this.addListener((ZoningModifierListener)this.zoning.getOdConnectoids());
        this.addListener((ZoningModifierListener)this.zoning.getTransferConnectoids());
        this.addListener((ZoningModifierListener)this.zoning.getTransferZoneGroups());
    }

    protected void fireEvent(EventListener eventListener, Event event) {
        ((ZoningModifierListener)eventListener).onZoningModifierEvent((ZoningModificationEvent)event);
    }

    protected void removeZone(Zone toRemove) {
        if (toRemove instanceof OdZone) {
            this.zoning.getOdZones().remove((Object)((OdZone)toRemove));
        } else if (toRemove instanceof TransferZone) {
            this.zoning.getTransferZones().remove((Object)((TransferZone)toRemove));
        } else {
            LOGGER.severe(String.format("Unsupported zone %s to be removed by zoning modifier, ignored", Zone.class.getCanonicalName()));
        }
    }

    protected void recreateOdZoneIds(boolean resetIds) {
        this.zoning.getOdZones().recreateIds(resetIds);
        this.fireEvent((Event)new RecreatedZoningEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)this.zoning.getOdZones()));
    }

    protected void recreateTransferZoneIds(boolean resetIds) {
        this.zoning.getTransferZones().recreateIds(resetIds);
        this.fireEvent((Event)new RecreatedZoningEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)this.zoning.getTransferZones()));
    }

    public ZoningModifierImpl(Zoning zoning) {
        this.zoning = zoning;
        this.addInternalEventListeners();
    }

    public void recreateConnectoidIds() {
        boolean recreateManagedIdClass = true;
        this.zoning.getOdConnectoids().recreateIds(recreateManagedIdClass);
        this.fireEvent((Event)new RecreatedZoningEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)this.zoning.getOdConnectoids()));
        recreateManagedIdClass = false;
        this.zoning.getTransferConnectoids().recreateIds(recreateManagedIdClass);
        this.fireEvent((Event)new RecreatedZoningEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)this.zoning.getTransferConnectoids()));
    }

    public void recreateZoneIds() {
        this.recreateOdZoneIds(true);
        this.recreateTransferZoneIds(false);
        this.fireEvent((Event)new ModifiedZoneIdsEvent(this, this.zoning));
    }

    public void recreateTransferZoneGroupIds() {
        this.zoning.getTransferZoneGroups().recreateIds();
        this.fireEvent((Event)new RecreatedZoningEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)this.zoning.getTransferZoneGroups()));
    }

    public void removeDanglingTransferZones(boolean recreateZoneIds) {
        HashSet danglingZones = new HashSet(this.zoning.getTransferZones().toCollection());
        this.zoning.getTransferConnectoids().forEach(connectoid -> danglingZones.removeAll(connectoid.getAccessZones()));
        if (!danglingZones.isEmpty()) {
            for (Zone danglingZone : danglingZones) {
                this.removeZone(danglingZone);
                if (!(danglingZone instanceof TransferZone)) continue;
                ((TransferZone)danglingZone).removeFromAllTransferZoneGroups();
            }
            if (recreateZoneIds) {
                this.recreateZoneIds();
            }
            LOGGER.info(String.format("%sRemoved %d dangling transfer zones", LoggingUtils.zoningPrefix((long)this.zoning.getId()), danglingZones.size()));
        }
    }

    public void removeDanglingOdZones(boolean recreateZoneIds) {
        HashSet danglingZones = new HashSet(this.zoning.getOdZones().toCollection());
        this.zoning.getOdConnectoids().forEach(connectoid -> danglingZones.removeAll(connectoid.getAccessZones()));
        if (!danglingZones.isEmpty()) {
            for (Zone danglingZone : danglingZones) {
                this.removeZone(danglingZone);
                if (!recreateZoneIds) continue;
                this.recreateZoneIds();
            }
            LOGGER.info(String.format("%sRemoved %d dangling OD zones", LoggingUtils.zoningPrefix((long)this.zoning.getId()), danglingZones.size()));
        }
    }

    public void removeDanglingZones() {
        this.removeDanglingTransferZones(false);
        this.removeDanglingOdZones(true);
    }

    public void removeDanglingTransferZoneGroups() {
        LongAdder counter = new LongAdder();
        Iterator iterator = this.zoning.getTransferZoneGroups().iterator();
        while (iterator.hasNext()) {
            TransferZoneGroup group = (TransferZoneGroup)iterator.next();
            if (!group.isEmpty()) continue;
            iterator.remove();
            counter.increment();
        }
        if (counter.longValue() > 0L) {
            this.recreateTransferZoneGroupIds();
            LOGGER.info(String.format("%sRemoved %d dangling transfer zone groups", LoggingUtils.zoningPrefix((long)this.zoning.getId()), counter.longValue()));
        }
    }

    public void removeUnusedTransferConnectoids(ServiceNetworkLayers serviceNetworkLayers, boolean recreateManagedConnectoidIds) {
        List physicalLayers = serviceNetworkLayers.stream().map(snl -> snl.getParentNetworkLayer()).collect(Collectors.toList());
        Map transferConnectoidsByPhysicalLayer = this.zoning.getTransferConnectoids().groupByPhysicalLayerAndCustomKey(physicalLayers, DirectedConnectoid::getAccessNode);
        LongAdder counter = new LongAdder();
        for (ServiceNetworkLayer serviceNetworkLayer : serviceNetworkLayers) {
            Map serviceNodesByPhysicalNodes = serviceNetworkLayer.getServiceNodes().groupBy(sn -> sn.getPhysicalParentNodes());
            serviceNodesByPhysicalNodes.remove(null);
            Map transferConnectoidsByPhysicalAccessNodeToRemove = (Map)transferConnectoidsByPhysicalLayer.get(serviceNetworkLayer.getParentNetworkLayer());
            Set physicalNodesWithServices = serviceNodesByPhysicalNodes.keySet();
            physicalNodesWithServices.stream().flatMap(e -> e.stream()).forEach(accessNode -> transferConnectoidsByPhysicalAccessNodeToRemove.remove(accessNode));
            if (transferConnectoidsByPhysicalAccessNodeToRemove == null || !transferConnectoidsByPhysicalAccessNodeToRemove.isEmpty()) continue;
            transferConnectoidsByPhysicalAccessNodeToRemove.values().stream().flatMap(l -> l.stream()).forEach(transferConnectoidToRemove -> this.zoning.getTransferConnectoids().remove(transferConnectoidToRemove));
            counter.add(transferConnectoidsByPhysicalAccessNodeToRemove.values().stream().collect(Collectors.summingInt(l -> l.size())).intValue());
        }
        if (recreateManagedConnectoidIds) {
            this.recreateConnectoidIds();
        }
        LOGGER.info(String.format("%sRemoved %d unused transfer connectoids", LoggingUtils.zoningPrefix((long)this.zoning.getId()), counter.longValue()));
    }

    public void recreateManagedIdEntities() {
        this.recreateConnectoidIds();
        this.recreateZoneIds();
        this.recreateTransferZoneGroupIds();
    }

    public void addListener(ZoningModifierListener listener) {
        super.addListener((EventListener)listener);
    }

    public void addListener(ZoningModifierListener listener, ZoningModifierEventType eventType) {
        super.addListener((EventListener)listener, new EventType[]{eventType});
    }

    public void removeListener(ZoningModifierListener listener, ZoningModifierEventType eventType) {
        super.removeListener((EventListener)listener, (EventType)eventType);
    }

    public void removeListener(ZoningModifierListener listener) {
        super.removeListener((EventListener)listener);
    }
}

